/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.response;

import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cmutils.url.CMURLEncoder;
import com.ibm.cognos.cm.repositoryService.response.AtomResponder;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import java.util.Calendar;
import org.apache.abdera.writer.StreamWriter;

public class ReportVersionsResponder
extends AtomResponder {
    final String reportID;
    final String dataSourceID;

    public ReportVersionsResponder(URIResource resource, String gatewayConfigURL) {
        super(resource, gatewayConfigURL);
        this.reportID = resource.getResourceId(ResourceName.REPORT);
        this.dataSourceID = resource.getResourceId(ResourceName.REPOSITORY);
    }

    ReportVersionsResponder(String dataSourceID, String reportID, StreamWriter writer, String gatewayConfigURL, Integer pagesize, Integer skip) {
        super(writer, gatewayConfigURL, pagesize, skip);
        this.reportID = reportID;
        this.dataSourceID = dataSourceID;
    }

    @Override
    protected String getFeedID() {
        return "tag:ibm.com,2012:" + CMURLEncoder.encode((String)this.reportID);
    }

    @Override
    protected String getBaseLink() {
        StringBuilder selfURIBuilder = new StringBuilder();
        selfURIBuilder.append(this.gatewayURL);
        selfURIBuilder.append("/");
        selfURIBuilder.append((Object)ResourceName.ROOT);
        selfURIBuilder.append("/");
        selfURIBuilder.append((Object)ResourceName.REPOSITORY);
        selfURIBuilder.append("/");
        selfURIBuilder.append(this.dataSourceID);
        selfURIBuilder.append("/");
        selfURIBuilder.append((Object)ResourceName.REPORT);
        selfURIBuilder.append("/");
        selfURIBuilder.append(this.reportID);
        return selfURIBuilder.toString();
    }

    @Override
    protected String getFeedTitle() {
        return this.reportID;
    }

    @Override
    protected void writeEntry(IQueryResultObjects object) {
        String objectID = object.getPropertyValue("repositoryObjectId").toString();
        Object description = object.getPropertyValue("defaultDescription");
        this.feedWriter.startEntry();
        this.feedWriter.writeTitle(objectID);
        this.feedWriter.writeId("tag:ibm.com,2012:" + CMURLEncoder.encode((String)objectID));
        this.feedWriter.writeUpdated(((Calendar)object.getPropertyValue("creationTime")).getTime());
        if (this.isNullOrEmpty(description)) {
            this.feedWriter.writeSummary("");
        } else {
            this.feedWriter.writeSummary(description.toString());
        }
        String linkURL = this.buildVersionOutputsURL(objectID);
        this.feedWriter.writeLink(linkURL, "alternate", "application/atom+xml");
        this.feedWriter.startContent("application/atom+xml");
        this.feedWriter.writeAttribute("src", linkURL);
        this.feedWriter.endContent();
        this.feedWriter.endEntry();
    }

    private String buildVersionOutputsURL(String versionID) {
        return this.buildVersionOutputsURL(this.dataSourceID, this.reportID, versionID);
    }
}

