/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.response;

import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cmutils.url.CMURLEncoder;
import com.ibm.cognos.cm.repositoryService.response.AtomResponder;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import org.apache.abdera.writer.StreamWriter;

public class RepositoryReportResponder
extends AtomResponder {
    private final String reportID;

    RepositoryReportResponder(StreamWriter writer, String gatewayConfigURL, Integer pageSize, Integer skip, URIResource resource) {
        super(writer, gatewayConfigURL, pageSize, skip);
        this.reportID = resource.getResourceId(ResourceName.REPORT);
    }

    public RepositoryReportResponder(URIResource resource, String gatewayConfigURL) {
        super(resource, gatewayConfigURL);
        this.reportID = resource.getResourceId(ResourceName.REPORT);
    }

    @Override
    protected String getFeedID() {
        return "tag:ibm.com,2012:" + CMURLEncoder.encode((String)this.reportID);
    }

    @Override
    protected String getBaseLink() {
        StringBuilder selfURIBuilder = new StringBuilder();
        selfURIBuilder.append(this.gatewayURL);
        selfURIBuilder.append("/");
        selfURIBuilder.append((Object)ResourceName.ROOT);
        selfURIBuilder.append("/");
        selfURIBuilder.append((Object)ResourceName.REPORT);
        selfURIBuilder.append("/");
        selfURIBuilder.append(this.reportID);
        return selfURIBuilder.toString();
    }

    @Override
    protected String getFeedTitle() {
        return this.reportID;
    }

    @Override
    protected void writeEntry(IQueryResultObjects object) {
        String reportURL = (String)object.getPropertyValue("reportURI");
        String repositoryID = (String)object.getPropertyValue("repositoryID");
        if (reportURL != null && repositoryID != null) {
            this.feedWriter.startEntry();
            this.feedWriter.writeTitle(repositoryID);
            this.feedWriter.writeId(this.buildEntryID(repositoryID));
            if (!repositoryID.isEmpty()) {
                this.feedWriter.writeSummary(repositoryID);
            }
            String linkURL = this.buildGatewayReportURL(reportURL);
            this.feedWriter.writeLink(linkURL, "alternate", "application/atom+xml");
            this.feedWriter.startContent("application/atom+xml");
            this.feedWriter.writeAttribute("src", linkURL);
            this.feedWriter.endContent();
            this.feedWriter.endEntry();
        }
    }

    private String buildEntryID(String repositoryID) {
        StringBuilder buffer = new StringBuilder("tag:ibm.com,2012:");
        buffer.append(CMURLEncoder.encode((String)repositoryID)).append("_");
        buffer.append(CMURLEncoder.encode((String)this.reportID));
        return buffer.toString();
    }

    private String buildGatewayReportURL(String reportURL) {
        StringBuilder selfURIBuilder = new StringBuilder();
        selfURIBuilder.append(this.gatewayURL);
        selfURIBuilder.append(reportURL);
        return selfURIBuilder.toString();
    }
}

