/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.response;

import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cmutils.url.CMURLEncoder;
import com.ibm.cognos.cm.repositoryService.response.AtomResponder;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.apache.abdera.model.Text;
import org.apache.abdera.writer.StreamWriter;

public class VersionOutputsResponder
extends AtomResponder {
    private static final String emailMHTFormat = "MHT";
    private static final String ldxFormat = "layoutDataXML";
    final String dataSourceID;
    final String versionID;
    final String reportID;

    public VersionOutputsResponder(URIResource resource, String gatewayConfigURL) {
        super(resource, gatewayConfigURL);
        this.dataSourceID = resource.getResourceId(ResourceName.REPOSITORY);
        this.versionID = resource.getResourceId(ResourceName.REPORTVERSION);
        this.reportID = resource.getResourceId(ResourceName.REPORT);
    }

    VersionOutputsResponder(String dataSourceID, String versionID, String reportID, StreamWriter writer, String gatewayConfigURL, Integer pagesize, Integer skip) {
        super(writer, gatewayConfigURL, pagesize, skip);
        this.dataSourceID = dataSourceID;
        this.versionID = versionID;
        this.reportID = reportID;
    }

    @Override
    protected void writeEntry(IQueryResultObjects objects) {
        String objectID = objects.getPropertyValue("repositoryObjectId").toString();
        String encodedObjectID = CMURLEncoder.encode((String)objectID);
        Object dataPath = objects.getPropertyValue("outputRepositoryURL");
        String format = objects.getPropertyValue("format").toString();
        String objectURL = this.buildOutputURL(encodedObjectID, dataPath);
        Object description = objects.getPropertyValue("defaultDescription");
        Object locale = objects.getPropertyValue("locale");
        Object burstKey = objects.getPropertyValue("burstKey");
        String contentType = (String)objects.getPropertyValue("contentType");
        contentType = contentType != null ? contentType : "application/octet-stream";
        this.feedWriter.startEntry();
        this.feedWriter.writeId("tag:ibm.com,2012:" + objectID);
        this.feedWriter.writeTitle(format);
        this.feedWriter.writeText(new QName("http://www.ibm.com/xmlns/prod/cognos/repositoryServiceAtom/201204", "objectID"), Text.Type.TEXT, objectID);
        if (!this.isNullOrEmpty(description)) {
            this.feedWriter.writeSummary(description.toString());
        } else {
            this.feedWriter.writeSummary("");
        }
        this.feedWriter.writeUpdated(((Calendar)objects.getPropertyValue("creationTime")).getTime());
        if (!this.isEnhancedUserFeatureOutput(format)) {
            this.feedWriter.writeLink(objectURL, "alternate", contentType);
        }
        this.feedWriter.startContent(contentType);
        this.feedWriter.writeAttribute("src", objectURL);
        this.feedWriter.endContent();
        this.feedWriter.writeText(new QName("http://www.ibm.com/xmlns/prod/cognos/repositoryServiceAtom/201204", "format"), Text.Type.TEXT, format);
        if (locale != null) {
            this.feedWriter.writeText(new QName("http://www.ibm.com/xmlns/prod/cognos/repositoryServiceAtom/201204", "locale"), Text.Type.TEXT, locale.toString());
        }
        if (burstKey != null) {
            this.feedWriter.writeText(new QName("http://www.ibm.com/xmlns/prod/cognos/repositoryServiceAtom/201204", "burstKey"), Text.Type.TEXT, burstKey.toString());
        }
        this.feedWriter.endEntry();
    }

    private boolean isEnhancedUserFeatureOutput(String format) {
        return format.equals(emailMHTFormat) || format.equals(ldxFormat);
    }

    private String buildOutputURL(String objectID, Object dataPath) {
        StringBuilder buffer = new StringBuilder();
        this.appendGateway(buffer);
        if (this.isNullOrEmpty(dataPath)) {
            this.appendOutputURI(buffer, objectID);
        } else {
            this.appendOuputDataPath(buffer, dataPath.toString());
        }
        return buffer.toString();
    }

    private StringBuilder appendGateway(StringBuilder buffer) {
        if (this.gatewayURL != null) {
            buffer.append(this.gatewayURL);
        }
        if (this.gatewayURL == null || !this.gatewayURL.endsWith("/")) {
            buffer.append("/");
        }
        return buffer;
    }

    private StringBuilder appendOutputURI(StringBuilder buffer, String repositoryOutputId) {
        buffer.append((Object)ResourceName.ROOT).append("/");
        buffer.append((Object)ResourceName.REPOSITORY).append("/");
        buffer.append(this.dataSourceID).append("/");
        buffer.append((Object)ResourceName.REPORT).append("/");
        buffer.append(this.reportID).append("/");
        buffer.append((Object)ResourceName.OUTPUT).append("/");
        buffer.append(repositoryOutputId).append("/");
        buffer.append("content");
        return buffer;
    }

    private StringBuilder appendOuputDataPath(StringBuilder buffer, String dataPath) {
        if (dataPath.startsWith("/")) {
            buffer.append(dataPath.substring(1));
        } else {
            buffer.append(dataPath);
        }
        return buffer;
    }

    @Override
    protected String getBaseLink() {
        return this.buildVersionOutputsURL(this.dataSourceID, this.reportID, this.versionID);
    }

    @Override
    protected String getFeedID() {
        return "tag:ibm.com,2012:" + CMURLEncoder.encode((String)this.versionID);
    }

    @Override
    protected String getFeedTitle() {
        return this.versionID;
    }
}

