/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.rest;

import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.IPluginResourceLoader;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.HTTPHeaders;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.authorization.AuthorizationAdapter;
import com.ibm.cognos.cm.repositoryService.connection.RepositoryConnectionProvider;
import com.ibm.cognos.cm.repositoryService.query.RepositoryQuery;
import com.ibm.cognos.cm.repositoryService.response.BaseResponder;
import com.ibm.cognos.cm.repositoryService.response.Responder;
import com.ibm.cognos.cm.repositoryService.rest.ResourceRequestHandler;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import com.ibm.cognos.cm.repositoryService.rest.resource.ServiceResource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RepositoryResourceRequestHandler
implements ResourceRequestHandler {
    private static final String PROP_4AUDIT_CONTENT_TYPE = "4audit.content-type";
    private static final String CONTENT_TYPE = "content-type";
    private static Log log = LogFactory.getLog(RepositoryResourceRequestHandler.class);
    private final Responder responder;
    private final RepositoryQuery query;
    private final ServiceResource resource;
    private AuthorizationAdapter authorizationAdapter;
    private IPluginResourceLoader resourceLoader;

    RepositoryResourceRequestHandler(ServiceResource resource, Responder responder, RepositoryQuery query) {
        this.responder = responder;
        this.query = query;
        this.resource = resource;
    }

    @Override
    public void handle(MessageContext mc, RepositoryConnectionProvider connectionProvider) throws RepositoryException {
        IQueryResult result;
        RepositoryConnection connection = null;
        String dataSourceID = this.resource.getDataSourceID();
        if (dataSourceID != null && !dataSourceID.isEmpty()) {
            connection = connectionProvider.getConnection(dataSourceID, mc, this.resourceLoader);
        }
        if (this.resource.isTraverseAccessCheckRequired()) {
            this.checkTraverseAccessToResource(mc, connection);
        }
        if (this.isValidResult(result = this.query.execute(connection))) {
            IQueryResultObjects objects = result.getObjects();
            this.extractContentTypeForAudit(objects, mc);
        }
        this.responder.respond(result, mc, this.authorizationAdapter);
    }

    private void checkTraverseAccessToResource(MessageContext context, RepositoryConnection connection) throws RepositoryException {
        String resourceId = this.resource.getAuthorizationResourceID();
        if (!"cm".equalsIgnoreCase(resourceId)) {
            boolean isAccessGranted = this.authorizationAdapter.isGrantedAccess(resourceId, "traverse", context, connection);
            if (context.isFaulted() || !isAccessGranted) {
                log.error((Object)("Permission denied for resource: " + resourceId));
                throw new ResourceException(404, new Message((Resource.Id)RepositoryServiceErrors.REPS_CM.repositoryObjectNotFound));
            }
        }
    }

    @Override
    public void setResourceLoader(IPluginResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void setAuthorizationAdapter(AuthorizationAdapter authorizationAdapter) {
        this.authorizationAdapter = authorizationAdapter;
    }

    Responder getResponder() {
        return this.responder;
    }

    RepositoryQuery getQuery() {
        return this.query;
    }

    private void extractContentTypeForAudit(IQueryResultObjects objects, MessageContext mc) {
        objects.next();
        HTTPHeaders headers = BaseResponder.extractHeaders(objects);
        String contentType = headers.get(CONTENT_TYPE);
        if (StringUtils.isNotEmpty((String)contentType)) {
            mc.setProperty(PROP_4AUDIT_CONTENT_TYPE, (Object)contentType);
        }
        objects.reset();
    }

    private boolean isValidResult(IQueryResult result) {
        if (result != null) {
            IQueryResultObjects objects = result.getObjects();
            return objects != null && objects.size() > 0;
        }
        return false;
    }
}

