/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.rest;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cm.client.cmapi.HttpCommandFactory;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.IPluginResourceLoader;
import com.cognos.cm.repositoryPluginFramework.QueryParameter;
import com.cognos.cm.repositoryPluginFramework.identity.ExternalIdentityProvider;
import com.cognos.cm.repositoryPluginFramework.identity.IdentityProvider;
import com.cognos.cmutils.http.HttpMethodFactory;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.ByteRangeProcessor;
import com.ibm.cognos.cm.repositoryService.authorization.AuthorizationAdapter;
import com.ibm.cognos.cm.repositoryService.cache.Cache;
import com.ibm.cognos.cm.repositoryService.cache.CacheProvider;
import com.ibm.cognos.cm.repositoryService.cache.CacheType;
import com.ibm.cognos.cm.repositoryService.connection.RepositoryConnectionProvider;
import com.ibm.cognos.cm.repositoryService.query.CacheQuery;
import com.ibm.cognos.cm.repositoryService.query.GetObjectContent;
import com.ibm.cognos.cm.repositoryService.query.GetOutputContent;
import com.ibm.cognos.cm.repositoryService.query.GetOutputFileList;
import com.ibm.cognos.cm.repositoryService.query.GetReportVersions;
import com.ibm.cognos.cm.repositoryService.query.GetVersionOutputs;
import com.ibm.cognos.cm.repositoryService.query.MemoryCachePost;
import com.ibm.cognos.cm.repositoryService.query.MemoryCacheQuery;
import com.ibm.cognos.cm.repositoryService.query.NoOpQuery;
import com.ibm.cognos.cm.repositoryService.query.QueryParameterNames;
import com.ibm.cognos.cm.repositoryService.query.RedirectQuery;
import com.ibm.cognos.cm.repositoryService.query.RepositoryQuery;
import com.ibm.cognos.cm.repositoryService.query.RepositoryReportQuery;
import com.ibm.cognos.cm.repositoryService.query.RepositoryServiceQueryParameters;
import com.ibm.cognos.cm.repositoryService.response.BaseResponder;
import com.ibm.cognos.cm.repositoryService.response.ByteServingResponder;
import com.ibm.cognos.cm.repositoryService.response.CachedContentResponder;
import com.ibm.cognos.cm.repositoryService.response.ContentResponder;
import com.ibm.cognos.cm.repositoryService.response.CreatedResponder;
import com.ibm.cognos.cm.repositoryService.response.DefaultOutputResponder;
import com.ibm.cognos.cm.repositoryService.response.MHTContentResponder;
import com.ibm.cognos.cm.repositoryService.response.OutputFileListResponder;
import com.ibm.cognos.cm.repositoryService.response.RedirectResponder;
import com.ibm.cognos.cm.repositoryService.response.ReportVersionsResponder;
import com.ibm.cognos.cm.repositoryService.response.RepositoryReportResponder;
import com.ibm.cognos.cm.repositoryService.response.Responder;
import com.ibm.cognos.cm.repositoryService.response.VersionOutputsResponder;
import com.ibm.cognos.cm.repositoryService.rest.HTTPMethodType;
import com.ibm.cognos.cm.repositoryService.rest.RepositoryResourceRequestHandler;
import com.ibm.cognos.cm.repositoryService.rest.RequestHandlerFactory;
import com.ibm.cognos.cm.repositoryService.rest.ResourceRequestHandler;
import com.ibm.cognos.cm.repositoryService.rest.resource.OutputRequestType;
import com.ibm.cognos.cm.repositoryService.rest.resource.RepositoryServiceResourceFactory;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import com.ibm.cognos.cm.repositoryService.rest.resource.ServiceResource;
import com.ibm.cognos.cm.repositoryService.rest.resource.ServiceResourceFactory;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import java.util.HashMap;
import java.util.List;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Element;

public class RepositoryServiceHandlerFactory
implements RequestHandlerFactory {
    private static final String ADVANCED_PROPERTIES = "advancedProperties";
    private static final String WEBCONTENT_PROP = "repository.webcontentRoot";
    private static final RequestHandlerFactory INSTANCE = new RepositoryServiceHandlerFactory();
    private final ServiceResourceFactory serviceResourceFactory;
    private final CacheProvider cacheProvider;
    private static volatile IdentityProvider identityProvider;
    private static HashMap<String, String> advancedProperties;

    RepositoryServiceHandlerFactory() {
        this(RepositoryServiceResourceFactory.getInstance(), CacheProvider.getInstance());
    }

    RepositoryServiceHandlerFactory(ServiceResourceFactory serviceResourceFactory, CacheProvider cacheProvider) {
        this.serviceResourceFactory = serviceResourceFactory;
        this.cacheProvider = cacheProvider;
        advancedProperties = new HashMap();
    }

    @Override
    public ResourceRequestHandler create(HttpMethodFactory httpMethodFactory, String uri, MessageContext context, String gateway, RepositoryConnectionProvider connectionProvider, IPluginResourceLoader resourceLoader, AuthorizationAdapter authorizationAdapter) throws RepositoryException {
        ServiceResource requestedResource = this.createResource(uri, context, connectionProvider, resourceLoader);
        InternetHeaders requestHeaders = (InternetHeaders)context.getProperty("request.headers");
        Responder responder = this.createResponder(httpMethodFactory, requestedResource, this.getRangeHeader(requestHeaders), gateway);
        RepositoryQuery query = this.createQuery(requestedResource, httpMethodFactory, context, this.cacheProvider.get(CacheType.REPOSITORY), authorizationAdapter);
        return new RepositoryResourceRequestHandler(requestedResource, responder, query);
    }

    private ServiceResource createResource(String urlPath, MessageContext messageContext, RepositoryConnectionProvider connectionProvider, IPluginResourceLoader resourceLoader) throws RepositoryException {
        return this.serviceResourceFactory.create(urlPath, connectionProvider, messageContext, resourceLoader);
    }

    private Responder createResponder(HttpMethodFactory httpMethodFactory, ServiceResource requestedResource, String rangeHeader, String gatewayConfigURL) throws RepositoryException {
        URIResource uriResource = requestedResource.getURIResource();
        ResourceName resourceName = uriResource.getResourceName();
        Responder responder = null;
        boolean isDownload = this.isDownload(uriResource);
        switch (resourceName) {
            case OUTPUT: {
                if (this.isRequestForDefaultOutput(requestedResource)) {
                    responder = new DefaultOutputResponder(gatewayConfigURL, requestedResource);
                    break;
                }
                responder = this.getOutputResponder(httpMethodFactory, requestedResource, rangeHeader, gatewayConfigURL, uriResource, isDownload);
                break;
            }
            case REPORT: {
                ResourceName parentResourceName = uriResource.getParentResource().getResourceName();
                if (ResourceName.ROOT.equals((Object)parentResourceName)) {
                    responder = new RepositoryReportResponder(uriResource, gatewayConfigURL);
                    break;
                }
                responder = new ReportVersionsResponder(uriResource, gatewayConfigURL);
                break;
            }
            case REPORTVERSION: {
                responder = new VersionOutputsResponder(uriResource, gatewayConfigURL);
                break;
            }
            case CACHE: {
                if (HTTPMethodType.GET.equals((Object)uriResource.getHTTPMethodType())) {
                    if (rangeHeader == null) {
                        responder = new ContentResponder(httpMethodFactory, isDownload);
                        break;
                    }
                    ContentResponder contentResponder = new ContentResponder(httpMethodFactory);
                    ByteRangeProcessor byteRangeProcessor = new ByteRangeProcessor(rangeHeader);
                    responder = new ByteServingResponder(contentResponder, byteRangeProcessor);
                    break;
                }
                responder = new CreatedResponder(gatewayConfigURL, uriResource.toString());
                break;
            }
            default: {
                responder = new CachedContentResponder(httpMethodFactory, this.cacheProvider.get(CacheType.REPOSITORY), requestedResource.getCacheID(), isDownload);
            }
        }
        return responder;
    }

    private boolean isRequestForDefaultOutput(ServiceResource requestedResource) {
        return "default".equals(requestedResource.getResourceID()) && "cm".equals(requestedResource.getDataSourceID());
    }

    private Responder getOutputResponder(HttpMethodFactory httpMethodFactory, ServiceResource requestedResource, String rangeHeader, String gatewayConfigURL, URIResource uriResource, boolean asAttachment) {
        BaseResponder responder;
        OutputRequestType requestType = OutputRequestType.valueOf(uriResource.getParameter("outputRequestType"));
        if (OutputRequestType.EXTERNAL == requestType) {
            responder = new RedirectResponder(gatewayConfigURL, advancedProperties.get(WEBCONTENT_PROP));
        } else if (OutputRequestType.FILELIST == requestType) {
            responder = new OutputFileListResponder(uriResource, gatewayConfigURL);
        } else {
            ContentResponder contentResponder = OutputRequestType.MHT_CONTENT == requestType ? new MHTContentResponder(httpMethodFactory, this.cacheProvider.get(CacheType.REPOSITORY), requestedResource, asAttachment) : new CachedContentResponder(httpMethodFactory, this.cacheProvider.get(CacheType.REPOSITORY), requestedResource.getCacheID(), asAttachment);
            if (rangeHeader != null) {
                ByteRangeProcessor byteRangeProcessor = new ByteRangeProcessor(rangeHeader);
                responder = new ByteServingResponder(contentResponder, byteRangeProcessor);
            } else {
                responder = contentResponder;
            }
        }
        return responder;
    }

    private boolean isDownload(URIResource uriResource) {
        String download = uriResource.getParameter(QueryParameterNames.DOWNLOAD.name());
        boolean isDownload = download != null ? Boolean.valueOf(download) : false;
        return isDownload;
    }

    private RepositoryQuery createQuery(ServiceResource serviceResource, HttpMethodFactory httpMethodFactory, MessageContext context, Cache cache, AuthorizationAdapter authorizationAdapter) throws RepositoryException {
        URIResource uriResource = serviceResource.getURIResource();
        ResourceName resourceName = uriResource.getResourceName();
        RepositoryQuery query = null;
        switch (resourceName) {
            case OUTPUT: {
                String requestType = uriResource.getParameter("outputRequestType");
                if (this.isRequestForContent(requestType)) {
                    RepositoryQuery outputQuery = this.createGetOutputQuery(uriResource, context);
                    query = this.createCacheQuery(serviceResource, outputQuery, context, cache, authorizationAdapter);
                    break;
                }
                if (this.isRequestForFileList(requestType)) {
                    query = this.createGetOutputFileListQuery(uriResource, context);
                    break;
                }
                query = new RedirectQuery(uriResource);
                break;
            }
            case OBJECT: {
                RepositoryQuery objectQuery = this.createGetObjectQuery(uriResource, context);
                query = this.createCacheQuery(serviceResource, objectQuery, context, cache, authorizationAdapter);
                break;
            }
            case REPORT: {
                ResourceName parentResourceName = uriResource.getParentResource().getResourceName();
                if (ResourceName.ROOT.equals((Object)parentResourceName)) {
                    HttpCommandFactory commandFactory = new HttpCommandFactory(httpMethodFactory);
                    query = new RepositoryReportQuery(uriResource, commandFactory, context);
                    break;
                }
                query = new GetReportVersions(uriResource);
                break;
            }
            case REPORTVERSION: {
                Identity identity = this.getIdentity(context, httpMethodFactory);
                query = new GetVersionOutputs(uriResource, identity);
                break;
            }
            case CACHE: {
                if (HTTPMethodType.POST.equals((Object)uriResource.getHTTPMethodType())) {
                    query = new MemoryCachePost(context);
                    break;
                }
                query = new MemoryCacheQuery(uriResource);
                break;
            }
            default: {
                query = new NoOpQuery();
            }
        }
        return query;
    }

    boolean isRequestForContent(String requestType) {
        return OutputRequestType.CONTENT.name().equals(requestType) || OutputRequestType.FILE.name().equals(requestType) || OutputRequestType.MHT_CONTENT.name().equals(requestType);
    }

    boolean isRequestForFileList(String requestType) {
        return OutputRequestType.FILELIST.name().equals(requestType);
    }

    private RepositoryQuery createGetOutputQuery(URIResource uriResource, MessageContext context) {
        InternetHeaders headers = (InternetHeaders)context.getProperty("request.headers");
        RepositoryServiceQueryParameters params = new RepositoryServiceQueryParameters();
        this.mapHttpHeadersToQueryParameters(params, headers);
        URIResource parentResource = uriResource.getParentResource();
        if (parentResource != null && ResourceName.REPORT.equals((Object)parentResource.getResourceName())) {
            params.add("reportStoreID", parentResource.getResourceId());
        }
        this.prepareQueryParams(uriResource, params);
        return new GetOutputContent(uriResource.getResourceId(), uriResource.getParameter("fileClass"), uriResource.getParameter("fileName"), params);
    }

    private void prepareQueryParams(URIResource uriResource, RepositoryServiceQueryParameters params) {
        String formatHint = uriResource.getParameter("FORMAT_HINT");
        String localeHint = uriResource.getParameter("LOCALE_HINT");
        if (formatHint != null) {
            params.add("formatHint", formatHint);
        }
        if (localeHint != null) {
            params.add("localeHint", formatHint);
        }
    }

    private RepositoryQuery createGetObjectQuery(URIResource uriResource, MessageContext context) {
        InternetHeaders headers = (InternetHeaders)context.getProperty("request.headers");
        RepositoryServiceQueryParameters params = new RepositoryServiceQueryParameters();
        this.mapHttpHeadersToQueryParameters(params, headers);
        return new GetObjectContent(uriResource.getResourceId(), params);
    }

    private RepositoryQuery createGetOutputFileListQuery(URIResource uriResource, MessageContext context) {
        InternetHeaders headers = (InternetHeaders)context.getProperty("request.headers");
        RepositoryServiceQueryParameters params = new RepositoryServiceQueryParameters();
        this.mapHttpHeadersToQueryParameters(params, headers);
        URIResource parentResource = uriResource.getParentResource();
        if (parentResource != null && ResourceName.REPORT.equals((Object)parentResource.getResourceName())) {
            params.add("reportStoreID", parentResource.getResourceId());
        }
        return new GetOutputFileList(uriResource, params);
    }

    protected void mapHttpHeadersToQueryParameters(RepositoryServiceQueryParameters params, InternetHeaders headers) {
        IQueryParameter acceptEncoding = this.getHeaderAsParam(headers, "Accept-Encoding", "acceptEncoding");
        if (acceptEncoding != null) {
            params.put(acceptEncoding);
        }
    }

    private IQueryParameter getHeaderAsParam(InternetHeaders headers, String headerName, String paramName) {
        QueryParameter parameter = null;
        String[] values = headers.getHeader(headerName);
        if (values != null && values[0] != null) {
            parameter = new QueryParameter(paramName, (Object)values[0]);
        }
        return parameter;
    }

    private RepositoryQuery createCacheQuery(ServiceResource serviceResource, RepositoryQuery query, MessageContext messageContext, Cache cache, AuthorizationAdapter authorizationAdapter) {
        return new CacheQuery(serviceResource, query, messageContext, cache, authorizationAdapter);
    }

    private String getRangeHeader(InternetHeaders headers) {
        String[] rangeHeaderValues;
        String rangeHeader = null;
        if (headers != null && (rangeHeaderValues = headers.getHeader("Range")) != null && rangeHeaderValues.length > 0) {
            rangeHeader = rangeHeaderValues[0];
        }
        return rangeHeader;
    }

    private Identity getIdentity(MessageContext context, HttpMethodFactory httpMethodFactory) throws RepositoryException {
        IdentityProvider identityProvider = RepositoryServiceHandlerFactory.getIdentityProvider(httpMethodFactory);
        return identityProvider.getIdentity(context);
    }

    private static synchronized IdentityProvider getIdentityProvider(HttpMethodFactory httpMethodFactory) {
        if (identityProvider == null) {
            HttpCommandFactory commandFactory = new HttpCommandFactory(httpMethodFactory);
            identityProvider = new ExternalIdentityProvider();
            identityProvider.setCommandFactory(commandFactory);
        }
        return identityProvider;
    }

    public static RequestHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public void configure(Configuration configuration) {
        try {
            Element el = configuration.getICCLConfiguration().getValueElement(ADVANCED_PROPERTIES, true);
            if (el == null) {
                return;
            }
            List params = el.elements();
            for (Element param : params) {
                String name = param.attributeValue("name");
                String value = param.elementText("value");
                advancedProperties.put(name, value);
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            // empty catch block
        }
    }
}

