/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.rest.resource;

import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.rest.HTTPMethodType;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import com.ibm.cognos.cm.repositoryService.rest.resource.SimpleURIResource;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import java.util.Iterator;

public class CachedResource
extends SimpleURIResource {
    private final HTTPMethodType method;

    public CachedResource(URIResource parent, HTTPMethodType method) {
        super(parent, ResourceName.CACHE, false);
        this.method = method;
    }

    @Override
    public void process(Iterator<String> tokenIterator) {
        if (tokenIterator.hasNext()) {
            this.resourceId = tokenIterator.next();
        }
        if (!"imc".equals(this.getParentResource().getResourceId())) {
            Message message = new Message((Resource.Id)RepositoryServiceErrors.REPS_DET.repositoryInvalidPart);
            message.param("part", this.getParentResource().getResourceId());
            ResourceException e = new ResourceException(400, message);
            e.addDetail(RepositoryServiceErrors.REPS_REP.repositoryInvalidURI);
            throw e;
        }
    }

    @Override
    public String toString() {
        return this.getParentResource().toString() + "/" + (Object)((Object)this.getResourceName()) + "/";
    }

    @Override
    public HTTPMethodType getHTTPMethodType() {
        return this.method;
    }
}

