/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.rest.resource;

import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.rest.resource.OutputRequestType;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import com.ibm.cognos.cm.repositoryService.rest.resource.SimpleURIResource;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import java.util.Iterator;

class ObjectURIResource
extends SimpleURIResource {
    private RepositoryConnection repositoryConnection;

    ObjectURIResource(URIResource parent, RepositoryConnection repositoryConnection) {
        super(parent, ResourceName.OBJECT, false);
        this.repositoryConnection = repositoryConnection;
    }

    @Override
    public void process(Iterator<String> tokenIterator) {
        if (tokenIterator.hasNext()) {
            String token = tokenIterator.next();
            if (this.repositoryConnection.validate(token)) {
                if (!this.isNextTokenContent(tokenIterator)) {
                    throw new ResourceException(403, new Message((Resource.Id)RepositoryServiceErrors.REPS_REP.repositoryForbiddenURI));
                }
                this.resourceId = token;
            } else {
                this.throwInvalidURIException();
            }
        } else {
            this.throwInvalidURIException();
        }
        this.putParameter("outputRequestType", OutputRequestType.CONTENT.name());
        this.putParameter("connectionTenantID", (String)this.repositoryConnection.getProperties().get("connectionTenantID"));
    }

    private boolean isNextTokenContent(Iterator<String> tokenIterator) {
        boolean result = false;
        if (tokenIterator.hasNext()) {
            String nextToken = tokenIterator.next();
            result = this.isContentResource(nextToken);
        }
        return result;
    }

    private void throwInvalidURIException() {
        Message message = new Message((Resource.Id)RepositoryServiceErrors.REPS_DET.repositoryBadRequestMissingResourceID);
        message.param("part", this.getResourceName().toString());
        ResourceException e = new ResourceException(400, message);
        e.addDetail(RepositoryServiceErrors.REPS_REP.repositoryInvalidURI);
        throw e;
    }

    private boolean isContentResource(String token) {
        return token.equals("content");
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getParentResource().toString());
        buffer.append("/").append((Object)this.getResourceName());
        buffer.append("/").append(this.getResourceId());
        buffer.append("/").append("content");
        return buffer.toString();
    }
}

