/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.rest.resource;

import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.query.QueryParameterNames;
import com.ibm.cognos.cm.repositoryService.rest.resource.OutputRequestType;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import com.ibm.cognos.cm.repositoryService.rest.resource.SimpleURIResource;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class OutputURIResource
extends SimpleURIResource {
    private static final String QUOTE_REGEX = "((%22)|(\"))";
    private static final Pattern QUOTE_PATTERN = Pattern.compile("((%22)|(\"))");
    private static final String EMPTY_STRING = "";
    private OutputRequestType requestType = null;
    private RepositoryConnection repositoryConnection;
    private String mhtFilePartName = null;

    OutputURIResource(URIResource parent, RepositoryConnection repositoryConnection) {
        super(parent, ResourceName.OUTPUT, false);
        this.repositoryConnection = repositoryConnection;
    }

    @Override
    public void process(Iterator<String> tokenIterator) {
        if (tokenIterator.hasNext()) {
            String token = tokenIterator.next();
            if (!this.repositoryConnection.validate(token)) {
                this.processExternalResource(token, tokenIterator);
            } else if (tokenIterator.hasNext()) {
                String nextToken = tokenIterator.next();
                if (this.isExternalResource(nextToken)) {
                    this.processExternalResource(nextToken, tokenIterator);
                } else {
                    this.resourceId = token;
                    this.processContentRequest(nextToken, tokenIterator);
                }
            } else {
                this.resourceId = token;
            }
        } else {
            Message message = new Message((Resource.Id)RepositoryServiceErrors.REPS_DET.repositoryBadRequestMissingResourceID);
            message.param("part", this.getResourceName().toString());
            ResourceException e = new ResourceException(400, message);
            e.addDetail(RepositoryServiceErrors.REPS_REP.repositoryInvalidURI);
            throw e;
        }
        if (this.requestType == null) {
            throw new ResourceException(403, new Message((Resource.Id)RepositoryServiceErrors.REPS_REP.repositoryForbiddenURI));
        }
        this.putParameter("outputRequestType", this.requestType.name());
        this.putParameter("connectionTenantID", (String)this.repositoryConnection.getProperties().get("connectionTenantID"));
    }

    private void processContentRequest(String previousToken, Iterator<String> tokenIterator) {
        if (previousToken.equals("content")) {
            String imageQuery = this.getParameter(QueryParameterNames.IMAGE_QUERY.name());
            if (imageQuery != null) {
                this.requestType = OutputRequestType.FILE;
                this.processImageQuery(imageQuery);
            } else {
                String token;
                this.requestType = OutputRequestType.CONTENT;
                if (tokenIterator.hasNext() && (token = tokenIterator.next()).equals("mht")) {
                    this.processMHTRequest(tokenIterator);
                }
            }
        } else {
            this.putParameter("fileClass", this.getFileClass(previousToken));
            if (tokenIterator.hasNext()) {
                this.putParameter("fileName", tokenIterator.next());
                this.requestType = OutputRequestType.FILE;
            } else {
                this.requestType = OutputRequestType.FILELIST;
            }
        }
    }

    private void processMHTRequest(Iterator<String> tokenIterator) {
        StringBuilder builder;
        this.requestType = OutputRequestType.MHT_CONTENT;
        if (tokenIterator.hasNext()) {
            String token = tokenIterator.next();
            if (token.equals("content")) {
                return;
            }
            builder = new StringBuilder();
            builder.append(token);
            while (tokenIterator.hasNext()) {
                builder.append("/");
                builder.append(tokenIterator.next());
            }
        } else {
            Message message = new Message((Resource.Id)RepositoryServiceErrors.REPS_DET.repositoryBadRequestMissingResourceID);
            message.param("part", this.getResourceName().toString());
            ResourceException e = new ResourceException(400, message);
            e.addDetail(RepositoryServiceErrors.REPS_REP.repositoryInvalidURI);
            throw e;
        }
        this.mhtFilePartName = builder.toString();
        this.putParameter("fileName", this.mhtFilePartName);
    }

    private void processImageQuery(String imageQuery) {
        this.putParameter("fileClass", "graphic");
        this.putParameter("fileName", this.parseImageQuery(imageQuery));
    }

    private String parseImageQuery(String imageQuery) {
        int startIdx = -1;
        int endIdx = -1;
        Matcher matcher = QUOTE_PATTERN.matcher(imageQuery);
        if (matcher.find()) {
            startIdx = matcher.end();
        }
        if (matcher.find()) {
            endIdx = matcher.start();
        }
        if (startIdx > 0 && endIdx > 0) {
            return imageQuery.substring(startIdx, endIdx);
        }
        return EMPTY_STRING;
    }

    private void processExternalResource(String previousToken, Iterator<String> tokenIterator) {
        StringBuilder redir_path = new StringBuilder().append("/").append(previousToken);
        while (tokenIterator.hasNext()) {
            redir_path.append("/").append(tokenIterator.next());
        }
        this.resourceId = redir_path.toString();
        this.requestType = OutputRequestType.EXTERNAL;
    }

    private boolean isExternalResource(String token) {
        return !token.equals("content") && !token.equals("images");
    }

    private String getFileClass(String value) {
        if ("images".equals(value)) {
            return "graphic";
        }
        return "page";
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getParentResource().toString());
        buffer.append("/").append((Object)this.getResourceName());
        buffer.append("/").append(this.getResourceId());
        switch (this.requestType) {
            case FILE: {
                buffer.append("/");
                String fileName = this.getParameter("fileName");
                buffer.append("images");
                if (fileName == null) break;
                buffer.append("/");
                buffer.append(fileName);
                break;
            }
            case CONTENT: {
                buffer.append("/").append("content");
            }
        }
        return buffer.toString();
    }
}

