/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.rest.resource;

import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.IPluginResourceLoader;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.connection.RepositoryConnectionProvider;
import com.ibm.cognos.cm.repositoryService.query.QueryParameterNames;
import com.ibm.cognos.cm.repositoryService.rest.HTTPMethodType;
import com.ibm.cognos.cm.repositoryService.rest.resource.CachedResource;
import com.ibm.cognos.cm.repositoryService.rest.resource.OutputRequestType;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import com.ibm.cognos.cm.repositoryService.rest.resource.RootURIResource;
import com.ibm.cognos.cm.repositoryService.rest.resource.ServiceResource;
import com.ibm.cognos.cm.repositoryService.rest.resource.ServiceURIResourceFactory;
import com.ibm.cognos.cm.repositoryService.rest.resource.StringTokenIterator;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.util.ParameterParser;

public class RepositoryServiceResource
implements ServiceResource {
    private static final String MHT_EXPANSION_CONSTANT = "_EXPANDED";
    private static final String DOWNLOAD_OPTION_CONSTANT = "_DOWNLOAD";
    private final ServiceURIResourceFactory serviceResourceTypeFactory;
    private final Map<String, String> requestParameters;
    private String dataSourceID;
    private URIResource requestedResource;
    private String originalPath;
    private RepositoryConnectionProvider connectionProvider;
    private MessageContext messageContext;
    private IPluginResourceLoader resourceLoader;

    public RepositoryServiceResource(String path, RepositoryConnectionProvider connectionProvider, MessageContext messageContext, IPluginResourceLoader resourceLoader) {
        this(ServiceURIResourceFactory.getInstance(), path, connectionProvider, messageContext, resourceLoader);
    }

    RepositoryServiceResource(ServiceURIResourceFactory serviceResourceTypeFactory, String path, RepositoryConnectionProvider connectionProvider, MessageContext messageContext, IPluginResourceLoader resourceLoader) {
        this.serviceResourceTypeFactory = serviceResourceTypeFactory;
        this.originalPath = path;
        this.connectionProvider = connectionProvider;
        this.messageContext = messageContext;
        this.resourceLoader = resourceLoader;
        this.requestParameters = new HashMap<String, String>();
        this.parse();
    }

    private void parse() {
        URI uri = URI.create(this.originalPath);
        String requestPath = uri.getPath();
        String parameters = uri.getQuery();
        this.parseQueryParameters(parameters);
        this.parseRequestPath(requestPath);
    }

    private void parseRequestPath(String path) {
        StringTokenIterator tokenIterator = new StringTokenIterator(path, "/");
        if (!tokenIterator.hasNext() || !"repository".equals(tokenIterator.next())) {
            ResourceException e = new ResourceException(400, new Message((Resource.Id)RepositoryServiceErrors.REPS_DET.repositoryInvalidURILeadingSlash));
            e.addDetail(RepositoryServiceErrors.REPS_REP.repositoryInvalidURI);
            throw e;
        }
        HTTPMethodType method = this.getMethodType();
        this.parseTokens(tokenIterator, new RootURIResource(), method);
        if (this.requestedResource == null || this.requestedResource.requiresMoreSteps()) {
            throw new ResourceException(403, new Message((Resource.Id)RepositoryServiceErrors.REPS_REP.repositoryForbiddenURI));
        }
    }

    private HTTPMethodType getMethodType() {
        try {
            BIBusEnvelope env = (BIBusEnvelope)this.messageContext.getProperty("request.envelope");
            String reqMethod = env.getBiBusHeader().getHdrSession().getEnvironmentVars().getValue("REQUEST_METHOD");
            HTTPMethodType method = HTTPMethodType.fromString(reqMethod);
            return method;
        }
        catch (NullPointerException e) {
            throw new ResourceException(400, new Message("Unable to determine HTTP method from environment vars."));
        }
    }

    private void parseQueryParameters(String parameters) {
        ParameterParser paramParser = new ParameterParser();
        List parameterList = paramParser.parse(parameters, '&');
        for (NameValuePair param : parameterList) {
            String parameterName = null;
            try {
                parameterName = this.getValidateParameterName(param);
                this.requestParameters.put(parameterName, param.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private String getValidateParameterName(NameValuePair param) {
        QueryParameterNames parameterName = QueryParameterNames.valueOfPathName(param.getName());
        if (!parameterName.getValidator().isValid(param.getValue())) {
            Message message = new Message((Resource.Id)RepositoryServiceErrors.REPS_DET.repositoryInvalidQueryParameterValue);
            message.param("name", param.getName());
            message.param("value", param.getValue());
            ResourceException e = new ResourceException(400, message);
            e.addDetail(RepositoryServiceErrors.REPS_REP.repositoryInvalidURI);
            throw e;
        }
        return parameterName.name();
    }

    private void parseTokens(Iterator<String> tokenIterator, URIResource previousResource, HTTPMethodType method) {
        if (tokenIterator.hasNext()) {
            String token = tokenIterator.next();
            URIResource resource = this.createURIResource(token, previousResource, method);
            if (!resource.requiresMoreSteps()) {
                resource.putParameters(this.requestParameters);
            }
            resource.process(tokenIterator);
            if (ResourceName.REPOSITORY.equals((Object)resource.getResourceName())) {
                this.dataSourceID = resource.getResourceId();
                if (HTTPMethodType.POST.equals((Object)method) && "imc".equals(this.dataSourceID)) {
                    resource = new CachedResource(resource, method);
                }
            }
            this.requestedResource = resource;
            this.parseTokens(tokenIterator, resource, method);
        }
    }

    private URIResource createURIResource(String resourceName, URIResource parentResource, HTTPMethodType type) {
        try {
            RepositoryConnection repositoryConnection = null;
            if (this.dataSourceID != null) {
                repositoryConnection = this.connectionProvider.getConnection(this.dataSourceID, this.messageContext, this.resourceLoader);
            }
            URIResource resource = this.serviceResourceTypeFactory.create(resourceName, parentResource, repositoryConnection, type);
            return resource;
        }
        catch (RepositoryException e) {
            ResourceException ex = new ResourceException(400, e.message());
            ex.addDetail(RepositoryServiceErrors.REPS_REP.repositoryResourceRequestError);
            throw ex;
        }
    }

    @Override
    public boolean isTraverseAccessCheckRequired() {
        if (ResourceName.CACHE.equals((Object)this.requestedResource.getResourceName())) {
            return false;
        }
        return !this.getResourceID().equals(this.getAuthorizationResourceID());
    }

    @Override
    public String getCacheID() {
        StringBuffer cacheID = new StringBuffer();
        cacheID.append(this.getDataSourceID());
        cacheID.append('_');
        cacheID.append(this.getResourceID());
        cacheID.append('_');
        String connectionTenantID = this.requestedResource.getParameter("connectionTenantID");
        cacheID.append(connectionTenantID);
        String downloadOption = this.requestedResource.getParameter("DOWNLOAD");
        if (Boolean.parseBoolean(downloadOption)) {
            cacheID.append(DOWNLOAD_OPTION_CONSTANT);
        }
        if (OutputRequestType.MHT_CONTENT.name().equals(this.requestedResource.getParameter("outputRequestType"))) {
            cacheID.append(MHT_EXPANSION_CONSTANT);
        } else {
            if (this.getFileClass() != null) {
                cacheID.append('_').append(this.getFileClass());
            }
            if (this.getFileName() != null) {
                cacheID.append('_').append(this.getFileName());
            }
        }
        return cacheID.toString();
    }

    @Override
    public String getResourceID() {
        return this.requestedResource.getResourceId();
    }

    @Override
    public String getDataSourceID() {
        return this.dataSourceID != null ? this.dataSourceID : "";
    }

    @Override
    public URIResource getURIResource() {
        return this.requestedResource;
    }

    @Override
    public String getAuthorizationResourceID() {
        String resourceId;
        ResourceName resourceName = this.requestedResource.getResourceName();
        switch (resourceName) {
            case REPORT: {
                resourceId = this.getResourceID();
                break;
            }
            default: {
                resourceId = this.requestedResource.getParentResource().getResourceId();
                if (!"cm".equals(resourceId)) break;
                return this.requestedResource.getResourceId();
            }
        }
        return resourceId;
    }

    @Override
    public String getURIpath() {
        return this.originalPath;
    }

    private String getFileClass() {
        return this.requestedResource.getParameter("fileClass");
    }

    private String getFileName() {
        return this.requestedResource.getParameter("fileName");
    }

    @Override
    public String getParameterValue(String name) {
        return this.requestedResource.getParameter(name);
    }
}

