/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.rest.resource;

import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum ResourceName {
    ROOT("repository", new ResourceName[0]),
    REPOSITORY("sid", ROOT),
    REPORT("rid", REPOSITORY, ROOT),
    REPORTVERSION("vid", REPORT),
    OUTPUT("oid", REPORT, REPOSITORY),
    CACHE("cid", REPOSITORY),
    OBJECT("id", REPOSITORY, ROOT);

    private static final Map<String, ResourceName> resourcePathMap;
    private final List<ResourceName> expectedParents;
    private final String pathName;

    private ResourceName(String pathName, ResourceName ... expectedParents) {
        this.expectedParents = Arrays.asList(expectedParents);
        this.pathName = pathName;
    }

    public boolean isExpectedParent(ResourceName parent) {
        return parent == null ? false : this.expectedParents.contains((Object)parent);
    }

    public String toString() {
        return this.pathName;
    }

    public static ResourceName getResourceNameByPathName(String pathName) {
        ResourceName resourceName = resourcePathMap.get(pathName);
        if (resourceName == null) {
            Message message = new Message((Resource.Id)RepositoryServiceErrors.REPS_DET.repositoryInvalidPart);
            message.param("part", pathName);
            ResourceException re = new ResourceException(400, message);
            re.addDetail(RepositoryServiceErrors.REPS_REP.repositoryInvalidURI);
            throw re;
        }
        return resourceName;
    }

    public List<ResourceName> getExpectedParents() {
        return this.expectedParents;
    }

    private static Map<String, ResourceName> createResourcePathMap() {
        ConcurrentHashMap<String, ResourceName> resourcePathMap = new ConcurrentHashMap<String, ResourceName>();
        for (ResourceName resourceName : ResourceName.values()) {
            resourcePathMap.put(resourceName.pathName, resourceName);
        }
        return resourcePathMap;
    }

    static {
        resourcePathMap = ResourceName.createResourcePathMap();
    }
}

