/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.rest.resource;

import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.rest.HTTPMethodType;
import com.ibm.cognos.cm.repositoryService.rest.resource.CachedResource;
import com.ibm.cognos.cm.repositoryService.rest.resource.ObjectURIResource;
import com.ibm.cognos.cm.repositoryService.rest.resource.OutputURIResource;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import com.ibm.cognos.cm.repositoryService.rest.resource.SimpleURIResource;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;

class ServiceURIResourceFactory {
    private static final ServiceURIResourceFactory INSTANCE = new ServiceURIResourceFactory();

    private ServiceURIResourceFactory() {
    }

    URIResource create(String name, URIResource parent, HTTPMethodType method) {
        return this.create(name, parent, null, method);
    }

    URIResource create(String name, URIResource parent, RepositoryConnection repositoryConnection, HTTPMethodType method) {
        ResourceName parentType;
        ResourceName type = ResourceName.getResourceNameByPathName(name);
        if (!type.isExpectedParent(parentType = parent.getResourceName())) {
            Message message = new Message((Resource.Id)RepositoryServiceErrors.REPS_DET.repositoryUnexpectedPart);
            message.param("expected", type.getExpectedParents().toString());
            message.param("actual", type.toString());
            message.param("parent", parentType.toString());
            ResourceException e = new ResourceException(400, message);
            e.addDetail(RepositoryServiceErrors.REPS_REP.repositoryInvalidURI);
            throw e;
        }
        SimpleURIResource resourceType = null;
        switch (type) {
            case REPOSITORY: {
                boolean moreSteps = HTTPMethodType.GET == method;
                resourceType = new SimpleURIResource(parent, type, moreSteps);
                break;
            }
            case OUTPUT: {
                resourceType = new OutputURIResource(parent, repositoryConnection);
                break;
            }
            case CACHE: {
                resourceType = new CachedResource(parent, method);
                break;
            }
            case OBJECT: {
                resourceType = new ObjectURIResource(parent, repositoryConnection);
                break;
            }
            default: {
                resourceType = new SimpleURIResource(parent, type, false);
            }
        }
        return resourceType;
    }

    static final ServiceURIResourceFactory getInstance() {
        return INSTANCE;
    }
}

