/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.rest.resource;

import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.rest.HTTPMethodType;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceException;
import com.ibm.cognos.cm.repositoryService.rest.resource.ResourceName;
import com.ibm.cognos.cm.repositoryService.rest.resource.URIResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class SimpleURIResource
implements URIResource {
    private final URIResource parent;
    private final boolean requiresMoreSteps;
    private final ResourceName resourceName;
    private final Map<String, String> parameters;
    protected String resourceId;

    SimpleURIResource(URIResource parent, ResourceName resourceName, boolean hasMoreSteps) {
        this.parent = parent;
        this.resourceName = resourceName;
        this.requiresMoreSteps = hasMoreSteps;
        this.parameters = hasMoreSteps ? Collections.emptyMap() : new HashMap<String, String>();
    }

    @Override
    public boolean requiresMoreSteps() {
        return this.requiresMoreSteps;
    }

    @Override
    public void process(Iterator<String> tokenIterator) {
        if (!tokenIterator.hasNext()) {
            Message message = new Message((Resource.Id)RepositoryServiceErrors.REPS_DET.repositoryBadRequestMissingResourceID);
            message.param("part", this.getResourceName().toString());
            ResourceException e = new ResourceException(400, message);
            e.addDetail(RepositoryServiceErrors.REPS_REP.repositoryInvalidURI);
            throw e;
        }
        this.resourceId = tokenIterator.next();
    }

    @Override
    public String getResourceId(ResourceName name) {
        if (this.resourceName == name) {
            return this.resourceId;
        }
        return this.parent.getResourceId(name);
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public URIResource getParentResource() {
        return this.parent;
    }

    @Override
    public ResourceName getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getParameter(String parameterName) {
        return this.parameters.get(parameterName);
    }

    @Override
    public void putParameter(String parameterName, String parameterValue) {
        this.parameters.put(parameterName, parameterValue);
    }

    @Override
    public void putParameters(Map<String, String> parameters) {
        this.parameters.putAll(parameters);
    }

    public String toString() {
        return this.parent.toString() + "/" + (Object)((Object)this.resourceName) + "/" + this.resourceId;
    }

    @Override
    public HTTPMethodType getHTTPMethodType() {
        return HTTPMethodType.GET;
    }
}

