/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.service;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.log.LogKitACLBridge;
import com.cognos.cmutils.log.LogKitACLBridgeFactory;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.cmutils.properties.IDataEncryptionHelper;
import com.ibm.cognos.cm.repositoryService.RepositoryServiceErrors;
import com.ibm.cognos.cm.repositoryService.service.CAMCredentialsHelper;
import com.ibm.cognos.cm.repositoryService.service.CredentialsHelper;
import com.ibm.cognos.cm.repositoryService.service.CryptoHelper;
import com.ibm.cognos.cm.repositoryService.service.DataEncryptionHelper;

class CAMCryptoHelper
implements CryptoHelper {
    static final byte[] SERVICE_IDENTIFIER = "<initializeDocument><serviceID>repositoryService</serviceID></initializeDocument>".getBytes();
    private static LogKitACLBridge log = LogKitACLBridgeFactory.getLog(CAMCryptoHelper.class);
    private static IDataEncryptionHelper encryptionHelper;
    private final CAMFactory camFactory;

    CAMCryptoHelper(CAMFactory camFactory) {
        this.camFactory = camFactory;
    }

    @Override
    public synchronized void initialize() throws RepositoryException {
        try {
            this.initializeCAMCrypto();
            this.initializeEncryptionHelper();
        }
        catch (CAMCryptoException cryptoEx) {
            Message message = new Message((Resource.Id)RepositoryServiceErrors.REPS_SERVER.repositoryCryptoError);
            log.fatal((Object)cryptoEx.getLocalizedMessage());
            throw new RepositoryException(message, (Throwable)cryptoEx);
        }
    }

    @Override
    public CAMFactory getCAMFactoryInstance() {
        return this.camFactory;
    }

    @Override
    public CredentialsHelper getCredentialsHelper() {
        return new CAMCredentialsHelper(encryptionHelper);
    }

    @Override
    public synchronized void dispose() {
        if (this.camFactory != null) {
            this.camFactory.terminate();
        }
    }

    private void initializeCAMCrypto() throws CAMCryptoException {
        this.camFactory.initialize(SERVICE_IDENTIFIER);
    }

    private void initializeEncryptionHelper() throws CAMCryptoException {
        encryptionHelper = new DataEncryptionHelper(this.camFactory.createEncryptingSession());
    }
}

