/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.service;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPException;
import com.cognos.pogo.pdk.common.CamException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethod;

public class PassportValidationResult {
    private static final String SYSTEM_RECOVERABLE_CAM_FAULT = "camAuthSystemRecoverable";
    private static final String USER_RECOVERABLE_CAM_FAULT = "camAuthUserRecoverable";
    private HttpMethod method;
    private BIBusEnvelope responseEnvelope;

    public PassportValidationResult(HttpMethod method) throws IOException {
        try {
            this.method = method;
            InputStream responseStream = method.getResponseBodyAsStream();
            this.responseEnvelope = new BIBusEnvelope(responseStream);
        }
        catch (SOAPException sOAPException) {
        }
        finally {
            this.method.releaseConnection();
        }
    }

    public int getStatusCode() {
        return this.method.getStatusCode();
    }

    public BIBusEnvelope getResponseEnvelope() {
        return this.responseEnvelope;
    }

    public boolean isUserOrSystemRecoverableException() {
        CamException camEx;
        BIBusEnvelope responseEnvelope = this.getResponseEnvelope();
        if (responseEnvelope != null && (camEx = responseEnvelope.getBiBusHeader().getCam().getException()) != null) {
            String errorCode = camEx.getErrorCodeString();
            return SYSTEM_RECOVERABLE_CAM_FAULT.equals(errorCode) || USER_RECOVERABLE_CAM_FAULT.equals(errorCode);
        }
        return false;
    }

    public String getPassportID() {
        if (this.responseEnvelope == null) {
            return null;
        }
        return this.responseEnvelope.getBiBusHeader().getCam().getCAMPassport().getId();
    }
}

