/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryService.service;

import com.cognos.cmutils.http.HttpClientFactoryProvider;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.BiBusHeader;
import com.ibm.cognos.cm.repositoryService.service.PassportValidationResult;
import com.ibm.cognos.internal.ombridge.BibusSoapAction;
import com.ibm.cognos.internal.ombridge.BridgeHandler;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.PostMethod;

public class PassportValidator {
    private HttpClient client;
    private URI dispURI;

    public void setDispatcherURL(String dispURL) throws IOException {
        this.dispURI = new URI(dispURL, false);
    }

    public PassportValidationResult validate(BIBusEnvelope requestEnvelope) throws IOException {
        if (this.dispURI == null) {
            throw new IOException("The dispatcher URL is not set.");
        }
        this.client = HttpClientFactoryProvider.getInstance().getHttpClient(this.dispURI);
        HttpMethod method = this.getPostMethod(this.dispURI);
        this.setPostMethodBody(method, requestEnvelope);
        this.client.executeMethod(method);
        return new PassportValidationResult(method);
    }

    private HttpMethod getPostMethod(URI uri) throws URIException {
        PostMethod method = new PostMethod();
        this.setupPostMethod(uri, (HttpMethod)method);
        return method;
    }

    private void setupPostMethod(URI uri, HttpMethod method) throws URIException {
        method.setPath(uri.getPath());
        String query = uri.getQuery();
        if (query != null) {
            method.setQueryString(query);
        }
        method.setRequestHeader("Content-Type", "text/xml");
        String version = (String)BridgeHandler.getSupportedVersions().get(0);
        BibusSoapAction action = new BibusSoapAction(BibusSoapAction.Format.IBM, "contentManagerService", version);
        method.setRequestHeader("SOAPAction", action.toString());
    }

    private void setPostMethodBody(HttpMethod method, BIBusEnvelope requestEnvelope) throws IOException {
        BiBusHeader bibusHeader = requestEnvelope.getBiBusHeader();
        bibusHeader.getCam().setAction("validate");
        ((PostMethod)method).setRequestBody(requestEnvelope.getAsString());
    }
}

