/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp.bapi;

import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiException;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiFunction;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicBoolean;

public class JBapiClient {
    private static boolean inited = false;
    private long mHandle = 0L;
    private String mSAPSystemVer = null;
    private String mSAPKernelVer = null;
    private AtomicBoolean isInvalid = new AtomicBoolean();
    private final String charSetName;
    private static final String ERROR_BAPI_FUNCTION_CREATION = "Failed to create a BAPI function ";
    private static final String ERROR_CLIENT_NOT_CONNECTED = "Client not connected to the server";

    protected JBapiClient(String charSet) {
        this.charSetName = charSet;
        JBapiClient.init();
    }

    public final void connect(String sapConnString) throws JBapiException {
        this.mHandle = JBapiClient.nativeConnect(sapConnString);
    }

    public final void disconnect() throws JBapiException {
        JBapiClient.disconnect(this.mHandle);
        this.mHandle = 0L;
    }

    public static JBapiClient createClient(String charSet) {
        return new JBapiClient(charSet);
    }

    private static synchronized void init() throws JBapiException {
        if (inited) {
            return;
        }
        try {
            Class.forName("com.cognos.xqe.data.providers.olap.sbwodp.bapi.SAPAvailable");
        }
        catch (ClassNotFoundException ce) {
            throw new JBapiException("Attempting to load SAP BW XQEODP provider on unsupported platform");
        }
        catch (Exception e) {
            throw new JBapiException("Unknown error when attempting to check for SAP support");
        }
        try {
            System.loadLibrary("saprfcjni");
        }
        catch (UnsatisfiedLinkError ule) {
            throw new JBapiException("SAP RFC JNI Library not Found: " + ule.getLocalizedMessage());
        }
        catch (SecurityException se) {
            throw new JBapiException("SAP RFC JNI Library failed to load: " + se.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new JBapiException("Unknown error while Loading SAP RFC JNI Library: " + e.getLocalizedMessage());
        }
        inited = true;
    }

    public String getSAPSystemVersion() throws JBapiException {
        if (this.mSAPSystemVer == null) {
            this.getSAPVersions();
        }
        return this.mSAPSystemVer;
    }

    public String getSAPKernelVersion() throws JBapiException {
        if (this.mSAPKernelVer == null) {
            this.getSAPVersions();
        }
        return this.mSAPKernelVer;
    }

    public final JBapiFunction getFunction(String functionName) throws JBapiException {
        long functionPtr = JBapiClient.createFunction(functionName, this.mHandle);
        if (functionPtr == 0L) {
            throw new JBapiException(ERROR_BAPI_FUNCTION_CREATION + functionName);
        }
        return new JBapiFunction(functionPtr, functionName, this.charSetName, this);
    }

    public final void execute(JBapiFunction function, boolean checkRtn) throws JBapiException {
        if (this.mHandle == 0L || !this.isValid()) {
            throw new JBapiException(ERROR_CLIENT_NOT_CONNECTED);
        }
        function.execute(checkRtn);
    }

    public final long getConnectionHandle() {
        return this.mHandle;
    }

    public final void invalidateConnection() {
        this.isInvalid.compareAndSet(false, true);
    }

    public final boolean isValid() throws JBapiException {
        if (this.isInvalid.get()) {
            return false;
        }
        return JBapiClient.checkHandle(this.mHandle);
    }

    private void getSAPVersions() throws JBapiException {
        String[] tokens;
        String verStr = JBapiClient.getSAPVersionInfo(this.mHandle);
        if (verStr != null && verStr.length() > 0) {
            tokens = verStr.split(":");
            if (tokens.length != 2) {
                throw new JBapiException("Error: invalid SAP version string: " + verStr);
            }
        } else {
            throw new JBapiException("Error: empty or null SAP version string");
        }
        this.mSAPSystemVer = tokens[0].trim();
        this.mSAPKernelVer = tokens[1].trim();
    }

    public void logToBapiTrace(String msg) throws JBapiException {
        JBapiClient.trace(msg);
    }

    public static String getStackTraceString(Throwable throwable) {
        String stackTrace;
        if (null != throwable) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            stackTrace = stringWriter.toString();
            printWriter.close();
            try {
                stringWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            stackTrace = "";
        }
        return stackTrace;
    }

    private static native long createFunction(String var0, long var1) throws JBapiException;

    private static native long nativeConnect(String var0) throws JBapiException;

    private static native void disconnect(long var0) throws JBapiException;

    private static native boolean checkHandle(long var0) throws JBapiException;

    private static native String getSAPVersionInfo(long var0) throws JBapiException;

    private static native void trace(String var0) throws JBapiException;
}

