/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp.bapi;

import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiClient;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiException;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiStructure;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiTable;

public class JBapiFunction {
    private long mFunctionPtr = 0L;
    private String mFunctionName = null;
    private String mCharSet = null;
    private static final String ERROR_PARAMETER_FETCH = "Failed to retrieve parameter: ";
    private JBapiClient client;

    public JBapiFunction(long functionPtr, String functionName, String charSet, JBapiClient clnt) {
        this.mFunctionPtr = functionPtr;
        this.mFunctionName = functionName;
        this.mCharSet = charSet;
        this.client = clnt;
    }

    public final void release() {
        if (this.mFunctionPtr != 0L) {
            long localPtr = this.mFunctionPtr;
            this.mFunctionPtr = 0L;
            JBapiFunction.releaseFunction(localPtr);
            this.client = null;
        }
    }

    public final void execute(boolean checkRtn) throws JBapiException {
        JBapiFunction.execute(this.mFunctionPtr, checkRtn);
    }

    public final void cancelSoft() throws JBapiException {
        if (this.mFunctionPtr != 0L) {
            JBapiFunction.cancelSoft(this.mFunctionPtr);
        }
    }

    public final void setImportParameter(String key, String value) throws JBapiException {
        JBapiFunction.setImportParameter(this.mFunctionPtr, key, value);
    }

    public final void finalize() {
        this.release();
    }

    public final JBapiTable getTableParameter(String tableParamName) throws JBapiException {
        long tablePtr = JBapiFunction.getTableParameter(this.mFunctionPtr, tableParamName);
        if (tablePtr == 0L) {
            throw new JBapiException(ERROR_PARAMETER_FETCH + tableParamName);
        }
        return new JBapiTable(tablePtr, this.mFunctionName + ":" + tableParamName, this.mCharSet, this.client);
    }

    public final JBapiStructure getExportStructure(String paramName) throws JBapiException {
        long structPtr = JBapiFunction.getExportParameter(this.mFunctionPtr, paramName);
        if (structPtr == 0L) {
            throw new JBapiException(ERROR_PARAMETER_FETCH + paramName);
        }
        return new JBapiStructure(structPtr, this.client);
    }

    public final JBapiStructure getImportStructure(String paramName) throws JBapiException {
        long structPtr = JBapiFunction.getImportParameter(this.mFunctionPtr, paramName);
        if (structPtr == 0L) {
            throw new JBapiException(ERROR_PARAMETER_FETCH + paramName);
        }
        return new JBapiStructure(structPtr, this.client);
    }

    public final String getExportParameterValue(String paramName) throws JBapiException {
        return JBapiFunction.getExportParameterValue(this.mFunctionPtr, paramName);
    }

    public final String getFunctionName() {
        return this.mFunctionName;
    }

    private static native void execute(long var0, boolean var2) throws JBapiException;

    private static native void cancelSoft(long var0) throws JBapiException;

    private static native void setImportParameter(long var0, String var2, String var3) throws JBapiException;

    private static native long getTableParameter(long var0, String var2) throws JBapiException;

    private static native long getImportParameter(long var0, String var2) throws JBapiException;

    private static native long getExportParameter(long var0, String var2) throws JBapiException;

    private static native String getExportParameterValue(long var0, String var2) throws JBapiException;

    private static native void releaseFunction(long var0);
}

