/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp.bapi;

import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiClient;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiException;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.TreeMap;

public class JBapiTable {
    private static final byte HIGH_NIBBLE_MASK = -16;
    private static final byte MINUS_SIGN_MASK = 13;
    private static final byte SHIFT_MASK = 4;
    private static final byte NINE = 9;
    private static final String STR_CONVERR1 = "Error converting ";
    private static final String STR_CONVERR2 = "Error converting field #";
    private static final String STR_CONVERR3 = " to an int: ";
    private static final String STR_CONVERR4 = " to an float: ";
    private static final String STR_NO_ROW_ERR = "Error: Row not set!";
    private static final String STR_GET_FLD_ERR = "Error retrieving field for: ";
    private static final String STR_FLD_VAL_LEN_ERR = "Error field value is too long";
    private static final String COL_SEP_STR = "; ";
    private static final String NEW_LINE_STR = "\n";
    private static final String OF_BP_STR = " of ";
    private static final String RSZ_X_VALUES_GET = "RSZ_X_VALUES_GET:E_T_VALUES";
    private long mTablePtr = 0L;
    private int mNumOfRows = -1;
    private int mCurRow = -1;
    private final String mName;
    private final CharsetDecoder mDecoder;
    private JBapiField[] fldArray = null;
    private TreeMap<String, JBapiField> fldMap = null;
    private ByteBuffer curRowData = null;
    static TreeMap<String, JBapiField[]> fieldSets = null;
    private JBapiClient client;

    public JBapiTable(long tablePtr, String tableName, String charSet, JBapiClient clnt) {
        this.mTablePtr = tablePtr;
        this.mName = tableName;
        this.client = clnt;
        this.fldMap = new TreeMap();
        this.fldArray = JBapiTable.getFieldSet(this, this.mName);
        for (int i = 0; i < this.fldArray.length; ++i) {
            this.fldMap.put(this.fldArray[i].getName(), this.fldArray[i]);
        }
        Charset charset = Charset.forName(charSet);
        this.mDecoder = charset.newDecoder();
    }

    public String getTableName() {
        return this.mName;
    }

    public final void release() {
        if (this.mTablePtr != 0L) {
            long localPtr = this.mTablePtr;
            this.mTablePtr = 0L;
            JBapiTable.releaseTable(localPtr);
            this.curRowData = null;
            this.mNumOfRows = 0;
            this.mCurRow = -1;
            this.client = null;
        }
    }

    public final int getNumRows() {
        if (this.mNumOfRows < 0) {
            this.mNumOfRows = JBapiTable.getNumRows(this.mTablePtr);
        }
        return this.mNumOfRows;
    }

    public final int getRowLength() {
        return JBapiTable.getRowLength(this.mTablePtr);
    }

    private JBapiField fieldFromName(String name) {
        JBapiField field = this.fldMap.get(name);
        if (field == null) {
            throw new JBapiException(STR_GET_FLD_ERR + name);
        }
        return field;
    }

    public final String getString(String fieldName) {
        return this.getString(this.fieldFromName(fieldName), true);
    }

    public final String getString(int fieldIndex) {
        return this.getString(this.fldArray[fieldIndex], true);
    }

    public final String getString(String fieldName, boolean decode) {
        return this.getString(this.fieldFromName(fieldName), decode);
    }

    public final String getString(int fieldIndex, boolean decode) {
        return this.getString(this.fldArray[fieldIndex], decode);
    }

    private String getString(JBapiField field, boolean decode) throws JBapiException {
        if (this.curRowData == null) {
            throw new JBapiException(STR_NO_ROW_ERR);
        }
        if (field.getType() == 2) {
            this.curRowData.position(field.getOffset());
            ByteBuffer slice = this.curRowData.slice();
            slice.limit(field.getLength());
            return this.bcdToString(slice, field.getDecimals());
        }
        if (field.getType() == 8) {
            return String.valueOf(this.getInt(field));
        }
        if (field.getType() == 6) {
            byte[] dest = new byte[field.getLength()];
            this.curRowData.position(field.getOffset());
            this.curRowData.get(dest, 0, field.getLength());
            return new String(dest);
        }
        byte[] dest = new byte[field.getLength()];
        this.curRowData.position(field.getOffset());
        this.curRowData.get(dest, 0, field.getLength());
        dest = this.trimByteArray(dest);
        if (dest == null || dest.length == 0) {
            return "";
        }
        if (decode) {
            CharBuffer cbuf = null;
            try {
                cbuf = this.mDecoder.decode(ByteBuffer.wrap(dest));
            }
            catch (CharacterCodingException ce) {
                throw new JBapiException("Error converting SAP field data: " + ce.getLocalizedMessage());
            }
            return cbuf.toString();
        }
        return new String(dest);
    }

    private byte[] trimByteArray(byte[] array) {
        int start;
        for (start = 0; start < array.length && array[start] == 32; ++start) {
        }
        if (start >= array.length) {
            return null;
        }
        int end = array.length - 1;
        while (array[end] == 32) {
            --end;
        }
        if (start != 0 || end != array.length - 1) {
            int len = end - start + 1;
            byte[] ret = new byte[len];
            System.arraycopy(array, start, ret, 0, len);
            return ret;
        }
        return array;
    }

    private String bcdToString(ByteBuffer bcd, int numDecimals) {
        int mask = -16;
        int length = bcd.limit();
        StringBuffer ret = new StringBuffer("");
        char lastChar = '0';
        int idx = 0;
        byte curByte = bcd.get(length - 1);
        if ((curByte & ~mask) == 13) {
            lastChar = '-';
            ret.append(lastChar);
        }
        int digitCount = 0;
        int digitTotal = 2 * length - 1;
        boolean put = false;
        curByte = bcd.get(0);
        do {
            byte negMask;
            byte shift;
            byte val;
            byte digit;
            if ((digit = (byte)((val = (byte)(curByte & mask)) >> (shift = (byte)((negMask = (byte)(~mask)) & 4)))) < 0) {
                digit = (byte)(digit * -1);
            }
            if (digit > 9) {
                throw new JBapiException("BCD Conversion error - invalid digit value: " + digit);
            }
            ++digitCount;
            if (digit != 0 || put) {
                lastChar = (char)((char)digit + 48);
                ret.append(lastChar);
                put = true;
            }
            mask = negMask;
            if (numDecimals != 0 && digitCount == digitTotal - numDecimals) {
                if (idx == 0 || lastChar == '-') {
                    ret.append('0');
                }
                lastChar = '.';
                ret.append(lastChar);
                put = true;
            }
            if (mask != -16) continue;
            curByte = bcd.get(++idx);
        } while (digitCount < digitTotal);
        if (idx == 0) {
            ret.append('0');
        }
        return ret.toString();
    }

    private int getInt(JBapiField field) throws JBapiException {
        if (this.curRowData == null) {
            throw new JBapiException(STR_NO_ROW_ERR);
        }
        this.curRowData.order(ByteOrder.LITTLE_ENDIAN);
        return this.curRowData.getInt(field.getOffset());
    }

    public final int getAsInt(int fieldIndex) throws JBapiException {
        JBapiField field = this.fldArray[fieldIndex];
        if (field.getType() == 8) {
            return this.getInt(field);
        }
        String val = this.getString(field, false);
        int ret = 0;
        try {
            ret = Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            throw new JBapiException(STR_CONVERR2 + fieldIndex + STR_CONVERR3 + nfe.getLocalizedMessage());
        }
        return ret;
    }

    public final int getAsInt(String fieldName) throws JBapiException {
        JBapiField field = this.fieldFromName(fieldName);
        if (field.getType() == 8) {
            return this.getInt(field);
        }
        String val = this.getString(field, false);
        int ret = 0;
        try {
            ret = Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            throw new JBapiException(STR_CONVERR1 + fieldName + STR_CONVERR3 + nfe.getLocalizedMessage());
        }
        return ret;
    }

    public final double getAsDouble(int fieldIndex) throws JBapiException {
        String val = this.getString(this.fldArray[fieldIndex], false);
        double ret = 0.0;
        try {
            ret = Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            throw new JBapiException(STR_CONVERR2 + fieldIndex + STR_CONVERR4 + nfe.getLocalizedMessage());
        }
        return ret;
    }

    public final double getAsDouble(String fieldName) throws JBapiException {
        String val = this.getString(this.fieldFromName(fieldName), false);
        double ret = 0.0;
        try {
            ret = Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            throw new JBapiException(STR_CONVERR1 + fieldName + STR_CONVERR4 + nfe.getLocalizedMessage());
        }
        return ret;
    }

    public final long getLong(String fieldName) throws JBapiException {
        String strValue = this.getString(this.fieldFromName(fieldName), false);
        try {
            return Long.parseLong(strValue);
        }
        catch (NumberFormatException nfe) {
            throw new JBapiException(nfe.getMessage());
        }
    }

    public final long getLong(int fieldIndex) throws JBapiException {
        String strValue = this.getString(this.fldArray[fieldIndex], false);
        try {
            return Long.parseLong(strValue);
        }
        catch (NumberFormatException nfe) {
            throw new JBapiException(nfe.getMessage());
        }
    }

    public final void setRow(int rowIndex) {
        this.curRowData = JBapiTable.getRow(this.mTablePtr, rowIndex);
        if (this.curRowData == null) {
            throw new JBapiException("Row Buffer is null for row " + rowIndex + " in bapi table " + this.mName);
        }
        this.mCurRow = rowIndex;
    }

    public final void clear() {
        JBapiTable.clear(this.mTablePtr);
        this.curRowData = null;
        this.mNumOfRows = 0;
        this.mCurRow = -1;
    }

    public final void appendRow() {
        this.curRowData = JBapiTable.appendRow(this.mTablePtr);
        if (this.curRowData == null) {
            throw new JBapiException("Row Buffer is null for new row " + this.mNumOfRows + " in table " + this.mName);
        }
        ++this.mNumOfRows;
        ++this.mCurRow;
    }

    public void setValue(String key, String value) throws JBapiException {
        JBapiField field = this.fldMap.get(key);
        if (field == null) {
            throw new JBapiException(STR_GET_FLD_ERR + key);
        }
        this.setValue(field, value);
    }

    public void setValue(int idx, String value) throws JBapiException {
        JBapiField field = this.fldArray[idx];
        this.setValue(field, value);
    }

    public void setValue(JBapiField field, String value) throws JBapiException {
        if (this.curRowData == null) {
            throw new JBapiException(STR_NO_ROW_ERR);
        }
        StringBuffer sb = new StringBuffer(value);
        if (sb.length() > field.getLength()) {
            throw new JBapiException(STR_FLD_VAL_LEN_ERR);
        }
        if (sb.length() < field.getLength()) {
            if (field.getType() == 0) {
                while (sb.length() < field.getLength()) {
                    sb.append(' ');
                }
            } else if (field.getType() == 6 || field.getType() == 1) {
                while (sb.length() < field.getLength()) {
                    sb.insert(0, '0');
                }
            }
        }
        byte[] src = sb.toString().getBytes();
        for (int i = 0; i < field.getLength(); ++i) {
            this.curRowData.put(field.getOffset() + i, src[i]);
        }
    }

    public final String traceToString(int maxRows) {
        int max = maxRows;
        if (max > this.getNumRows()) {
            max = this.getNumRows();
        }
        StringBuffer ret = new StringBuffer("BAPI Table Dump: ");
        ret.append(this.mName);
        ret.append(" (");
        ret.append(max);
        ret.append(OF_BP_STR);
        ret.append(this.getNumRows());
        ret.append(" rows)");
        ret.append(NEW_LINE_STR);
        for (int i = 0; i < this.fldArray.length; ++i) {
            ret.append(this.fldArray[i].getName());
            ret.append(COL_SEP_STR);
        }
        ret.append(NEW_LINE_STR);
        for (int row = 0; row < max; ++row) {
            this.setRow(row);
            for (int i = 0; i < this.fldArray.length; ++i) {
                ret.append(this.getString(i));
                ret.append(COL_SEP_STR);
            }
            ret.append(NEW_LINE_STR);
        }
        return ret.toString();
    }

    public final String traceCurRow() {
        int i;
        StringBuffer ret = new StringBuffer("BAPI Table Row Dump: ");
        ret.append(this.mName);
        ret.append(" (row ");
        ret.append(this.mCurRow);
        ret.append(OF_BP_STR);
        ret.append(this.getNumRows());
        ret.append(")");
        ret.append(NEW_LINE_STR);
        for (i = 0; i < this.fldArray.length; ++i) {
            ret.append(this.fldArray[i].getName());
            ret.append(COL_SEP_STR);
        }
        ret.append(NEW_LINE_STR);
        for (i = 0; i < this.fldArray.length; ++i) {
            ret.append(this.getString(i));
            ret.append(COL_SEP_STR);
        }
        ret.append(NEW_LINE_STR);
        return ret.toString();
    }

    public JBapiField[] getFields() throws JBapiException {
        return (JBapiField[])JBapiTable.getFields(this.mTablePtr);
    }

    static synchronized JBapiField[] getFieldSet(JBapiTable table, String name) {
        JBapiField[] fields = null;
        if (fieldSets != null && !name.equals(RSZ_X_VALUES_GET)) {
            fields = fieldSets.get(name);
        }
        if (fields == null) {
            fields = table.getFields();
            if (fieldSets == null) {
                fieldSets = new TreeMap();
            }
            fieldSets.put(name, fields);
        }
        return fields;
    }

    private static native int getNumRows(long var0) throws JBapiException;

    private static native int getRowLength(long var0) throws JBapiException;

    private static native void clear(long var0) throws JBapiException;

    private static native ByteBuffer appendRow(long var0) throws JBapiException;

    private static native void releaseTable(long var0);

    private static native Object[] getFields(long var0) throws JBapiException;

    private static native ByteBuffer getRow(long var0, int var2) throws JBapiException;
}

