/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.specscrubber;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import java.util.HashSet;
import java.util.Set;

public class SpecScrubber {
    private static final String REF = "$ref";
    private static final String DATA = "data";
    private static final String DATA_FIELDS = "fields";
    private static final String GROUP = "group";
    private static final String OUTPUT = "output";
    private static final String REF_FIELD = "field";
    private static final String ID = "id";
    private static final String GRAMMAR = "grammar";
    private static final String ELEMENTS = "elements";
    private static final String POSITION = "position";
    private static final String LEGENDS = "legends";
    private static final String AESTHETICS = "aesthetics";
    private static final String AESTHETIC = "aesthetic";
    private static final String[] AESTHETICS_LIST = new String[]{"color", "dashing", "meta", "size", "split", "styleBy", "symbol", "font", "visibility", "offset", "accessibility"};
    private final Set<String> referenceIds = new HashSet<String>();
    private boolean referenceRemoved = false;

    public JSONObject removeUnresolvedReferences(JSONObject specification) {
        JSONObject resolvedSpecification = null;
        if (specification != null) {
            resolvedSpecification = this.removeUnresolvedFromSpecification(specification);
        }
        return resolvedSpecification;
    }

    private JSONObject removeUnresolvedFromSpecification(JSONObject spec) {
        this.referenceRemoved = false;
        JSONObject resolvedSpec = null;
        this.collectIds(spec);
        if (!this.referenceIds.isEmpty()) {
            this.removeFromGrammar(spec);
            this.collectIds(spec);
            this.removeFromLegends(spec);
            if (this.referenceRemoved) {
                resolvedSpec = spec;
            }
        }
        return resolvedSpec;
    }

    private void resetIds() {
        this.referenceIds.clear();
    }

    private void collectIds(JSONObject spec) {
        this.resetIds();
        JSONArray dataAr = (JSONArray)BasicFactory.getItem((Object)spec, (String)DATA);
        if (dataAr != null) {
            int size = BasicFactory.size((JSONArray)dataAr);
            int i = 0;
            while (i < size) {
                JSONObject dataObj = (JSONObject)BasicFactory.getArrayItem((JSONArray)dataAr, (int)i);
                if (dataObj != null) {
                    String refId = (String)BasicFactory.getItem((Object)dataObj, (String)ID);
                    if (refId != null) {
                        this.referenceIds.add(refId);
                    }
                    this.collectIdsFromFields(dataObj);
                    this.collectIdsFromGroupFields(dataObj);
                    this.collectIdsFromOutputFields(dataObj);
                }
                ++i;
            }
        }
        this.collectIdsFromAesthetics(spec);
    }

    private void collectIdsFromFields(JSONObject data) {
        JSONArray fieldsAr = (JSONArray)BasicFactory.getItem((Object)data, (String)DATA_FIELDS);
        if (fieldsAr != null) {
            int size = BasicFactory.size((JSONArray)fieldsAr);
            int j = 0;
            while (j < size) {
                String refId;
                JSONObject field = (JSONObject)BasicFactory.getArrayItem((JSONArray)fieldsAr, (int)j);
                if (field != null && (refId = (String)BasicFactory.getItem((Object)field, (String)ID)) != null) {
                    this.referenceIds.add(refId);
                }
                ++j;
            }
        }
    }

    private void collectIdsFromGroupFields(JSONObject data) {
        JSONArray groupAr = (JSONArray)BasicFactory.getItem((Object)data, (String)GROUP);
        if (groupAr != null) {
            int size = BasicFactory.size((JSONArray)groupAr);
            int j = 0;
            while (j < size) {
                String id;
                JSONObject output;
                JSONObject group = (JSONObject)BasicFactory.getArrayItem((JSONArray)groupAr, (int)j);
                if (group != null && (output = (JSONObject)BasicFactory.getItem((Object)group, (String)OUTPUT)) != null && (id = (String)BasicFactory.getItem((Object)output, (String)ID)) != null) {
                    this.referenceIds.add(id);
                }
                ++j;
            }
        }
    }

    private void collectIdsFromOutputFields(JSONObject data) {
        JSONArray outputAr = (JSONArray)BasicFactory.getItem((Object)data, (String)OUTPUT);
        if (outputAr != null) {
            int size = BasicFactory.size((JSONArray)outputAr);
            int j = 0;
            while (j < size) {
                String refId;
                JSONObject field;
                JSONObject output = (JSONObject)BasicFactory.getArrayItem((JSONArray)outputAr, (int)j);
                if (output != null && (field = (JSONObject)BasicFactory.getItem((Object)output, (String)REF_FIELD)) != null && (refId = (String)BasicFactory.getItem((Object)field, (String)ID)) != null) {
                    this.referenceIds.add(refId);
                }
                ++j;
            }
        }
    }

    private void collectIdsFromAesthetics(JSONObject spec) {
        JSONArray grammars = (JSONArray)BasicFactory.getItem((Object)spec, (String)GRAMMAR);
        if (grammars != null) {
            int gSize = BasicFactory.size((JSONArray)grammars);
            int i = 0;
            while (i < gSize) {
                JSONArray elements;
                JSONObject grammar = (JSONObject)BasicFactory.getArrayItem((JSONArray)grammars, (int)i);
                if (grammar != null && (elements = (JSONArray)BasicFactory.getItem((Object)grammar, (String)ELEMENTS)) != null) {
                    int eSize = BasicFactory.size((JSONArray)elements);
                    int j = 0;
                    while (j < eSize) {
                        JSONObject element = (JSONObject)BasicFactory.getArrayItem((JSONArray)elements, (int)j);
                        if (element != null) {
                            int k = 0;
                            while (k < AESTHETICS_LIST.length) {
                                Object aestheticObj = BasicFactory.getItem((Object)element, (String)AESTHETICS_LIST[k]);
                                if (aestheticObj != null && BasicFactory.isArray((Object)aestheticObj)) {
                                    JSONArray aestheticAr = (JSONArray)aestheticObj;
                                    int aSize = BasicFactory.size((JSONArray)aestheticAr);
                                    int m = 0;
                                    while (m < aSize) {
                                        JSONObject ae;
                                        String id;
                                        Object aesthetic = BasicFactory.getArrayItem((JSONArray)aestheticAr, (int)m);
                                        if (aesthetic != null && BasicFactory.isObject((Object)aesthetic) && (id = (String)BasicFactory.getItem((Object)(ae = (JSONObject)aesthetic), (String)ID)) != null) {
                                            this.referenceIds.add(id);
                                        }
                                        ++m;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private boolean removeFromGrammar(JSONObject spec) {
        JSONArray grammars = (JSONArray)BasicFactory.getItem((Object)spec, (String)GRAMMAR);
        if (grammars != null) {
            int gSize = BasicFactory.size((JSONArray)grammars);
            int i = 0;
            while (i < gSize) {
                JSONArray elements;
                JSONObject grammar = (JSONObject)BasicFactory.getArrayItem((JSONArray)grammars, (int)i);
                if (grammar != null && (elements = (JSONArray)BasicFactory.getItem((Object)grammar, (String)ELEMENTS)) != null) {
                    int eSize = BasicFactory.size((JSONArray)elements);
                    boolean[] removeElement = new boolean[eSize];
                    boolean anyElementRemoved = false;
                    int j = 0;
                    while (j < eSize) {
                        removeElement[j] = false;
                        JSONObject element = (JSONObject)BasicFactory.getArrayItem((JSONArray)elements, (int)j);
                        if (element != null) {
                            removeElement[j] = this.elementHasBadPosition(element);
                            if (removeElement[j]) {
                                anyElementRemoved = true;
                            } else {
                                this.removeFromElementData(element);
                                this.removeFromElementAesthetics(element);
                            }
                        }
                        ++j;
                    }
                    if (anyElementRemoved) {
                        JSONArray newElements = BasicFactory.createJSONArray();
                        int j2 = 0;
                        while (j2 < eSize) {
                            if (!removeElement[j2]) {
                                BasicFactory.add((JSONArray)newElements, (Object)BasicFactory.getArrayItem((JSONArray)elements, (int)j2));
                            }
                            ++j2;
                        }
                        BasicFactory.put((Object)grammar, (String)ELEMENTS, (Object)newElements);
                        this.referenceRemoved = true;
                    }
                }
                ++i;
            }
        }
        return this.referenceRemoved;
    }

    private boolean removeFromLegends(JSONObject spec) {
        JSONArray legends = (JSONArray)BasicFactory.getItem((Object)spec, (String)LEGENDS);
        if (legends != null) {
            int size = BasicFactory.size((JSONArray)legends);
            int i = 0;
            while (i < size) {
                JSONObject legend = (JSONObject)BasicFactory.getArrayItem((JSONArray)legends, (int)i);
                if (legend != null) {
                    this.removeFromLegendAesthetics(legend);
                }
                ++i;
            }
        }
        return this.referenceRemoved;
    }

    private void removeFromElementData(JSONObject element) {
        String refValue;
        JSONObject data = (JSONObject)BasicFactory.getItem((Object)element, (String)DATA);
        if (data != null && (refValue = SpecScrubber.getReferenceValue(data)) != null && !this.referenceIds.contains(refValue)) {
            this.remove(element, DATA);
        }
    }

    private void removeFromElementAesthetics(JSONObject element) {
        int k = 0;
        while (k < AESTHETICS_LIST.length) {
            Object aestheticObj = BasicFactory.getItem((Object)element, (String)AESTHETICS_LIST[k]);
            if (aestheticObj != null) {
                JSONArray aestheticAr;
                if (BasicFactory.isObject((Object)aestheticObj)) {
                    JSONObject aesthetic = (JSONObject)aestheticObj;
                    if (this.containsInvalidReference(aesthetic)) {
                        this.remove(element, AESTHETICS_LIST[k]);
                    }
                } else if (BasicFactory.isArray((Object)aestheticObj) && this.containsInvalidReferenceFromArray(aestheticAr = (JSONArray)aestheticObj)) {
                    this.remove(element, AESTHETICS_LIST[k]);
                }
            }
            ++k;
        }
    }

    private boolean elementHasBadPosition(JSONObject element) {
        JSONArray positions = (JSONArray)BasicFactory.getItem((Object)element, (String)POSITION);
        if (positions != null) {
            return this.containsInvalidReferenceFromArray(positions);
        }
        return false;
    }

    private void removeFromLegendAesthetics(JSONObject legend) {
        JSONArray aesthetics = (JSONArray)BasicFactory.getItem((Object)legend, (String)AESTHETICS);
        if (aesthetics != null) {
            int size = BasicFactory.size((JSONArray)aesthetics);
            int i = 0;
            while (i < size) {
                JSONObject aestheticValue;
                String refValue;
                JSONObject aesthetic = (JSONObject)BasicFactory.getArrayItem((JSONArray)aesthetics, (int)i);
                if (aesthetic != null && (refValue = SpecScrubber.getReferenceValue(aestheticValue = (JSONObject)BasicFactory.getItem((Object)aesthetic, (String)AESTHETIC))) != null && !this.referenceIds.contains(refValue)) {
                    this.removeAt(aesthetics, i);
                }
                ++i;
            }
        }
    }

    private boolean containsInvalidReferenceFromArray(JSONArray jsonArray) {
        int size = BasicFactory.size((JSONArray)jsonArray);
        int i = 0;
        while (i < size) {
            Object obj = BasicFactory.getArrayItem((JSONArray)jsonArray, (int)i);
            if (BasicFactory.isObject((Object)obj) ? this.containsInvalidReference((JSONObject)obj) : BasicFactory.isArray((Object)obj) && this.containsInvalidReferenceFromArray((JSONArray)obj)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsInvalidReference(JSONObject jsonObject) {
        String[] keys = BasicFactory.keySet((Object)jsonObject);
        if (keys != null) {
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String refValue = SpecScrubber.getFieldReferenceValue(jsonObject, key);
                if (refValue != null && !this.referenceIds.contains(refValue)) {
                    return true;
                }
                Object value = BasicFactory.getItem((Object)jsonObject, (String)key);
                if (BasicFactory.isObject((Object)value) ? this.containsInvalidReference((JSONObject)value) : BasicFactory.isArray((Object)value) && this.containsInvalidReferenceFromArray((JSONArray)value)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static String getFieldReferenceValue(JSONObject fieldJson, String key) {
        Object value;
        if (REF_FIELD.equals(key) && fieldJson != null && (value = BasicFactory.getItem((Object)fieldJson, (String)key)) != null && BasicFactory.isObject((Object)value)) {
            JSONObject jsonValue = (JSONObject)value;
            return SpecScrubber.getReferenceValue(jsonValue);
        }
        return null;
    }

    private static String getReferenceValue(JSONObject refJson) {
        if (refJson != null) {
            return (String)BasicFactory.getItem((Object)refJson, (String)REF);
        }
        return null;
    }

    private void remove(JSONObject element, String key) {
        if (element != null && key != null) {
            BasicFactory.remove((Object)element, (String)key);
            this.referenceRemoved = true;
        }
    }

    private void removeAt(JSONArray elementArray, int index) {
        if (elementArray != null && index >= 0 && index < BasicFactory.size((JSONArray)elementArray)) {
            BasicFactory.removeAt((JSONArray)elementArray, (int)index);
            this.referenceRemoved = true;
        }
    }
}

