/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.CSVDataProvider;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.dataProviderService.DataProvider;
import com.ibm.vis.engine.dataProviderService.DataProviderField;
import com.ibm.vis.engine.dataProviderService.DataProviderListener;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.DateUtil;
import com.ibm.vis.engine.internal.nativeImpl.LocaleUtil;
import com.ibm.vis.engine.internal.nativeImpl.SpecUtil;
import com.ibm.vis.engine.internal.resource.ResourceService;
import com.ibm.vis.spec.internal.ResourceSpec;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/sampleDataProviderLayer")
public final class CsvDataProvider
implements DataProvider {
    private DataProviderListener listener;
    private Object args;
    private boolean hasHeader;
    private String[][] csvData;
    private int numFields;
    private DataProviderField[] fields;
    private int numRows;
    private static final int TYPE_NUMBER = 0;
    private static final int TYPE_DATE = 1;
    private static final int TYPE_STRING = 2;
    private int[] fieldTypes;
    private String[] dateFormats;
    private String locale;
    private int rowNumber;
    private Object[] rowResult;
    private static final String fieldIDBase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static ArrayList<String> formatList = null;
    private static ArrayList<String> regexList = null;
    private static final String COMMA = "(,)";
    private static final String DASH = "(-)";
    private static final String SLASH = "(/)";
    private static final String SPACE = "(\\s)*";
    private static final String START = "^";
    private static final String END = "$";
    private static final String YYYY = "([0-9][0-9][0-9][0-9])";
    private static final String YY = "([0-9][0-9])";
    private static final String DD = "((0?[1-9])|([1-2]?[0-9])|(30|31))";
    private static final String MM = "((0?[1-9])|(1?[0-2]))";
    private static final String MMM = "([a-zA-Z][a-zA-Z][a-zA-Z])";

    public CsvDataProvider(Object object) {
        this.args = object;
        this.listener = null;
        this.hasHeader = false;
        this.numFields = 0;
        this.numRows = 0;
    }

    @Override
    public void registerListener(DataProviderListener dataProviderListener) {
        this.listener = dataProviderListener;
    }

    @Override
    public DataProviderListener getListener() {
        return this.listener;
    }

    @Override
    public void prepare() {
        ResourceSpec resourceSpec = this.getResourceSpec();
        if (resourceSpec == null) {
            return;
        }
        this.csvData = this.getCSVResource(resourceSpec);
        if (this.csvData == null) {
            return;
        }
        this.hasHeader = true;
        try {
            Object object = CsvDataProvider.getArg(this.args, "hasHeader");
            if (object != null && BasicFactory.isBoolean(object)) {
                this.hasHeader = (Boolean)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = -1;
        try {
            Object object = CsvDataProvider.getArg(this.args, "scanRows");
            if (object != null && BasicFactory.isNumber(object)) {
                n = (int)Math.floor(((Number)object).doubleValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = true;
        try {
            Object object = CsvDataProvider.getArg(this.args, "validate");
            if (object != null && BasicFactory.isBoolean(object)) {
                bl = (Boolean)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.numRows = this.csvData.length;
        if (this.numRows == 0) {
            this.hasHeader = false;
            this.numFields = 0;
        } else {
            this.numFields = this.csvData[0].length;
        }
        this.locale = LocaleUtil.getDefaultLocale();
        if (this.numRows > 0) {
            this.makeFields(n);
            if (bl) {
                this.validateData();
            }
        }
        this.listener.providerReady();
    }

    private ResourceSpec getResourceSpec() {
        ResourceSpec resourceSpec = null;
        try {
            Object object = CsvDataProvider.getArg(this.args, "source");
            if (object != null) {
                try {
                    resourceSpec = (ResourceSpec)SpecUtil.createSpecObject((JSONObject)object, "ResourceSpec");
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resourceSpec == null) {
            this.fail("The \"args\" must have a \"source\" which references the CSV file resource");
            return null;
        }
        if (!"data/csv/text".equals(resourceSpec.type)) {
            this.fail("The \"args\" \"source\" must be a resource of type \"data/csv/text\"");
            return null;
        }
        return resourceSpec;
    }

    private String[][] getCSVResource(ResourceSpec resourceSpec) {
        String[][] stringArray = null;
        try {
            stringArray = (String[][])ResourceService.getInstance().getResource(resourceSpec, null);
        }
        catch (Exception exception) {
            this.fail(exception.getMessage());
            return null;
        }
        if (stringArray == null) {
            this.fail("No CSV data available from the source " + resourceSpec.id);
            return null;
        }
        return stringArray;
    }

    @Override
    public int getNumFields() {
        return this.numFields;
    }

    @Override
    public DataProviderField[] getFields() {
        return this.fields;
    }

    @Override
    public int getNumRows() {
        return this.hasHeader ? this.numRows - 1 : this.numRows;
    }

    @Override
    public Object[] getFirstRow() {
        this.rowNumber = this.hasHeader ? 1 : 0;
        return this.makeRow(this.rowNumber++);
    }

    @Override
    public Object[] getNextRow() {
        return this.makeRow(this.rowNumber++);
    }

    @Override
    public void deregister() {
    }

    private void fail(String string) {
        this.listener.providerFailed("com.ibm.rave.CSVDataProvider: " + string);
    }

    private static Object getArg(Object object, String string) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (BasicFactory.isObject(object) && (object2 = BasicFactory.getItem(object, string)) != null) {
            return object2;
        }
        if (BasicFactory.isArray(object)) {
            int n = BasicFactory.size((JSONArray)object);
            for (int i = 0; i < n; ++i) {
                Object object3;
                Object object4 = BasicFactory.getArrayItem((JSONArray)object, i);
                if (object4 == null || (object3 = CsvDataProvider.getArg(object4, string)) == null) continue;
                return object3;
            }
        }
        return null;
    }

    private void makeFields(int n) {
        int n2;
        int n3;
        this.fields = new DataProviderField[this.numFields];
        this.fieldTypes = new int[this.numFields];
        this.dateFormats = new String[this.numFields];
        this.rowResult = new Object[this.numFields];
        int n4 = n3 = this.hasHeader ? 1 : 0;
        if (n > 0) {
            n2 = n3 + n;
            if (n2 > this.numRows) {
                n2 = this.numRows;
            }
        } else {
            n2 = this.numRows;
        }
        block4: for (int i = 0; i < this.numFields; ++i) {
            this.setFieldType(i, n3, n2);
            this.fields[i] = new DataProviderField(this.makeFieldName(i));
            switch (this.fieldTypes[i]) {
                default: {
                    this.fields[i].setUnit(Unit.CATEGORICAL.name);
                    continue block4;
                }
                case 0: {
                    this.fields[i].setUnit(Unit.RATIO.name);
                    continue block4;
                }
                case 1: {
                    this.fields[i].setUnit(Unit.DATE.name);
                }
            }
        }
    }

    private String makeFieldName(int n) {
        if (this.hasHeader) {
            String string = this.csvData[0][n].trim();
            if (string.length() > 0 && !string.contains("\"")) {
                return string;
            }
            this.fail("The header name '" + string + "' is not a legal RAVE field identifier");
            return "";
        }
        if (n < 26) {
            return "" + fieldIDBase.charAt(n);
        }
        int n2 = (int)Math.floor(n / 26) - 1;
        if (n2 >= 26) {
            this.fail("Maximum of 576 columns supported");
            return "";
        }
        int n3 = n % 26;
        return "" + fieldIDBase.charAt(n2) + fieldIDBase.charAt(n3);
    }

    private void setFieldType(int n, int n2, int n3) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        String string = null;
        for (int i = n2; i < n3 && (bl || bl3); ++i) {
            String string2 = this.csvData[i][n].trim();
            if (string2.length() == 0) continue;
            if (bl) {
                double d = BasicFactory.parseDouble(string2);
                if (Double.isNaN(d)) {
                    bl = false;
                } else {
                    bl2 = true;
                    bl3 = false;
                }
            }
            if (!bl3) continue;
            String string3 = this.isDate(string2);
            if (string3 == null) {
                bl3 = false;
                continue;
            }
            if (string == null) {
                string = string3;
            } else {
                bl3 = string.equals(string3);
            }
            bl = false;
        }
        this.dateFormats[n] = null;
        if (bl && bl2) {
            this.fieldTypes[n] = 0;
        } else if (bl3 && string != null) {
            this.dateFormats[n] = string;
            this.fieldTypes[n] = 1;
        } else {
            this.fieldTypes[n] = 2;
        }
    }

    private void validateData() {
        for (int i = 0; i < this.numRows; ++i) {
            if (this.csvData[i].length == this.numFields) continue;
            this.fail("Not all rows in the CSV file have the same number of fields");
            break;
        }
    }

    private Object[] makeRow(int n) {
        boolean bl = true;
        if (n >= 0 && n < this.numRows) {
            try {
                String[] stringArray = this.csvData[n];
                for (int i = 0; i < this.numFields; ++i) {
                    String string = stringArray[i];
                    this.rowResult[i] = string == null ? null : (this.fieldTypes[i] == 2 ? string : ((string = string.trim()).length() == 0 ? null : (this.fieldTypes[i] == 0 ? Double.valueOf(BasicFactory.parseDouble(string)) : Double.valueOf(DateUtil.fromDateString(this.dateFormats[i], string, this.locale)))));
                }
                bl = false;
            }
            catch (Exception exception) {
                this.fail(exception.getMessage());
            }
        }
        if (bl) {
            for (int i = 0; i < this.numFields; ++i) {
                this.rowResult[i] = null;
            }
        }
        return this.rowResult;
    }

    private static synchronized void initFormatLists() {
        if (formatList == null) {
            formatList = new ArrayList();
            regexList = new ArrayList();
            formatList.add("yyyy-MM-dd");
            regexList.add("^([0-9][0-9][0-9][0-9])(-)((0?[1-9])|(1?[0-2]))(-)((0?[1-9])|([1-2]?[0-9])|(30|31))$");
            formatList.add("yyyy/MM/dd");
            regexList.add("^([0-9][0-9][0-9][0-9])(/)((0?[1-9])|(1?[0-2]))(/)((0?[1-9])|([1-2]?[0-9])|(30|31))$");
            formatList.add("dd/dd/yyyy");
            regexList.add("^((0?[1-9])|([1-2]?[0-9])|(30|31))(/)((0?[1-9])|([1-2]?[0-9])|(30|31))(/)([0-9][0-9][0-9][0-9])$");
            formatList.add("dd-dd-yyyy");
            regexList.add("^((0?[1-9])|([1-2]?[0-9])|(30|31))(-)((0?[1-9])|([1-2]?[0-9])|(30|31))(-)([0-9][0-9][0-9][0-9])$");
            formatList.add("MM/dd/yy");
            regexList.add("^((0?[1-9])|(1?[0-2]))(/)((0?[1-9])|([1-2]?[0-9])|(30|31))(/)([0-9][0-9])$");
            formatList.add("MM-dd-yy");
            regexList.add("^((0?[1-9])|(1?[0-2]))(-)((0?[1-9])|([1-2]?[0-9])|(30|31))(-)([0-9][0-9])$");
            formatList.add("dd MMM yyyy");
            regexList.add("^((0?[1-9])|([1-2]?[0-9])|(30|31))(\\s)*([a-zA-Z][a-zA-Z][a-zA-Z])(\\s)*([0-9][0-9][0-9][0-9])$");
            formatList.add("dd MMM yy");
            regexList.add("^((0?[1-9])|([1-2]?[0-9])|(30|31))(\\s)*([a-zA-Z][a-zA-Z][a-zA-Z])(\\s)*([0-9][0-9])$");
            formatList.add("dd/MMM/yyyy");
            regexList.add("^((0?[1-9])|([1-2]?[0-9])|(30|31))(/)([a-zA-Z][a-zA-Z][a-zA-Z])(/)([0-9][0-9][0-9][0-9])$");
            formatList.add("dd-MMM-yyyy");
            regexList.add("^((0?[1-9])|([1-2]?[0-9])|(30|31))(-)([a-zA-Z][a-zA-Z][a-zA-Z])(-)([0-9][0-9][0-9][0-9])$");
            formatList.add("MMM dd,yyyy");
            regexList.add("^([a-zA-Z][a-zA-Z][a-zA-Z])(\\s)*((0?[1-9])|([1-2]?[0-9])|(30|31))(\\s)*(,)(\\s)*([0-9][0-9][0-9][0-9])$");
        }
    }

    private String isDate(String string) {
        CsvDataProvider.initFormatLists();
        if (string != null && string.trim().length() >= 0) {
            String string2 = string.trim();
            int n = formatList.size();
            for (int i = 0; i < n; ++i) {
                if (!string2.matches(regexList.get(i))) continue;
                return formatList.get(i);
            }
        }
        return null;
    }
}

