/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sampleDataProvider;

import com.ibm.json.java.JSONArray;
import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.dataProviderService.DataProviderField;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;

@OnDemandLoad(value="com/ibm/vis/layers/sampleDataProviderLayer")
public final class SampleDataDriver {
    public static final String FISH_TYPE = "FISH";
    public static final String FORMAT_TYPE = "FORMAT";
    public static final String NEWFORMAT_TYPE = "NEW_FORMAT";
    public static final String DATEFORMAT_TYPE = "DATE_FORMAT";
    public static final String SCIENCEFORMAT_TYPE = "SCIENCE_FORMAT";
    public static final String ORDER_TYPE = "ORDER";
    public static final String SIN_ELLIPSIS_TYPE = "SIN_ELLIPSIS";
    private String failureCause = null;
    private DataProviderField[] fields;
    private Object[][] rows;
    private static int sinEllipsisOffset = 0;

    public boolean initialize(Object object) {
        Object object2 = SampleDataDriver.getArg(object, "type");
        if (object2 == null) {
            this.failureCause = "The provider \"args\" do not contain a \"type\" with the sample provider type";
            return false;
        }
        if (FISH_TYPE.equals(object2)) {
            this.initializeFish(object);
            return true;
        }
        if (FORMAT_TYPE.equals(object2)) {
            this.initializeFormat(object);
            return true;
        }
        if (SCIENCEFORMAT_TYPE.equals(object2)) {
            this.initializeScientificFormat(object);
            return true;
        }
        if (DATEFORMAT_TYPE.equals(object2)) {
            this.initializeDateFormat(object);
            return true;
        }
        if (ORDER_TYPE.equals(object2)) {
            this.initializeOrder(object);
            return true;
        }
        if (SIN_ELLIPSIS_TYPE.equals(object2)) {
            this.initializeSinEllipsis(object);
            return true;
        }
        this.failureCause = "The provider \"type\" is not known: " + object2;
        return false;
    }

    public String getFailure() {
        return this.failureCause;
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public int getNumRows() {
        return this.rows.length;
    }

    public DataProviderField[] getFields() {
        return this.fields;
    }

    public Object[] getRow(int n) {
        return this.rows[n];
    }

    public void close() {
        this.fields = null;
        this.rows = null;
    }

    public void initializeFish(Object object) {
        this.fields = new DataProviderField[7];
        this.fields[0] = new DataProviderField("x");
        this.fields[0].setKey(true);
        this.fields[0].setUnit("categorical");
        this.fields[1] = new DataProviderField("y");
        this.fields[1].setUnit("categorical");
        this.fields[2] = new DataProviderField("headsize");
        this.fields[2].setMin(0);
        this.fields[2].setMax(1);
        this.fields[3] = new DataProviderField("tailsize");
        this.fields[3].setMin(0);
        this.fields[3].setMax(1);
        this.fields[4] = new DataProviderField("size");
        this.fields[4].setMin(0);
        this.fields[4].setMax(1);
        this.fields[5] = new DataProviderField("color");
        this.fields[5].setCategories(new String[]{"numeric", "date", "categorical", "text"});
        this.fields[6] = new DataProviderField("name");
        this.fields[6].setUnit("categorical");
        this.rows = new Object[][]{{0, 0, 0.5, 0.8, 0.8, "numeric", "salary"}, {1, 0, 0.95, 0.3, 0.8, 1, "date"}, {0, 1, 0.35, 0.4, 0.2, 2, "status"}, {1, 1, 0.45, 0.1, 0.9, "text", "comment"}};
        boolean bl = "true".equals(SampleDataDriver.getArg(object, "random"));
        if (bl) {
            for (int i = 0; i < this.rows.length; ++i) {
                for (int j = 2; j <= 4; ++j) {
                    this.rows[i][j] = 0.1 + 0.9 * Math.random();
                }
            }
        }
    }

    public void initializeOrder(Object object) {
        int n;
        int n2;
        int n3;
        String[] stringArray = new String[]{"Q1", "Q2", "Q3", "Q4"};
        String[] stringArray2 = new String[]{"Ontario", "Quebec", "Alberta", "B.C.", "Saskatchewan"};
        this.fields = new DataProviderField[3];
        this.fields[0] = new DataProviderField("categories");
        this.fields[0].setLabel("Time");
        this.fields[0].setCategories(stringArray);
        this.fields[1] = new DataProviderField("provinces");
        this.fields[1].setLabel("Provinces");
        this.fields[1].setCategories(stringArray2);
        this.fields[2] = new DataProviderField("revenue");
        boolean bl = "true".equals(SampleDataDriver.getArg(object, "random"));
        if (!bl) {
            this.rows = new Object[][]{{0, 0, 36000}, {1, 0, 9500}, {3, 0, 52000}, {0, 1, 5000}, {1, 1, 7500}, {2, 1, 17000}, {3, 1, 42000}, {0, 2, 3000}, {1, 2, 8500}, {2, 2, 23000}, {3, 2, 72000}, {0, 3, 12000}, {1, 3, 4500}, {2, 3, 23000}, {3, 3, 1000}, {0, 4, 8000}, {2, 4, 49000}, {3, 4, 21000}};
            return;
        }
        Number[] numberArray = new Number[5];
        boolean[] blArray = new boolean[10];
        for (n3 = 0; n3 < 10; ++n3) {
            blArray[n3] = false;
        }
        for (n3 = 0; n3 < 5; ++n3) {
            n2 = SampleDataDriver.random(0, 10);
            for (n = 0; blArray[n2] && n < 5; ++n) {
                n2 = SampleDataDriver.random(0, 10);
            }
            while (blArray[n2]) {
                n2 = (n2 + 1) % 10;
            }
            numberArray[n3] = n2;
        }
        Object[][] objectArrayArray = new Object[stringArray.length * stringArray2.length][];
        n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (SampleDataDriver.random(0, 100) >= 80) continue;
                objectArrayArray[n2++] = new Object[]{stringArray[n], stringArray2[i], 500 * SampleDataDriver.random(2, 201)};
            }
        }
        this.rows = new Object[n2][];
        for (n = 0; n < n2; ++n) {
            this.rows[n] = objectArrayArray[n];
        }
    }

    public void initializeFormat(Object object) {
        this.fields = new DataProviderField[5];
        this.fields[0] = new DataProviderField("no format");
        this.fields[1] = new DataProviderField("prefix suffix");
        this.fields[1].setPrefix("$");
        this.fields[1].setSuffix("(US)");
        this.fields[2] = new DataProviderField("no decimal");
        this.fields[2].setNumericPattern("$#$");
        this.fields[3] = new DataProviderField("two decimals");
        this.fields[3].setNumericPattern("#.00");
        this.fields[4] = new DataProviderField("grouping");
        this.fields[4].setNumericPattern("#,###.00");
        Object[] objectArray = new Object[5];
        for (int i = 0; i < 5; ++i) {
            objectArray[i] = 1000.123;
        }
        Object[] objectArray2 = new Object[5];
        for (int i = 0; i < 5; ++i) {
            objectArray2[i] = 1001;
        }
        this.rows = new Object[2][];
        this.rows[0] = objectArray;
        this.rows[1] = objectArray2;
    }

    public void initializeScientificFormat(Object object) {
        this.fields = new DataProviderField[2];
        String string = (String)SampleDataDriver.getArg(object, "pattern");
        if (string == null) {
            string = "00.###E0";
        }
        this.fields[0] = new DataProviderField("fCategories");
        this.fields[0].setLabel("Store");
        this.fields[0].setCategories(new String[]{"California", "Illinois", "New York", "Texas"});
        this.fields[1] = new DataProviderField("fValues");
        this.fields[1].setLabel("Price");
        this.fields[1].setMin(342765.5);
        this.fields[1].setMax(397276);
        this.fields[1].setScientificPattern(string);
        this.fields[1].setUnit("price");
        this.rows = new Object[][]{{3, 397223.5}, {2, 267223.5}, {1, 372765.5}, {0, 188587.5}};
    }

    public void initializeDateFormat(Object object) {
        this.fields = new DataProviderField[2];
        String string = (String)SampleDataDriver.getArg(object, "pattern");
        if (string == null) {
            string = "MMM d, yy hh:mm aaa";
        }
        this.fields[0] = new DataProviderField("fCategories");
        this.fields[0].setLabel("Store");
        this.fields[0].setCategories(new String[]{"California", "Illinois", "New York", "Texas"});
        this.fields[1] = new DataProviderField("fValues");
        this.fields[1].setLabel("Price");
        this.fields[1].setMin(342765.5);
        this.fields[1].setMax(397276);
        this.fields[1].setDatePattern(string);
        this.fields[1].setUnit("timestamp");
        this.rows = new Object[][]{{3, 397223.5}, {2, 367223.5}, {1, 372765.5}, {0, 388587.5}};
    }

    public void initializeSinEllipsis(Object object) {
        this.fields = new DataProviderField[2];
        String[] stringArray = new String[10];
        for (int i = 0; i < 10; ++i) {
            stringArray[i] = "C" + (i + 1);
        }
        this.fields[0] = new DataProviderField("categories");
        this.fields[0].setLabel("Countries");
        this.fields[0].setCategories(stringArray);
        this.fields[1] = new DataProviderField("values");
        this.fields[1].setLabel("Population");
        boolean bl = "true".equals(SampleDataDriver.getArg(object, "random"));
        if (!bl) {
            sinEllipsisOffset = 0;
        }
        int n = sinEllipsisOffset;
        sinEllipsisOffset = (sinEllipsisOffset + 1) % 10;
        this.rows = new Object[10][];
        for (int i = 0; i < 10; ++i) {
            int n2 = (i + n) % 10;
            double d = 1125.0;
            int n3 = (int)Math.floor(250.0 + d + d * Math.sin((double)n2 * Math.PI * 2.0 / 10.0));
            this.rows[i] = new Object[]{stringArray[10 - i - 1], n3};
        }
    }

    public static Object getArg(Object object, String string) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (BasicFactory.isObject(object) && (object2 = BasicFactory.getItem(object, string)) != null) {
            return object2;
        }
        if (BasicFactory.isArray(object)) {
            int n = BasicFactory.size((JSONArray)object);
            for (int i = 0; i < n; ++i) {
                Object object3;
                Object object4 = BasicFactory.getArrayItem((JSONArray)object, i);
                if (object4 == null || (object3 = SampleDataDriver.getArg(object4, string)) == null) continue;
                return object3;
            }
        }
        return null;
    }

    private static int random(int n, int n2) {
        int n3 = (int)Math.floor(Math.random() * (double)(n2 - n));
        if (n3 < n) {
            n3 = n;
        }
        if (n3 >= n2) {
            n3 = n2 - 1;
        }
        return n3;
    }
}

