/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class LocalizationSettings {
    public static final String BASE_TEXT_DIRECTION_AUTO = "auto";
    public static final String BASE_TEXT_DIRECTION_LEFT_TO_RIGHT = "ltr";
    public static final String BASE_TEXT_DIRECTION_RIGHT_TO_LEFT = "rtl";
    private String locale = null;
    private String baseTextDirection = "auto";
    private boolean mirror = false;
    private String nationalDigitShapingCode = null;
    private String[] contextualShapingDigitCodes = null;
    private String contextualShapingDefaultContext = null;

    public LocalizationSettings copy() {
        LocalizationSettings localizationSettings = new LocalizationSettings();
        localizationSettings.locale = this.locale;
        localizationSettings.baseTextDirection = this.baseTextDirection;
        localizationSettings.mirror = this.mirror;
        localizationSettings.nationalDigitShapingCode = this.nationalDigitShapingCode;
        localizationSettings.setContextualShapingDigitCodes(this.contextualShapingDigitCodes);
        localizationSettings.contextualShapingDefaultContext = this.contextualShapingDefaultContext;
        return localizationSettings;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String string) {
        this.locale = string;
    }

    public String getBaseTextDirection() {
        return this.baseTextDirection;
    }

    public void setBaseTextDirection(String string) {
        if (BASE_TEXT_DIRECTION_AUTO.equals(string) || BASE_TEXT_DIRECTION_LEFT_TO_RIGHT.equals(string) || BASE_TEXT_DIRECTION_RIGHT_TO_LEFT.equals(string)) {
            this.baseTextDirection = string;
        }
    }

    public boolean isMirror() {
        return this.mirror;
    }

    public void setMirror(boolean bl) {
        this.mirror = bl;
    }

    public String getNationalDigitShapingCode() {
        return this.nationalDigitShapingCode;
    }

    public void setNationalDigitShapingCode(String string) {
        this.nationalDigitShapingCode = string;
    }

    public String[] getContextualShapingDigitCodes() {
        if (this.contextualShapingDigitCodes == null) {
            return null;
        }
        int n = this.contextualShapingDigitCodes.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.contextualShapingDigitCodes[i];
        }
        return stringArray;
    }

    public void setContextualShapingDigitCodes(String[] stringArray) {
        if (stringArray == null) {
            this.contextualShapingDigitCodes = null;
        } else {
            int n = stringArray.length;
            this.contextualShapingDigitCodes = new String[n];
            for (int i = 0; i < n; ++i) {
                this.contextualShapingDigitCodes[i] = stringArray[i];
            }
        }
    }

    public String getContextualShapingDefaultContext() {
        return this.contextualShapingDefaultContext;
    }

    public void setContextualShapingDefaultContext(String string) {
        this.contextualShapingDefaultContext = string;
    }
}

