/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.configuration;

import com.ibm.vis.engine.DateFormatter;
import com.ibm.vis.engine.LocalizationSettings;
import com.ibm.vis.engine.LocalizedDateFormatter;
import com.ibm.vis.engine.LocalizedNumberFormatter;
import com.ibm.vis.engine.NumberFormatter;
import com.ibm.vis.engine.StringFormatter;
import com.ibm.vis.engine.configuration.ContrastParameters;
import com.ibm.vis.engine.configuration.HighContrastState;
import com.ibm.vis.engine.configuration.IVisConfiguration;

public class VisConfiguration
implements IVisConfiguration {
    private String specificationDefaultVersion = null;
    private boolean specificationValidation = true;
    private NumberFormatter numberFormatter = null;
    private LocalizedNumberFormatter localizedNumberFormatter = null;
    private StringFormatter stringFormatter = null;
    private DateFormatter dateFormatter = null;
    private LocalizedDateFormatter localizedDateFormatter = null;
    private LocalizationSettings defaultLocalization = new LocalizationSettings();
    private String baseURI = null;
    private boolean generateTruncatedTooltips = false;
    private boolean generateAccessibility = false;
    private HighContrastState highContrastState = HighContrastState.SYSTEM_DEFAULT;
    private ContrastParameters contrastParameters;

    @Override
    public String getSpecificationDefaultVersion() {
        return this.specificationDefaultVersion;
    }

    @Override
    public void setSpecificationDefaultVersion(String string) {
        this.specificationDefaultVersion = string;
    }

    @Override
    public boolean getSpecificationValidation() {
        return this.specificationValidation;
    }

    @Override
    public void setSpecificationValidation(boolean bl) {
        this.specificationValidation = bl;
    }

    @Override
    public NumberFormatter getNumberFormatter() {
        return this.numberFormatter;
    }

    @Override
    public void setNumberFormatter(NumberFormatter numberFormatter) {
        this.numberFormatter = numberFormatter;
    }

    @Override
    public LocalizedNumberFormatter getLocalizedNumberFormatter() {
        return this.localizedNumberFormatter;
    }

    @Override
    public void setLocalizedNumberFormatter(LocalizedNumberFormatter localizedNumberFormatter) {
        this.localizedNumberFormatter = localizedNumberFormatter;
    }

    @Override
    public StringFormatter getStringFormatter() {
        return this.stringFormatter;
    }

    @Override
    public void setStringFormatter(StringFormatter stringFormatter) {
        this.stringFormatter = stringFormatter;
    }

    @Override
    public DateFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    @Override
    public void setDateFormatter(DateFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    @Override
    public LocalizedDateFormatter getLocalizedDateFormatter() {
        return this.localizedDateFormatter;
    }

    @Override
    public void setLocalizedDateFormatter(LocalizedDateFormatter localizedDateFormatter) {
        this.localizedDateFormatter = localizedDateFormatter;
    }

    @Override
    public LocalizationSettings getDefaultLocalization() {
        return this.defaultLocalization;
    }

    @Override
    public void setDefaultLocalization(LocalizationSettings localizationSettings) {
        if (localizationSettings != null) {
            this.defaultLocalization = localizationSettings.copy();
        }
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    @Override
    public boolean getTooltipsForTruncatedText() {
        return this.generateTruncatedTooltips;
    }

    @Override
    public void setTooltipsForTruncatedText(boolean bl) {
        this.generateTruncatedTooltips = bl;
    }

    @Override
    public boolean getGenerateAccessibility() {
        return this.generateAccessibility;
    }

    @Override
    public void setGenerateAccessibility(boolean bl) {
        this.generateAccessibility = bl;
    }

    @Override
    @Deprecated
    public HighContrastState getHighContrast() {
        return this.highContrastState;
    }

    @Override
    @Deprecated
    public void setHighContrast(HighContrastState highContrastState) {
        this.highContrastState = highContrastState;
    }

    @Override
    public void copyConfigurationFrom(IVisConfiguration iVisConfiguration) {
        this.numberFormatter = iVisConfiguration.getNumberFormatter();
        this.localizedNumberFormatter = iVisConfiguration.getLocalizedNumberFormatter();
        this.stringFormatter = iVisConfiguration.getStringFormatter();
        this.dateFormatter = iVisConfiguration.getDateFormatter();
        this.localizedDateFormatter = iVisConfiguration.getLocalizedDateFormatter();
        this.specificationDefaultVersion = iVisConfiguration.getSpecificationDefaultVersion();
        this.specificationValidation = iVisConfiguration.getSpecificationValidation();
        this.setDefaultLocalization(iVisConfiguration.getDefaultLocalization());
        this.baseURI = iVisConfiguration.getBaseURI();
        this.generateTruncatedTooltips = iVisConfiguration.getTooltipsForTruncatedText();
        this.generateAccessibility = iVisConfiguration.getGenerateAccessibility();
        this.highContrastState = iVisConfiguration.getHighContrast();
        this.contrastParameters = iVisConfiguration.getContrast();
    }

    @Override
    public void setContrast(ContrastParameters contrastParameters) {
        this.contrastParameters = contrastParameters;
    }

    @Override
    public ContrastParameters getContrast() {
        return this.contrastParameters;
    }
}

