/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.data.transform.internal;

import com.ibm.vis.engine.data.transform.SummaryFunction;
import com.ibm.vis.engine.data.transform.SummaryFunctionProviderFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.concurrent.ConcurrentHashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SummaryFunctionServiceUtility {
    private static SummaryFunctionServiceUtility INSTANCE = new SummaryFunctionServiceUtility();
    private final ConcurrentHashMap<String, SummaryFunctionProviderFactory> summaryFunctionFactories = new ConcurrentHashMap(16, 0.75f, 1);

    public static SummaryFunctionServiceUtility getInstance() {
        return INSTANCE;
    }

    private SummaryFunctionServiceUtility() {
    }

    public synchronized void registerFactory(SummaryFunctionProviderFactory summaryFunctionProviderFactory) {
        if (summaryFunctionProviderFactory == null) {
            return;
        }
        String[] stringArray = summaryFunctionProviderFactory.getSummaryFunctionIDList();
        if (stringArray != null) {
            for (String string : stringArray) {
                this.summaryFunctionFactories.put(string, summaryFunctionProviderFactory);
            }
        }
    }

    public synchronized void unregisterFactory(SummaryFunctionProviderFactory summaryFunctionProviderFactory) {
        if (summaryFunctionProviderFactory == null) {
            return;
        }
        String[] stringArray = summaryFunctionProviderFactory.getSummaryFunctionIDList();
        if (stringArray != null) {
            for (String string : stringArray) {
                this.summaryFunctionFactories.remove(string);
            }
        }
    }

    public synchronized SummaryFunction getSummaryFunction(String string) {
        if (string == null) {
            return null;
        }
        SummaryFunction summaryFunction = null;
        SummaryFunctionProviderFactory summaryFunctionProviderFactory = this.summaryFunctionFactories.get(string);
        if (summaryFunctionProviderFactory != null) {
            summaryFunction = summaryFunctionProviderFactory.getSummaryFunction(string);
        }
        return summaryFunction;
    }
}

