/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.dataProviderService.internal;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.dataProviderService.DataProvider;
import com.ibm.vis.engine.dataProviderService.DataProviderField;
import com.ibm.vis.engine.dataProviderService.internal.DataProviderFieldConverter;
import com.ibm.vis.engine.dataProviderService.internal.DataProviderListenerImpl;
import com.ibm.vis.engine.dataProviderService.internal.DataProviderServiceDelegate;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.DataProviderConverter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.FieldSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/dataProviderLayer")
public class DataProviderConverterImpl
implements DataProviderConverter {
    private Data data;
    private DataSpec dataSpec;
    private DataProvider provider;
    private DataProviderListenerImpl listener;
    private int numFields;
    private DataProviderFieldConverter[] fieldConverters;

    public DataProviderConverterImpl(Data data, DataSpec dataSpec, DataProvider dataProvider, DataProviderListenerImpl dataProviderListenerImpl) {
        this.data = data;
        this.dataSpec = dataSpec;
        this.provider = dataProvider;
        this.listener = dataProviderListenerImpl;
        this.numFields = -1;
        this.fieldConverters = null;
    }

    @Override
    public void setFields() {
        int n;
        DataProviderField[] dataProviderFieldArray;
        if (this.fieldConverters != null) {
            throw new EngineException("An internal engine error occurred (DataProviderAdapter#setFields method called twice)", ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
        }
        this.listener.checkFailure();
        try {
            this.numFields = this.provider.getNumFields();
        }
        catch (Exception exception) {
            throw DataProviderServiceDelegate.wrapException(exception);
        }
        this.listener.checkFailure();
        try {
            dataProviderFieldArray = this.provider.getFields();
        }
        catch (Exception exception) {
            throw DataProviderServiceDelegate.wrapException(exception);
        }
        this.listener.checkFailure();
        if (this.numFields != dataProviderFieldArray.length) {
            throw new EngineException("A DataProvider's getNumFields and getFields returned inconsistent information", ErrorCode.DATA_PROVIDER_CONVERSION, null);
        }
        for (n = 0; n < this.numFields; ++n) {
            if (dataProviderFieldArray[n] != null) continue;
            throw new EngineException("A DataProvider's getFields returned a null field descriptor", ErrorCode.DATA_PROVIDER_CONVERSION, null);
        }
        this.fieldConverters = new DataProviderFieldConverter[this.numFields];
        this.dataSpec.fields = new FieldSpec[this.numFields];
        for (n = 0; n < this.numFields; ++n) {
            this.fieldConverters[n] = new DataProviderFieldConverter(dataProviderFieldArray[n].copy());
            this.dataSpec.fields[n] = this.fieldConverters[n].makeFieldSpec();
        }
    }

    @Override
    public void setRows() {
        Object[] objectArray;
        int n;
        int n2;
        this.listener.checkFailure();
        try {
            n2 = this.provider.getNumRows();
        }
        catch (Exception exception) {
            throw DataProviderServiceDelegate.wrapException(exception);
        }
        this.dataSpec.rows = new double[n2][];
        for (n = 0; n < n2; ++n) {
            this.listener.checkFailure();
            try {
                objectArray = n == 0 ? this.provider.getFirstRow() : this.provider.getNextRow();
            }
            catch (Exception exception) {
                throw DataProviderServiceDelegate.wrapException(exception);
            }
            this.dataSpec.rows[n] = this.makeRow(objectArray);
        }
        this.listener.checkFailure();
        for (n = 0; n < this.numFields; ++n) {
            objectArray = this.fieldConverters[n].getCategories();
            if (objectArray == null) continue;
            this.dataSpec.fields[n].categories = objectArray;
            if (this.data.fields == null || this.data.fields[n] == null) continue;
            this.data.fields[n].categories = objectArray;
        }
    }

    private double[] makeRow(Object[] objectArray) {
        if (objectArray == null || objectArray.length != this.numFields) {
            throw new EngineException("A DataProvider's getFirstRow/getNextRow returned a null row or one with the wrong number of fields", ErrorCode.DATA_PROVIDER_CONVERSION, null);
        }
        double[] dArray = new double[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            dArray[i] = this.fieldConverters[i].convertValue(objectArray[i]);
        }
        return dArray;
    }

    @Override
    public boolean isReady() {
        return this.listener.isReady();
    }
}

