/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.dataProviderService.internal;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.dataProviderService.DataProviderField;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.DateUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.FormatSpec;
import com.ibm.vis.spec.internal.NegativeFormatSpec;
import com.ibm.vis.spec.internal.NoSpaceFormatSpec;
import com.ibm.vis.spec.internal.ScientificSpec;
import com.ibm.vis.spec.internal.ZeroFormatSpec;
import java.util.ArrayList;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/dataProviderLayer")
class DataProviderFieldConverter {
    private DataProviderField field;
    private static final int FIELD_DEFINED_CATEGORIES = 0;
    private static final int FIELD_CATEGORICAL = 1;
    private static final int FIELD_CATEGORICAL_NUMBER = 2;
    private static final int FIELD_CATEGORICAL_STRING = 3;
    private static final int FIELD_TIME = 4;
    private static final int FIELD_CONTINUOUS = 5;
    private int fieldType;
    private final Unit unit;
    private final int numDefinedCategories;
    private HashMap<String, Integer> categoryToIndex;
    private ArrayList<String> categoryList;

    DataProviderFieldConverter(DataProviderField dataProviderField) {
        this.field = dataProviderField;
        String[] stringArray = dataProviderField.getCategories();
        int n = this.numDefinedCategories = stringArray == null ? 0 : stringArray.length;
        Unit unit = dataProviderField.getUnit() == null ? null : (this.unit = Unit.get(dataProviderField.getUnit(), stringArray == null ? Unit.RATIO : Unit.CATEGORICAL));
        if (stringArray != null) {
            this.fieldType = 0;
            this.categoryToIndex = new HashMap();
            for (int i = 0; i < stringArray.length; ++i) {
                this.categoryToIndex.put(stringArray[i], i);
            }
        } else {
            this.fieldType = Unit.CATEGORICAL == this.unit ? 1 : (this.unit == Unit.DATE || this.unit == Unit.TIME || this.unit == Unit.TIMESTAMP ? 4 : 5);
        }
    }

    double convertValue(Object object) {
        double d;
        if (object == null) {
            return Double.NaN;
        }
        if (BasicFactory.isNumber(object) && Double.isNaN(d = ((Number)object).doubleValue())) {
            return Double.NaN;
        }
        switch (this.fieldType) {
            case 0: {
                return this.convertDefinedCategories(object);
            }
            case 1: {
                return this.convertCategorical(object);
            }
            case 2: {
                return this.convertCategoricalNumber(object);
            }
            case 3: {
                return this.convertCategoricalString(object);
            }
            case 4: {
                return this.convertTime(object);
            }
            case 5: {
                return this.convertContinuous(object);
            }
        }
        throw new EngineException("An internal error occurred in data conversion: field type " + this.fieldType, ErrorCode.DATA_PROVIDER_CONVERSION, null);
    }

    private double convertDefinedCategories(Object object) {
        if (BasicFactory.isString(object)) {
            String string = (String)object;
            Integer n = this.categoryToIndex.get((String)object);
            if (n == null) {
                throw new EngineException("The string '" + string + "' does not appear in the \"categories\" of field " + this.field.getName(), ErrorCode.DATA_PROVIDER_CONVERSION, null);
            }
            return n.doubleValue();
        }
        if (BasicFactory.isNumber(object)) {
            int n;
            double d = ((Number)object).doubleValue();
            if (Math.floor(d) == d && (n = (int)Math.floor(d)) >= 0 && n < this.numDefinedCategories) {
                return n;
            }
            throw new EngineException("The value '" + d + "' is not a legal index for the \"categories\" of field " + this.field.getName(), ErrorCode.DATA_PROVIDER_CONVERSION, null);
        }
        throw new EngineException("Illegal data value returned by data provider for field '" + this.field.getName() + "'; for fields with \"categories\" only number and string are allowed", ErrorCode.DATA_PROVIDER_CONVERSION, null);
    }

    private double convertCategorical(Object object) {
        if (BasicFactory.isNumber(object)) {
            this.fieldType = 2;
            return this.convertCategoricalNumber(object);
        }
        if (BasicFactory.isString(object)) {
            this.fieldType = 3;
            this.categoryToIndex = new HashMap();
            this.categoryList = new ArrayList();
            return this.convertCategoricalString(object);
        }
        throw new EngineException("Illegal data value returned by data provider for field '" + this.field.getName() + "'; for unit:categorical fields only number and string are allowed" + this.field.getName(), ErrorCode.DATA_PROVIDER_CONVERSION, null);
    }

    private double convertCategoricalNumber(Object object) {
        double d;
        if (BasicFactory.isNumber(object) && (d = ((Number)object).doubleValue()) == Math.floor(d) && d >= 0.0) {
            return d;
        }
        throw new EngineException("Illegal data value returned by data provider for field '" + this.field.getName() + "'; only non-negative integers are allowed in this field" + this.field.getName(), ErrorCode.DATA_PROVIDER_CONVERSION, null);
    }

    private double convertCategoricalString(Object object) {
        if (BasicFactory.isString(object)) {
            int n;
            String string = (String)object;
            Integer n2 = this.categoryToIndex.get(string);
            if (n2 != null) {
                n = n2;
            } else {
                n = this.categoryList.size();
                this.categoryToIndex.put(string, n);
                this.categoryList.add(string);
            }
            return n;
        }
        throw new EngineException("Illegal data value returned by data provider for field '" + this.field.getName() + "'; only strings are allowed in this field" + this.field.getName(), ErrorCode.DATA_PROVIDER_CONVERSION, null);
    }

    private double convertTime(Object object) {
        if (BasicFactory.isNumber(object)) {
            return ((Number)object).doubleValue();
        }
        Object object2 = DateUtil.INSTANCE.asDate(object);
        if (object2 != null) {
            return DateUtil.INSTANCE.fromDateObject(object2, this.unit);
        }
        throw new EngineException("Illegal data value returned by data provider for field '" + this.field.getId() + "'; for time fields only number and date are allowed" + this.field.getId(), ErrorCode.DATA_PROVIDER_CONVERSION, null);
    }

    private double convertContinuous(Object object) {
        if (BasicFactory.isNumber(object)) {
            return ((Number)object).doubleValue();
        }
        throw new EngineException("Illegal data value returned by data provider for field '" + this.field.getName() + "'; for continuous fields only number is allowed" + this.field.getName(), ErrorCode.DATA_PROVIDER_CONVERSION, null);
    }

    String[] getCategories() {
        String[] stringArray = null;
        if (this.field.getCategories() != null) {
            String[] stringArray2 = this.field.getCategories();
            stringArray = new String[this.numDefinedCategories];
            for (int i = 0; i < this.numDefinedCategories; ++i) {
                stringArray[i] = stringArray2[i];
            }
        } else if (this.categoryList != null) {
            stringArray = this.categoryList.toArray(new String[this.categoryList.size()]);
        }
        return stringArray;
    }

    FieldSpec makeFieldSpec() {
        FieldSpec fieldSpec = new FieldSpec();
        fieldSpec.id = this.field.getName();
        fieldSpec.label = this.field.getLabel();
        fieldSpec.unit = this.field.getUnit();
        fieldSpec.key = this.field.isKey();
        fieldSpec.min = this.field.getMin();
        fieldSpec.max = this.field.getMax();
        fieldSpec.granularity = this.field.getGranularity();
        fieldSpec.timeZone = this.field.getTimeZone();
        Number[] numberArray = this.field.getOrder();
        if (numberArray != null) {
            int n = numberArray.length;
            fieldSpec.order = new Number[n];
            for (int i = 0; i < n; ++i) {
                fieldSpec.order[i] = numberArray[i];
            }
        }
        fieldSpec.categories = this.getCategories();
        fieldSpec.format = this.makeFormatSpec();
        return fieldSpec;
    }

    private FormatSpec makeFormatSpec() {
        boolean bl = false;
        FormatSpec formatSpec = new FormatSpec();
        String string = this.field.getPrefix();
        if (string != null) {
            formatSpec.prefix = string;
            bl = true;
        }
        if ((string = this.field.getSuffix()) != null) {
            formatSpec.suffix = string;
            bl = true;
        }
        if ((string = this.field.getNumericPattern()) != null) {
            formatSpec.numericPattern = string;
            bl = true;
        }
        if ((string = this.field.getDatePattern()) != null) {
            formatSpec.datePattern = string;
            bl = true;
        }
        if ((string = this.field.getScientificPattern()) != null) {
            formatSpec.scientificPattern = string;
            bl = true;
        }
        if ((string = this.field.getFitMethod()) != null) {
            formatSpec.fitMethod = string;
            bl = true;
        }
        string = this.field.getZeroFormatNumericPattern();
        String string2 = this.field.getZeroFormatScientificPattern();
        if (string != null || string2 != null) {
            formatSpec.zeroFormat = new ZeroFormatSpec();
            formatSpec.zeroFormat.numericPattern = string;
            formatSpec.zeroFormat.scientificPattern = string2;
            bl = true;
        }
        string = this.field.getNegativeFormatNumericPattern();
        string2 = this.field.getNegativeFormatScientificPattern();
        if (string != null || string2 != null) {
            formatSpec.negativeFormat = new NegativeFormatSpec();
            formatSpec.negativeFormat.numericPattern = string;
            formatSpec.negativeFormat.scientificPattern = string2;
            bl = true;
        }
        if ((string = this.field.getNoSpaceFormatPattern()) != null) {
            formatSpec.noSpaceFormat = new NoSpaceFormatSpec();
            formatSpec.noSpaceFormat.pattern = string;
            bl = true;
        }
        if ((string = this.field.getScientificString()) != null) {
            formatSpec.scientific = string;
            bl = true;
        } else {
            Number number = this.field.getScientificLower();
            Number number2 = this.field.getScientificUpper();
            if (number != null || number2 != null) {
                ScientificSpec scientificSpec = new ScientificSpec();
                scientificSpec.lower = number;
                scientificSpec.upper = number2;
                formatSpec.scientific = scientificSpec;
                bl = true;
            }
        }
        return bl ? formatSpec : null;
    }
}

