/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.dataProviderService.internal;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.dataProviderService.DataProviderListener;
import com.ibm.vis.engine.internal.asynchronous.AsynchAction;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/dataProviderLayer")
public class DataProviderListenerImpl
implements DataProviderListener {
    private boolean readyFlag = false;
    private String failedMessage = null;
    private AsynchAction action = null;
    private boolean allowCallback = false;
    public static final String NO_REASON_GIVEN = "No reason given";

    public DataProviderListenerImpl(AsynchAction asynchAction) {
        this.action = asynchAction;
    }

    @Override
    public void providerReady() {
        if (!this.readyFlag) {
            this.readyFlag = true;
            if (this.allowCallback && this.action != null) {
                this.action.run();
            }
        }
    }

    public boolean isReady() {
        this.allowCallback = true;
        return this.readyFlag;
    }

    @Override
    public void providerFailed(String string) {
        this.failedMessage = string != null ? string : NO_REASON_GIVEN;
        this.action.run();
    }

    public void checkFailure() {
        if (this.failedMessage != null) {
            throw new EngineException("A data provider has failed: " + this.failedMessage, ErrorCode.DATA_PROVIDER_FAILED, null);
        }
    }
}

