/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.dataProviderService.internal;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.dataProviderService.DataProvider;
import com.ibm.vis.engine.dataProviderService.DataProviderFactory;
import com.ibm.vis.engine.dataProviderService.internal.DataProviderConverterImpl;
import com.ibm.vis.engine.dataProviderService.internal.DataProviderListenerImpl;
import com.ibm.vis.engine.dataProviderService.internal.DataProviderPrepareWrapper;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.DataProviderConverter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.ThreadLauncher;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.spec.internal.DataProviderSpec;
import com.ibm.vis.spec.internal.DataSpec;
import java.util.concurrent.ConcurrentHashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/dataProviderLayer")
public class DataProviderServiceDelegate {
    private static DataProviderServiceDelegate INSTANCE = new DataProviderServiceDelegate();
    private final ConcurrentHashMap<String, DataProviderFactory> dataProviderFactories = new ConcurrentHashMap(16, 0.75f, 1);

    public static DataProviderServiceDelegate getInstance() {
        return INSTANCE;
    }

    private DataProviderServiceDelegate() {
    }

    public synchronized void registerFactory(DataProviderFactory dataProviderFactory) {
        String[] stringArray = dataProviderFactory.getProviderIDList();
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null) {
                    throw new EngineException("A DataProviderFactory returned a null ID", ErrorCode.DATA_PROVIDER_FAILED, null);
                }
                this.dataProviderFactories.put(string, dataProviderFactory);
            }
        } else {
            throw new EngineException("A DataProviderFactory returned a null list of IDs", ErrorCode.DATA_PROVIDER_FAILED, null);
        }
    }

    public synchronized void unregisterFactory(DataProviderFactory dataProviderFactory) {
        if (dataProviderFactory == null) {
            return;
        }
        String[] stringArray = dataProviderFactory.getProviderIDList();
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null) continue;
                this.dataProviderFactories.remove(string);
            }
        }
    }

    public synchronized DataProviderConverter getDataProvider(Data data, VisInterface visInterface, DataSpec dataSpec) {
        DataProviderSpec dataProviderSpec = dataSpec.provider;
        String string = dataProviderSpec.providerId;
        Object object = dataProviderSpec.args;
        DataProviderConverterImpl dataProviderConverterImpl = null;
        DataProviderFactory dataProviderFactory = this.dataProviderFactories.get(string);
        if (dataProviderFactory != null) {
            DataProviderListenerImpl dataProviderListenerImpl;
            DataProvider dataProvider;
            try {
                dataProvider = dataProviderFactory.getProvider(string, object);
            }
            catch (Exception exception) {
                throw new EngineException("The DataProviderFactory threw exception '" + exception.getMessage() + "' for provider id '" + string + "'", ErrorCode.DATA_PROVIDER_NOT_FOUND, null);
            }
            if (dataProvider == null) {
                throw new EngineException("The DataProviderFactory returned null for id '" + string + "'", ErrorCode.DATA_PROVIDER_NOT_FOUND, null);
            }
            try {
                dataProviderListenerImpl = (DataProviderListenerImpl)dataProvider.getListener();
                if (dataProviderListenerImpl == null) {
                    dataProviderListenerImpl = (DataProviderListenerImpl)dataSpec.getCachedObject();
                    dataProvider.registerListener(dataProviderListenerImpl);
                }
                dataProviderListenerImpl.checkFailure();
            }
            catch (Exception exception) {
                throw DataProviderServiceDelegate.wrapException(exception);
            }
            DataProviderPrepareWrapper dataProviderPrepareWrapper = new DataProviderPrepareWrapper(visInterface, dataProvider);
            ThreadLauncher threadLauncher = ThreadLauncher.getInstance("dataprovider");
            threadLauncher.execute(dataProviderPrepareWrapper);
            dataProviderListenerImpl.checkFailure();
            dataProviderConverterImpl = new DataProviderConverterImpl(data, dataSpec, dataProvider, dataProviderListenerImpl);
        } else {
            DataProviderListenerImpl dataProviderListenerImpl = (DataProviderListenerImpl)dataSpec.getCachedObject();
            dataProviderListenerImpl.providerFailed("Data provider of type " + string + " not found.");
        }
        return dataProviderConverterImpl;
    }

    static EngineException wrapException(Exception exception) {
        return new EngineException("A data provider threw exception: " + exception.getMessage(), ErrorCode.DATA_PROVIDER_FAILED, null);
    }
}

