/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.diagramService.internal;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.diagramService.Diagram;
import com.ibm.vis.engine.diagramService.DiagramFactory;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SpecException;
import java.util.concurrent.ConcurrentHashMap;

@OnDemandLoad(value="com/ibm/vis/layers/layoutsLayer")
public class DiagramServiceDelegate {
    private static final String NULL_DIAGRAM = "The DiagramFactory returned null for id '";
    private static final String FOR_PROVIDER = "' for provider id '";
    private static final String DIAGRAM_FACTORY_EXCEPTION = "The DiagramFactory threw exception '";
    private static final String END_QUOTE = "'";
    private static final String BAD_SPEC = "No registered DiagramFactory found for providerID '";
    private static final String NULL_ID_ERROR = "A DiagramFactory returned a null ID";
    private static final String NULL_LIST_ERROR = "A DiagramFactory returned a null list of IDs";
    private static DiagramServiceDelegate INSTANCE = new DiagramServiceDelegate();
    private final ConcurrentHashMap<String, DiagramFactory> diagramFactories = new ConcurrentHashMap(16, 0.75f, 1);

    private DiagramServiceDelegate() {
    }

    public static DiagramServiceDelegate getInstance() {
        return INSTANCE;
    }

    public synchronized void register(DiagramFactory diagramFactory) {
        if (diagramFactory == null) {
            return;
        }
        String[] stringArray = diagramFactory.getDiagramIDList();
        if (stringArray == null) {
            throw new EngineException(NULL_LIST_ERROR, ErrorCode.EXTENSION_POINT_EXCEPTION, null);
        }
        for (String string : stringArray) {
            if (string == null) {
                throw new EngineException(NULL_ID_ERROR, ErrorCode.EXTENSION_POINT_EXCEPTION, null);
            }
            this.diagramFactories.put(string, diagramFactory);
        }
    }

    public synchronized void unregister(DiagramFactory diagramFactory) {
        if (diagramFactory == null) {
            return;
        }
        String[] stringArray = diagramFactory.getDiagramIDList();
        if (stringArray == null) {
            throw new EngineException(NULL_LIST_ERROR, ErrorCode.EXTENSION_POINT_EXCEPTION, null);
        }
        boolean bl = false;
        for (String string : stringArray) {
            if (string == null) {
                bl = true;
            }
            this.diagramFactories.remove(string);
        }
        if (bl) {
            throw new EngineException(NULL_ID_ERROR, ErrorCode.EXTENSION_POINT_EXCEPTION, null);
        }
    }

    public synchronized Diagram getDiagram(String string) {
        DiagramFactory diagramFactory = this.diagramFactories.get(string);
        if (diagramFactory == null) {
            String string2 = BAD_SPEC + string + END_QUOTE;
            throw new SpecException(string2, ErrorCode.EXTENSION_NOT_FOUND, string);
        }
        try {
            Diagram diagram = diagramFactory.getDiagram(string);
            if (diagram == null) {
                String string3 = NULL_DIAGRAM + string + END_QUOTE;
                throw new EngineException(string3, ErrorCode.EXTENSION_POINT_EXCEPTION, null);
            }
            return diagram;
        }
        catch (Exception exception) {
            String string4 = DIAGRAM_FACTORY_EXCEPTION + exception.getMessage() + FOR_PROVIDER + string + END_QUOTE;
            throw new EngineException(string4, ErrorCode.EXTENSION_POINT_EXCEPTION, null);
        }
    }

    public synchronized boolean supports(String string) {
        return this.diagramFactories.containsKey(string);
    }
}

