/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.PointTransform;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Affine
extends PointTransform {
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public boolean translateOnly;
    private static final Affine IDENTITY = new Affine(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);

    public static Affine identity() {
        return IDENTITY;
    }

    public static Affine makeRotation(double d, double d2, double d3) {
        double d4 = MathUtil.r(Math.cos(d));
        double d5 = MathUtil.r(Math.sin(d));
        return new Affine(d4, -d5, d2 - d4 * d2 + d5 * d3, d5, d4, d3 - d5 * d2 - d4 * d3);
    }

    public static Affine makeTransform(double d, double d2) {
        return new Affine(1.0, 0.0, d, 0.0, 1.0, d2);
    }

    public static Affine makeIntTransform(double d, double d2) {
        return Affine.makeTransform(Math.round(d), Math.round(d2));
    }

    public Affine(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d == -0.0 ? 0.0 : d;
        this.m01 = d2 == -0.0 ? 0.0 : d2;
        this.m02 = d3 == -0.0 ? 0.0 : d3;
        this.m10 = d4 == -0.0 ? 0.0 : d4;
        this.m11 = d5 == -0.0 ? 0.0 : d5;
        this.m12 = d6 == -0.0 ? 0.0 : d6;
        this.translateOnly = d == 1.0 && d2 == 0.0 && d5 == 1.0 && d4 == 0.0;
    }

    public final Affine getInverse() {
        if (this.translateOnly) {
            return new Affine(1.0, 0.0, -this.m02, 0.0, 1.0, -this.m12);
        }
        double d = this.m00 * this.m11 - this.m01 * this.m10;
        return new Affine(this.m11 / d, -this.m01 / d, (this.m01 * this.m12 - this.m02 * this.m11) / d, -this.m10 / d, this.m00 / d, (-this.m00 * this.m12 + this.m10 * this.m02) / d);
    }

    public final Affine multiply(Affine affine) {
        if (affine == null) {
            return this;
        }
        return new Affine(this.m00 * affine.m00 + this.m01 * affine.m10, this.m00 * affine.m01 + this.m01 * affine.m11, this.m00 * affine.m02 + this.m01 * affine.m12 + this.m02, this.m10 * affine.m00 + this.m11 * affine.m10, this.m10 * affine.m01 + this.m11 * affine.m11, this.m10 * affine.m02 + this.m11 * affine.m12 + this.m12);
    }

    public final Affine translate(double d, double d2) {
        return new Affine(this.m00, this.m01, this.m02 + d, this.m10, this.m11, this.m12 + d2);
    }

    public final Affine intTranslate(double d, double d2) {
        return new Affine(this.m00, this.m01, Math.round(this.m02 + d), this.m10, this.m11, Math.round(this.m12 + d2));
    }

    public final Affine scale(double d) {
        return new Affine(d * this.m00, d * this.m01, this.m02, d * this.m10, d * this.m11, this.m12);
    }

    public final boolean isIdentity() {
        if (this == IDENTITY) {
            return true;
        }
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0;
    }

    @Override
    public Point transform(double d, double d2) {
        if (this.translateOnly) {
            return new Point(d + this.m02, d2 + this.m12);
        }
        return new Point(d * this.m00 + d2 * this.m01 + this.m02, d * this.m10 + d2 * this.m11 + this.m12);
    }

    public void transformInto(double[] dArray, double d, double d2) {
        if (this.translateOnly) {
            dArray[0] = d + this.m02;
            dArray[1] = d2 + this.m12;
        } else {
            dArray[0] = d * this.m00 + d2 * this.m01 + this.m02;
            dArray[1] = d * this.m10 + d2 * this.m11 + this.m12;
        }
    }

    public Point transformPoint(Point point) {
        return this.transform(point.getX(), point.getY());
    }

    public Rect transformBoundingBox(Rect rect) {
        double d = rect.getX();
        double d2 = rect.getY();
        double d3 = rect.getX2();
        double d4 = rect.getY2();
        double[] dArray = new double[2];
        this.transformInto(dArray, d, d2);
        double d5 = dArray[0];
        double d6 = dArray[0];
        double d7 = dArray[1];
        double d8 = dArray[1];
        this.transformInto(dArray, d, d4);
        if (dArray[0] < d5) {
            d5 = dArray[0];
        } else if (dArray[0] > d6) {
            d6 = dArray[0];
        }
        if (dArray[1] < d7) {
            d7 = dArray[1];
        } else if (dArray[1] > d8) {
            d8 = dArray[1];
        }
        this.transformInto(dArray, d3, d2);
        if (dArray[0] < d5) {
            d5 = dArray[0];
        } else if (dArray[0] > d6) {
            d6 = dArray[0];
        }
        if (dArray[1] < d7) {
            d7 = dArray[1];
        } else if (dArray[1] > d8) {
            d8 = dArray[1];
        }
        this.transformInto(dArray, d3, d4);
        if (dArray[0] < d5) {
            d5 = dArray[0];
        } else if (dArray[0] > d6) {
            d6 = dArray[0];
        }
        if (dArray[1] < d7) {
            d7 = dArray[1];
        } else if (dArray[1] > d8) {
            d8 = dArray[1];
        }
        return new Rect(d5, d7, d6 - d5, d8 - d7);
    }

    @Override
    public boolean preservesLines() {
        return false;
    }

    public boolean similar(Affine affine) {
        if (Math.abs(this.m02 - affine.m02) > 1.0E-6) {
            return false;
        }
        if (Math.abs(this.m12 - affine.m12) > 1.0E-6) {
            return false;
        }
        if (Math.abs(this.m00 - affine.m00) > 1.0E-6) {
            return false;
        }
        if (Math.abs(this.m11 - affine.m11) > 1.0E-6) {
            return false;
        }
        if (Math.abs(this.m01 - affine.m01) > 1.0E-6) {
            return false;
        }
        return !(Math.abs(this.m10 - affine.m10) > 1.0E-6);
    }
}

