/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.LogLevel;
import com.ibm.vis.monitor.internal.LoggerImpl;
import com.ibm.vis.spec.internal.BoundsSpec;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Bounds {
    public static final String BOUNDS_HEIGHT = "height";
    public static final String BOUNDS_WIDTH = "width";
    public static final String BOUNDS_TOP = "top";
    public static final String BOUNDS_BOTTOM = "bottom";
    public static final String BOUNDS_LEFT = "left";
    public static final String BOUNDS_RIGHT = "right";
    private final LoggerImpl logger;
    private final BoundsSpec spec;

    public Bounds(BoundsSpec boundsSpec, LoggerImpl loggerImpl) {
        this.logger = loggerImpl;
        this.spec = boundsSpec;
    }

    public Rect getRect(Dim dim) {
        if (this.validValue(BOUNDS_LEFT, dim.getWidth(), true) && this.validValue(BOUNDS_RIGHT, dim.getWidth(), true) && this.validValue(BOUNDS_WIDTH, dim.getWidth(), false) && this.validValue(BOUNDS_TOP, dim.getHeight(), true) && this.validValue(BOUNDS_BOTTOM, dim.getHeight(), true) && this.validValue(BOUNDS_HEIGHT, dim.getHeight(), false)) {
            Double d;
            Double d2 = this.getBoundsLocation(BOUNDS_LEFT, dim.getWidth(), true);
            Double d3 = this.getBoundsLocation(BOUNDS_RIGHT, dim.getWidth(), true);
            Double d4 = this.getBoundsLocation(BOUNDS_WIDTH, dim.getWidth(), false);
            if (d2 == null && this.getValue(BOUNDS_LEFT) == null) {
                if (d4 == null && this.getValue(BOUNDS_WIDTH) == null) {
                    d2 = 0.0;
                    if (d3 == null) {
                        d3 = dim.getWidth();
                    }
                } else if (d3 == null && this.getValue(BOUNDS_RIGHT) == null) {
                    d2 = (dim.getWidth() - d4) / 2.0;
                    d3 = d2 + d4;
                } else {
                    d2 = d3 - d4;
                }
            } else if (d3 == null && this.getValue(BOUNDS_RIGHT) == null) {
                d3 = d4 == null && this.getValue(BOUNDS_WIDTH) == null ? Double.valueOf(dim.getWidth()) : Double.valueOf(d2 + d4);
            }
            if (d2 != null && d3 != null && d2 > d3) {
                this.logOutOfOrder(BOUNDS_LEFT, BOUNDS_RIGHT);
                d = d2;
                d2 = d3;
                d3 = d;
            }
            d = this.getBoundsLocation(BOUNDS_TOP, dim.getHeight(), true);
            Double d5 = this.getBoundsLocation(BOUNDS_BOTTOM, dim.getHeight(), true);
            Double d6 = this.getBoundsLocation(BOUNDS_HEIGHT, dim.getHeight(), false);
            if (d == null && this.getValue(BOUNDS_TOP) == null) {
                if (d6 == null && this.getValue(BOUNDS_HEIGHT) == null) {
                    d = 0.0;
                    if (d5 == null) {
                        d5 = dim.getHeight();
                    }
                } else if (d5 == null && this.getValue(BOUNDS_BOTTOM) == null) {
                    d = (dim.getHeight() - d6) / 2.0;
                    d5 = d + d6;
                } else {
                    d = d5 - d6;
                }
            } else if (d5 == null && this.getValue(BOUNDS_BOTTOM) == null) {
                d5 = d6 == null ? Double.valueOf(dim.getHeight()) : Double.valueOf(d + d6);
            }
            if (d != null && d5 != null && d > d5) {
                this.logOutOfOrder(BOUNDS_TOP, BOUNDS_BOTTOM);
                Double d7 = d;
                d = d5;
                d5 = d7;
            }
            return new Rect(d2, d, d3 - d2, d5 - d);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Double getBoundsLocation(String string, double d, boolean bl) {
        Double d2;
        Object object = this.getValue(string);
        if (object == null || (d2 = UnitConverter.convertLength(object, d, d)) == null) return null;
        if (d2 == 0.0) {
            if (!UnitConverter.isNegativeLength(object)) return d2;
            if (bl) {
                return d;
            }
        } else {
            if (d2 > 0.0) {
                return d2;
            }
            if (bl) {
                return d + d2;
            }
        }
        this.logBadValue(string, object);
        return null;
    }

    private boolean validValue(String string, double d, boolean bl) {
        return this.getValue(string) == null || this.getBoundsLocation(string, d, bl) != null;
    }

    public Object getValue(String string) {
        if (this.spec == null) {
            return null;
        }
        if (string.equals(BOUNDS_WIDTH)) {
            return this.spec.width;
        }
        if (string.equals(BOUNDS_TOP)) {
            return this.spec.top;
        }
        if (string.equals(BOUNDS_LEFT)) {
            return this.spec.left;
        }
        if (string.equals(BOUNDS_HEIGHT)) {
            return this.spec.height;
        }
        if (string.equals(BOUNDS_RIGHT)) {
            return this.spec.right;
        }
        if (string.equals(BOUNDS_BOTTOM)) {
            return this.spec.bottom;
        }
        return null;
    }

    private void logBadValue(String string, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("key", string);
        hashMap.put("value", object);
        this.logger.logParam(LogLevel.Warning, LogComponent.CommonGrammar, "badBoundsValue", hashMap);
    }

    private void logOutOfOrder(String string, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("param1", string);
        hashMap.put("param2", string2);
        this.logger.logParam(LogLevel.Warning, LogComponent.CommonGrammar, "reversedBoundsValues", hashMap);
    }

    public boolean isDefinedPositionalBounds() {
        Double d = this.getBoundsLocation(BOUNDS_LEFT, 0.0, true);
        Double d2 = this.getBoundsLocation(BOUNDS_RIGHT, 0.0, true);
        Double d3 = this.getBoundsLocation(BOUNDS_TOP, 0.0, true);
        Double d4 = this.getBoundsLocation(BOUNDS_BOTTOM, 0.0, true);
        return d != null || d2 != null || d3 != null || d4 != null;
    }

    public Rect getRectWithinParent(Rect rect) {
        double d;
        double d2;
        double d3;
        BoundsSpec boundsSpec = this.spec;
        if (boundsSpec == null || rect == null) {
            return rect;
        }
        Object object = boundsSpec.left;
        Object object2 = boundsSpec.top;
        Object object3 = boundsSpec.right;
        Object object4 = boundsSpec.bottom;
        Object object5 = boundsSpec.width;
        Object object6 = boundsSpec.height;
        double d4 = rect.getWidth();
        if (object5 != null) {
            d4 = UnitConverter.convertLength(object5, rect.getWidth(), rect.getWidth());
        }
        double d5 = rect.getHeight();
        if (object6 != null) {
            d5 = UnitConverter.convertLength(object6, rect.getHeight(), rect.getHeight());
        }
        double d6 = rect.getX();
        if (object != null) {
            d3 = UnitConverter.convertLength(object, rect.getWidth(), rect.getWidth());
            d6 += d3;
            if (object5 == null) {
                d4 -= d3;
            }
        }
        d3 = rect.getY();
        if (object2 != null) {
            d2 = UnitConverter.convertLength(object2, rect.getHeight(), rect.getHeight());
            d3 += d2;
            if (object6 == null) {
                d5 -= d2;
            }
        }
        d2 = rect.getX() + rect.getWidth();
        if (object3 != null) {
            d = UnitConverter.convertLength(object3, rect.getWidth(), rect.getWidth());
            d2 += d;
            if (object5 == null) {
                d4 = d2 - d6;
            } else if (object == null) {
                d6 = d2 - d4;
            }
        }
        d = rect.getY() + rect.getHeight();
        if (object4 != null) {
            double d7 = UnitConverter.convertLength(object4, rect.getHeight(), rect.getHeight());
            d += d7;
            if (object6 == null) {
                d5 = d - d3;
            } else if (object2 == null) {
                d3 = d - d5;
            }
        }
        if (boundsSpec.center != null && boundsSpec.center.booleanValue()) {
            if (object == null && object3 == null) {
                d6 = rect.getX() + (rect.getWidth() - d4) / 2.0;
            }
            if (object2 == null && object4 == null) {
                d3 = rect.getY() + (rect.getHeight() - d5) / 2.0;
            }
        }
        return new Rect(d6, d3, d4, d5);
    }
}

