/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.scenetree.provisional.ColorProperty;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class ColorNew
implements ColorProperty {
    public static final String RED = "r";
    public static final String GREEN = "g";
    public static final String BLUE = "b";
    public static final String ALPHA = "a";
    public static final String VALUE = "v";
    public static final String LIGHTNESS = "l";
    public static final String SATURATION = "s";
    public static final String HUE = "h";
    public static final String D_ALPHA = "dAlpha";
    public static final String D_LIGHTNESS = "dLightness";
    public static final String D_SATURATION = "dSaturation";
    public static final String D_VALUE = "dValue";
    private double alpha;
    private double red;
    private double green;
    private double blue;
    private double hue;
    private double saturation;
    private double lightness;
    private double value;
    private double dAlpha;
    private double dSaturation;
    private double dLightness;
    private double dValue;
    private boolean needsHSLV;
    private String colorString;
    private double computedAlpha;

    public ColorNew(double d, double d2, double d3, double d4) {
        this.setRed(d);
        this.setGreen(d2);
        this.setBlue(d3);
        this.setAlpha(d4);
        this.hue = Double.NaN;
        this.saturation = Double.NaN;
        this.lightness = Double.NaN;
        this.value = Double.NaN;
        this.dAlpha = Double.NaN;
        this.dSaturation = Double.NaN;
        this.dLightness = Double.NaN;
        this.dValue = Double.NaN;
        this.colorString = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof ColorNew) {
            ColorNew colorNew = (ColorNew)object;
            return ColorUtil.isEqual(this.alpha, colorNew.alpha) && ColorUtil.isEqual(this.alpha, colorNew.alpha) && ColorUtil.isEqual(this.blue, colorNew.blue) && ColorUtil.isEqual(this.green, colorNew.green) && ColorUtil.isEqual(this.red, colorNew.red) && ColorUtil.isEqual(this.hue, colorNew.hue) && ColorUtil.isEqual(this.saturation, colorNew.saturation) && ColorUtil.isEqual(this.lightness, colorNew.lightness) && ColorUtil.isEqual(this.value, colorNew.value) && ColorUtil.isEqual(this.dAlpha, colorNew.dAlpha) && ColorUtil.isEqual(this.dSaturation, colorNew.dSaturation) && ColorUtil.isEqual(this.dLightness, colorNew.dLightness) && ColorUtil.isEqual(this.dValue, colorNew.dValue);
        }
        return false;
    }

    String getColorString() {
        return this.colorString;
    }

    void setColorString(String string) {
        this.colorString = string;
    }

    public boolean isEmpty() {
        if (!Double.isNaN(this.red)) {
            return false;
        }
        if (!Double.isNaN(this.blue)) {
            return false;
        }
        if (!Double.isNaN(this.green)) {
            return false;
        }
        if (!Double.isNaN(this.alpha)) {
            return false;
        }
        if (!Double.isNaN(this.computedAlpha)) {
            return false;
        }
        if (!Double.isNaN(this.dAlpha)) {
            return false;
        }
        if (!Double.isNaN(this.dLightness)) {
            return false;
        }
        if (!Double.isNaN(this.dSaturation)) {
            return false;
        }
        if (!Double.isNaN(this.dValue)) {
            return false;
        }
        if (!Double.isNaN(this.hue)) {
            return false;
        }
        if (!Double.isNaN(this.lightness)) {
            return false;
        }
        if (!Double.isNaN(this.saturation)) {
            return false;
        }
        return Double.isNaN(this.value);
    }

    @Override
    public synchronized double[] getRGBA() {
        double[] dArray = this.buildRGBA();
        if (this.needsHSLV) {
            dArray = this.prepHSLV(dArray);
        }
        return dArray;
    }

    private double[] prepHSLV(double[] dArray) {
        double[] dArray2 = dArray;
        double[] dArray3 = this.convertRGBToHSV(dArray2);
        dArray3 = this.overrideHSVWithFieldValues(dArray3);
        if ((dArray3 = this.applyModifiersToHSV(dArray3))[0] != dArray3[0]) {
            dArray3[1] = 0.0;
            dArray3[1] = 0.0;
        }
        if (!Double.isNaN(this.lightness) || !Double.isNaN(this.dLightness)) {
            double[] dArray4 = this.convertHSVToHSL(dArray3);
            dArray4[2] = ColorNew.overrideValue(dArray4[2], this.lightness);
            dArray4 = this.applyLightnessModifier(dArray4);
            dArray2 = this.convertHSLToRGBA(dArray4);
        } else {
            dArray2 = this.convertHSVToRGB(dArray3);
        }
        return dArray2;
    }

    void setAlpha(double d) {
        double d2 = ColorNew.clampToZeroOne(d);
        if (this.alpha == d2) {
            return;
        }
        this.computedAlpha = this.alpha = d2;
    }

    void setRed(double d) {
        double d2 = ColorNew.clampRGBToLegalRange(d);
        if (this.red == d2) {
            return;
        }
        this.red = d2;
    }

    void setGreen(double d) {
        double d2 = ColorNew.clampRGBToLegalRange(d);
        if (this.green == d2) {
            return;
        }
        this.green = d2;
    }

    void setBlue(double d) {
        double d2 = ColorNew.clampRGBToLegalRange(d);
        if (this.blue == d2) {
            return;
        }
        this.blue = d2;
    }

    void setHue(double d) {
        if (this.hue == d) {
            return;
        }
        this.hue = d;
        this.needsHSLV = true;
    }

    void setSaturation(double d) {
        if (this.saturation == d) {
            return;
        }
        this.saturation = d;
        this.needsHSLV = true;
    }

    void setLightness(double d) {
        if (this.lightness == d) {
            return;
        }
        this.lightness = d;
        this.needsHSLV = true;
    }

    void setValue(double d) {
        if (this.value == d) {
            return;
        }
        this.value = d;
        this.needsHSLV = true;
    }

    void setdAlpha(double d) {
        double d2 = ColorNew.clampModifierToLegalRange(d);
        if (this.dAlpha == d2) {
            return;
        }
        this.dAlpha = d2;
    }

    void setdSaturation(double d) {
        double d2 = ColorNew.clampModifierToLegalRange(d);
        if (this.dSaturation == d2) {
            return;
        }
        this.dSaturation = d2;
        this.needsHSLV = true;
    }

    void setdLightness(double d) {
        double d2 = ColorNew.clampModifierToLegalRange(d);
        if (this.dLightness == d2) {
            return;
        }
        this.dLightness = d2;
        this.needsHSLV = true;
    }

    void setdValue(double d) {
        double d2 = ColorNew.clampModifierToLegalRange(d);
        if (this.dValue == d2) {
            return;
        }
        this.dValue = d2;
        this.needsHSLV = true;
    }

    private double getAlpha() {
        return this.alpha;
    }

    private double getRed() {
        return this.red;
    }

    private double getGreen() {
        return this.green;
    }

    private double getBlue() {
        return this.blue;
    }

    private double getHue() {
        return this.hue;
    }

    private double getSaturation() {
        return this.saturation;
    }

    private double getValue() {
        return this.value;
    }

    private double getdAlpha() {
        return this.dAlpha;
    }

    private double getdSaturation() {
        return this.dSaturation;
    }

    private double getdValue() {
        return this.dValue;
    }

    private static double clampToZeroOne(double d) {
        if (d >= 0.0 && d <= 1.0) {
            return d;
        }
        if (d < 0.0) {
            return 0.0;
        }
        if (d > 1.0) {
            return 1.0;
        }
        return Double.NaN;
    }

    private static double clampRGBToLegalRange(double d) {
        if (d >= 0.0 && d <= 255.0) {
            return d;
        }
        if (Double.isNaN(d)) {
            return d;
        }
        throw new IllegalArgumentException("Color parameter outside of expected range: 0<=RGB<=255");
    }

    private static double clampModifierToLegalRange(double d) {
        if (d >= -1.0 && d <= 1.0) {
            return d;
        }
        if (d < -1.0) {
            return -1.0;
        }
        if (Double.isNaN(d)) {
            return d;
        }
        return 1.0;
    }

    private double buildAlpha() {
        double d = this.computedAlpha;
        if (!Double.isNaN(this.dAlpha)) {
            d = ColorNew.overrideValue(1.0, this.alpha) + ColorNew.overrideValue(0.0, this.dAlpha);
            this.computedAlpha = d = ColorNew.clampToZeroOne(d);
        }
        if (d != d) {
            d = 1.0;
        }
        return d;
    }

    private double[] buildRGBA() {
        double d = this.red != this.red ? 0.0 : this.red;
        double d2 = this.green != this.green ? 0.0 : this.green;
        double d3 = this.blue != this.blue ? 0.0 : this.blue;
        return new double[]{d, d2, d3, this.buildAlpha()};
    }

    double[] convertRGBToHSV(double[] dArray) {
        double d;
        double d2;
        double d3;
        double[] dArray2 = new double[3];
        double d4 = dArray[0];
        double d5 = dArray[1];
        double d6 = dArray[2];
        double d7 = d3 = d4 > d5 ? d4 : d5;
        if (d6 > d3) {
            d3 = d6;
        }
        double d8 = d2 = d4 < d5 ? d4 : d5;
        if (d6 < d2) {
            d2 = d6;
        }
        double d9 = d3 / 255.0;
        double d10 = d3 != 0.0 ? (d3 - d2) / d3 : 0.0;
        if (d10 == 0.0) {
            d = Double.NaN;
        } else {
            double d11 = (d3 - d4) / (d3 - d2);
            double d12 = (d3 - d5) / (d3 - d2);
            double d13 = (d3 - d6) / (d3 - d2);
            d = d4 == d3 ? d13 - d12 : (d5 == d3 ? 2.0 + d11 - d13 : 4.0 + d12 - d11);
            if ((d /= 6.0) < 0.0) {
                d += 1.0;
            }
        }
        dArray2[0] = d;
        dArray2[1] = d10;
        dArray2[2] = d9;
        return new double[]{dArray2[0], dArray2[1], dArray2[2]};
    }

    double[] convertHSVToRGB(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (d2 == 0.0) {
            d5 = d6 = d3 * 255.0 + 0.5;
            d4 = d6;
        } else {
            double d7 = (d - Math.floor(d)) * 6.0;
            double d8 = d7 - Math.floor(d7);
            double d9 = d3 * (1.0 - d2);
            double d10 = d3 * (1.0 - d2 * d8);
            double d11 = d3 * (1.0 - d2 * (1.0 - d8));
            if (Math.floor(d7) == 0.0) {
                d4 = d3 * 255.0 + 0.5;
                d5 = d11 * 255.0 + 0.5;
                d6 = d9 * 255.0 + 0.5;
            } else if (Math.floor(d7) == 1.0) {
                d4 = d10 * 255.0 + 0.5;
                d5 = d3 * 255.0 + 0.5;
                d6 = d9 * 255.0 + 0.5;
            } else if (Math.floor(d7) == 2.0) {
                d4 = d9 * 255.0 + 0.5;
                d5 = d3 * 255.0 + 0.5;
                d6 = d11 * 255.0 + 0.5;
            } else if (Math.floor(d7) == 3.0) {
                d4 = d9 * 255.0 + 0.5;
                d5 = d10 * 255.0 + 0.5;
                d6 = d3 * 255.0 + 0.5;
            } else if (Math.floor(d7) == 4.0) {
                d4 = d11 * 255.0 + 0.5;
                d5 = d9 * 255.0 + 0.5;
                d6 = d3 * 255.0 + 0.5;
            } else if (Math.floor(d7) == 5.0) {
                d4 = d3 * 255.0 + 0.5;
                d5 = d9 * 255.0 + 0.5;
                d6 = d10 * 255.0 + 0.5;
            }
        }
        int n = (int)Math.floor(d4);
        int n2 = (int)Math.floor(d5);
        int n3 = (int)Math.floor(d6);
        int n4 = 0xFF000000 | n << 16 | n2 << 8 | n3 << 0;
        int n5 = n4 >> 16 & 0xFF;
        int n6 = n4 >> 8 & 0xFF;
        int n7 = n4 >> 0 & 0xFF;
        return new double[]{n5, n6, n7, this.buildAlpha()};
    }

    double[] convertHSLToRGBA(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = d3 <= 0.5 ? d3 * (d2 + 1.0) : d3 + d2 - d3 * d2;
        double d5 = d3 * 2.0 - d4;
        double d6 = Math.round(ColorNew.hue2rgb(d5, d4, d + 0.3333333333333333) * 255.0);
        double d7 = Math.round(ColorNew.hue2rgb(d5, d4, d) * 255.0);
        double d8 = Math.round(ColorNew.hue2rgb(d5, d4, d - 0.3333333333333333) * 255.0);
        return new double[]{d6, d7, d8, this.buildAlpha()};
    }

    double[] convertHSVToHSL(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = d;
        double d5 = 0.0;
        double d6 = 0.0;
        if (d3 != 0.0) {
            d5 = (2.0 - d2) * d3;
            d6 = d2 * d3;
            if (d6 != 0.0) {
                d6 = d5 <= 1.0 ? (d6 /= d5) : (d6 /= 2.0 - d5);
            }
            d5 /= 2.0;
        } else {
            d6 = dArray[1];
        }
        return new double[]{d4, d6, d5};
    }

    private double[] overrideHSVWithFieldValues(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        dArray2[0] = ColorNew.overrideValue(dArray[0], this.getHue());
        dArray2[1] = ColorNew.overrideValue(dArray[1], this.getSaturation());
        dArray2[2] = ColorNew.overrideValue(dArray[2], this.getValue());
        return dArray2;
    }

    private static double overrideValue(double d, double d2) {
        if (!Double.isNaN(d2)) {
            return d2;
        }
        return d;
    }

    private double[] applyLightnessModifier(double[] dArray) {
        double d = ColorNew.overrideValue(0.0, this.dLightness);
        double d2 = ColorNew.clampToZeroOne(dArray[2] + d);
        return new double[]{dArray[0], dArray[1], d2};
    }

    private double[] applyModifiersToHSV(double[] dArray) {
        double d = ColorNew.overrideValue(0.0, this.getdSaturation());
        double d2 = ColorNew.overrideValue(0.0, this.getdValue());
        double d3 = ColorNew.clampToZeroOne(dArray[1] + d);
        double d4 = ColorNew.clampToZeroOne(dArray[2] + d2);
        return new double[]{dArray[0], d3, d4};
    }

    private static double hue2rgb(double d, double d2, double d3) {
        double d4 = d3;
        if (d4 < 0.0) {
            d4 += 1.0;
        }
        if (d4 > 1.0) {
            d4 -= 1.0;
        }
        if (d4 * 6.0 < 1.0) {
            return d + (d2 - d) * d4 * 6.0;
        }
        if (d4 * 2.0 < 1.0) {
            return d2;
        }
        if (d4 * 3.0 < 2.0) {
            return d + (d2 - d) * (0.6666666666666666 - d4) * 6.0;
        }
        return d;
    }

    ColorNew cloneColor() {
        ColorNew colorNew = new ColorNew(this.red, this.green, this.blue, this.alpha);
        colorNew.hue = this.hue;
        colorNew.saturation = this.saturation;
        colorNew.lightness = this.lightness;
        colorNew.value = this.value;
        colorNew.dAlpha = this.dAlpha;
        colorNew.dSaturation = this.dSaturation;
        colorNew.dLightness = this.dLightness;
        colorNew.dValue = this.dValue;
        colorNew.needsHSLV = this.needsHSLV;
        return colorNew;
    }

    public ColorNew combineWithColor(ColorNew colorNew) {
        ColorNew colorNew2 = this.cloneColor();
        if (colorNew != null) {
            double d = colorNew.getAlpha();
            double d2 = colorNew.getRed();
            double d3 = colorNew.getGreen();
            double d4 = colorNew.getBlue();
            double d5 = colorNew.getHue();
            double d6 = colorNew.getSaturation();
            double d7 = colorNew.lightness;
            double d8 = colorNew.getValue();
            double d9 = colorNew.getdAlpha();
            double d10 = colorNew.getdSaturation();
            double d11 = colorNew.dLightness;
            double d12 = colorNew.getdValue();
            if (d == d) {
                colorNew2.setAlpha(d);
            }
            if (d2 == d2) {
                colorNew2.setRed(d2);
            }
            if (d3 == d3) {
                colorNew2.setGreen(d3);
            }
            if (d4 == d4) {
                colorNew2.setBlue(d4);
            }
            if (d5 == d5) {
                colorNew2.setHue(d5);
            }
            if (d6 == d6) {
                colorNew2.setSaturation(d6);
            }
            if (d7 == d7) {
                colorNew2.setLightness(d7);
            }
            if (d8 == d8) {
                colorNew2.setValue(d8);
            }
            if (d9 == d9) {
                colorNew2.setdAlpha(d9);
            }
            if (d10 == d10) {
                colorNew2.setdSaturation(d10);
            }
            if (d11 == d11) {
                colorNew2.setdLightness(d11);
            }
            if (d12 == d12) {
                colorNew2.setdValue(d12);
            }
        }
        return colorNew2;
    }

    public ColorNew interpolateWithColor(ColorNew colorNew, double d) {
        double d2 = ColorNew.getInterpolatedComponent(this.getRed(), colorNew.getRed(), d, true);
        double d3 = ColorNew.getInterpolatedComponent(this.getGreen(), colorNew.getGreen(), d, true);
        double d4 = ColorNew.getInterpolatedComponent(this.getBlue(), colorNew.getBlue(), d, true);
        double d5 = ColorNew.getInterpolatedComponent(this.getHue(), colorNew.getHue(), d, false);
        double d6 = ColorNew.getInterpolatedComponent(this.getSaturation(), colorNew.getSaturation(), d, false);
        double d7 = ColorNew.getInterpolatedComponent(this.lightness, colorNew.lightness, d, false);
        double d8 = ColorNew.getInterpolatedComponent(this.getValue(), colorNew.getValue(), d, false);
        double d9 = ColorNew.getInterpolatedComponent(this.getdAlpha(), colorNew.getdAlpha(), d, false);
        double d10 = ColorNew.getInterpolatedComponent(this.dLightness, colorNew.dLightness, d, false);
        double d11 = ColorNew.getInterpolatedComponent(this.getdSaturation(), colorNew.getdSaturation(), d, false);
        double d12 = ColorNew.getInterpolatedComponent(this.getdValue(), colorNew.getdValue(), d, false);
        double d13 = this.getAlpha();
        double d14 = colorNew.getAlpha();
        double d15 = Double.NaN;
        if (!Double.isNaN(d13) || !Double.isNaN(d14)) {
            if (Double.isNaN(d13)) {
                d13 = 1.0;
            }
            if (Double.isNaN(d14)) {
                d14 = 1.0;
            }
            d15 = ColorNew.getInterpolatedComponent(d13, d14, d, false);
        }
        d2 = ColorUtil.normalize(d2);
        d3 = ColorUtil.normalize(d3);
        d4 = ColorUtil.normalize(d4);
        d15 = ColorUtil.normalize(d15);
        ColorNew colorNew2 = new ColorNew(d2, d3, d4, d15);
        colorNew2.setdAlpha(d9);
        colorNew2.setdLightness(d10);
        colorNew2.setdSaturation(d11);
        colorNew2.setdValue(d12);
        colorNew2.setHue(d5);
        colorNew2.setLightness(d7);
        colorNew2.setSaturation(d6);
        colorNew2.setValue(d8);
        return colorNew2;
    }

    private static double getInterpolatedComponent(double d, double d2, double d3, boolean bl) {
        double d4 = 0.0;
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            d4 = ColorNew.interpolate(d, d2, d3);
            d4 = bl ? (double)Math.round(d4) : (double)Math.round(d4 * 100.0) / 100.0;
        } else {
            d4 = Double.isNaN(d) ? d2 : d;
        }
        return d4;
    }

    private static double interpolate(double d, double d2, double d3) {
        return d * (1.0 - d3) + d2 * d3;
    }

    public ColorNew fadeAlpha(double d) {
        double[] dArray = this.getRGBA();
        return new ColorNew(dArray[0], dArray[1], dArray[2], dArray[3] * d);
    }
}

