/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.IntegerUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.spec.internal.ColorSpec;
import java.util.concurrent.ConcurrentHashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ColorUtil {
    private static ConcurrentHashMap<String, Integer> CSS_COLORS;
    private static final String[] DEFAULT_COLOR_CODES;
    private static ColorNew[] DEFAULT_COLORS;
    public static final ColorNew TRANSPARENT;
    public static final String DEFAULT_FILL_COLOR_NAME = "#aaa";
    private static final ColorNew DEFAULT_FILL_COLOR;
    public static final String DEFAULT_STROKE_FILL_COLOR_NAME = "#000";
    private static final ColorNew DEFAULT_STROKE_FILL_COLOR;
    private static final ColorNew DEFAULT_COLOR;
    private static final ColorNew DEFAULT_SHADOW_COLOR;
    private static final ColorNew DEFAULT_GLOW_COLOR;
    private static boolean cssColorsNeedsInit;

    public static boolean isEqual(double d, double d2) {
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            return true;
        }
        return d == d2;
    }

    public static ColorNew interpolateColor(ColorNew colorNew, ColorNew colorNew2, double d) {
        if (colorNew == null && colorNew2 == null) {
            return null;
        }
        if (colorNew == null) {
            double[] dArray = colorNew2.getRGBA();
            return new ColorNew(dArray[0], dArray[1], dArray[2], ColorUtil.normalize(ColorUtil.interpolateDouble(dArray[3], 0.0, d)));
        }
        if (colorNew2 == null) {
            double[] dArray = colorNew.getRGBA();
            return new ColorNew(dArray[0], dArray[1], dArray[2], ColorUtil.normalize(ColorUtil.interpolateDouble(dArray[3], 0.0, d)));
        }
        double[] dArray = colorNew.getRGBA();
        double[] dArray2 = colorNew2.getRGBA();
        if (dArray[3] <= 0.0 && dArray2[3] <= 0.0) {
            return colorNew;
        }
        double d2 = ColorUtil.normalize(ColorUtil.interpolateDouble(dArray[0], dArray2[0], d));
        double d3 = ColorUtil.normalize(ColorUtil.interpolateDouble(dArray[1], dArray2[1], d));
        double d4 = ColorUtil.normalize(ColorUtil.interpolateDouble(dArray[2], dArray2[2], d));
        double d5 = ColorUtil.normalize(ColorUtil.interpolateDouble(dArray[3], dArray2[3], d));
        return new ColorNew(d2, d3, d4, d5);
    }

    public static double normalize(double d) {
        double d2 = Math.min(d, 255.0);
        d2 = Math.max(d2, 0.0);
        return d2;
    }

    public static final double interpolateDouble(double d, double d2, double d3) {
        return d + d3 * (d2 - d);
    }

    public static ColorNew createColorFromColorSpec(ColorSpec colorSpec) {
        if (colorSpec != null) {
            Number number;
            ColorNew colorNew = (ColorNew)colorSpec.getCachedObject();
            if (colorNew != null) {
                return colorNew;
            }
            colorNew = new ColorNew(ColorUtil.checkForNull(colorSpec.r), ColorUtil.checkForNull(colorSpec.g), ColorUtil.checkForNull(colorSpec.b), ColorUtil.checkForNull(colorSpec.a));
            if (colorSpec.h != null) {
                number = colorSpec.h;
                colorNew.setHue(number.doubleValue());
            }
            if (colorSpec.s != null) {
                number = colorSpec.s;
                colorNew.setSaturation(number.doubleValue());
            }
            if (colorSpec.l != null) {
                number = colorSpec.l;
                colorNew.setLightness(number.doubleValue());
            }
            if (colorSpec.v != null) {
                number = colorSpec.v;
                colorNew.setValue(number.doubleValue());
            }
            if (colorSpec.dAlpha != null) {
                number = colorSpec.dAlpha;
                colorNew.setdAlpha(number.doubleValue());
            }
            if (colorSpec.dSaturation != null) {
                number = colorSpec.dSaturation;
                colorNew.setdSaturation(number.doubleValue());
            }
            if (colorSpec.dValue != null) {
                number = colorSpec.dValue;
                colorNew.setdValue(number.doubleValue());
            }
            if (colorSpec.dLightness != null) {
                number = colorSpec.dLightness;
                colorNew.setdLightness(number.doubleValue());
            }
            colorSpec.setCachedObject(colorNew);
            return colorNew;
        }
        return null;
    }

    public static ColorNew createColorFromString(String string) {
        ColorNew colorNew = null;
        if (string == null) {
            return null;
        }
        colorNew = string.startsWith("#") ? ColorUtil.createColorFromHexCode(string) : (string.toLowerCase().startsWith("rgb(") || string.toLowerCase().startsWith("rgba(") ? ColorUtil.createColorFromRGBString(string) : ColorUtil.getCSSColorInternal(string.toLowerCase()));
        if (colorNew == null) {
            colorNew = ColorUtil.createDefaultColor();
        }
        return colorNew;
    }

    public static ColorNew createDefaultColor() {
        return DEFAULT_COLOR;
    }

    public static ColorNew getDefaultStrokeColor() {
        return DEFAULT_STROKE_FILL_COLOR;
    }

    public static ColorNew getDefaultFillColor() {
        return DEFAULT_FILL_COLOR;
    }

    public static ColorNew getDefaultGlowColor() {
        return DEFAULT_GLOW_COLOR;
    }

    public static ColorNew getDefaultShadowColor() {
        return DEFAULT_SHADOW_COLOR;
    }

    public static ColorNew getTransparentColor() {
        return TRANSPARENT;
    }

    public static ColorNew createColor() {
        return new ColorNew(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public static ColorNew createColorFromRGBA(double d, double d2, double d3, double d4) {
        return new ColorNew(d, d2, d3, d4);
    }

    public static ColorNew createColorFromRGB(double d, double d2, double d3) {
        return ColorUtil.createColorFromRGBA(d, d2, d3, Double.NaN);
    }

    public static ColorNew makeCombinedColor(ColorNew colorNew, ColorNew colorNew2) {
        if (colorNew2 == null) {
            return colorNew;
        }
        ColorNew colorNew3 = colorNew2.combineWithColor(colorNew);
        return colorNew3;
    }

    private static double checkForNull(Number number) {
        if (number == null) {
            return Double.NaN;
        }
        return number.doubleValue();
    }

    public static int parseHex(String string, int n, boolean bl) {
        Number number = IntegerUtil.parseInt(string.substring(n, n + (bl ? 1 : 2)), 16);
        if (number == null) {
            return -1;
        }
        int n2 = (int)number.doubleValue();
        if (bl) {
            return n2 * 17;
        }
        return n2;
    }

    private static ColorNew createColorFromHexCode(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = Double.NaN;
        if (n == 4) {
            n2 = ColorUtil.parseHex(string, 1, true);
            n3 = ColorUtil.parseHex(string, 2, true);
            n4 = ColorUtil.parseHex(string, 3, true);
        } else if (n == 5) {
            n2 = ColorUtil.parseHex(string, 1, true);
            n3 = ColorUtil.parseHex(string, 2, true);
            n4 = ColorUtil.parseHex(string, 3, true);
            d = (double)ColorUtil.parseHex(string, 4, true) / 255.0;
        } else if (n == 7) {
            n2 = ColorUtil.parseHex(string, 1, false);
            n3 = ColorUtil.parseHex(string, 3, false);
            n4 = ColorUtil.parseHex(string, 5, false);
        } else if (n == 9) {
            n2 = ColorUtil.parseHex(string, 1, false);
            n3 = ColorUtil.parseHex(string, 3, false);
            n4 = ColorUtil.parseHex(string, 5, false);
            d = (double)ColorUtil.parseHex(string, 7, false) / 255.0;
        } else {
            return null;
        }
        if (n2 < 0 || n3 < 0 || n4 < 0 || d < 0.0) {
            return null;
        }
        return ColorUtil.createColorFromRGBA(n2, n3, n4, d);
    }

    private static ColorNew createColorFromRGBString(String string) {
        String string2 = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
        String[] stringArray = string2.split(",");
        if (stringArray.length < 3 || stringArray.length > 4) {
            return null;
        }
        double d = BasicFactory.parseDouble(stringArray[0]);
        double d2 = BasicFactory.parseDouble(stringArray[1]);
        double d3 = BasicFactory.parseDouble(stringArray[2]);
        double d4 = 1.0;
        if (stringArray.length == 4) {
            d4 = BasicFactory.parseDouble(stringArray[3]);
        }
        return ColorUtil.createColorFromRGBA(d, d2, d3, d4);
    }

    public static ColorNew toCanonicalColor(Object object) {
        ColorNew colorNew = null;
        if (object != null) {
            if (BasicFactory.isString(object)) {
                colorNew = ColorUtil.createColorFromString((String)object);
            } else {
                colorNew = ColorUtil.createColorFromColorSpec((ColorSpec)object);
                if (colorNew.isEmpty()) {
                    colorNew = ColorUtil.createDefaultColor();
                }
            }
        }
        return colorNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ConcurrentHashMap<String, Integer> getCSSColors() {
        if (!cssColorsNeedsInit) return CSS_COLORS;
        Class<ColorUtil> clazz = ColorUtil.class;
        synchronized (ColorUtil.class) {
            if (!cssColorsNeedsInit) return CSS_COLORS;
            CSS_COLORS = new ConcurrentHashMap(150, 0.75f, 1);
            CSS_COLORS.put("aliceblue", ColorUtil.createIntFromRGB(240, 248, 255));
            CSS_COLORS.put("antiquewhite", ColorUtil.createIntFromRGB(250, 235, 215));
            CSS_COLORS.put("aqua", ColorUtil.createIntFromRGB(0, 255, 255));
            CSS_COLORS.put("aquamarine", ColorUtil.createIntFromRGB(127, 255, 212));
            CSS_COLORS.put("azure", ColorUtil.createIntFromRGB(240, 255, 255));
            CSS_COLORS.put("beige", ColorUtil.createIntFromRGB(245, 245, 220));
            CSS_COLORS.put("bisque", ColorUtil.createIntFromRGB(255, 228, 196));
            CSS_COLORS.put("black", ColorUtil.createIntFromRGB(0, 0, 0));
            CSS_COLORS.put("blanchedalmond", ColorUtil.createIntFromRGB(255, 235, 205));
            CSS_COLORS.put("blue", ColorUtil.createIntFromRGB(0, 0, 255));
            CSS_COLORS.put("blueviolet", ColorUtil.createIntFromRGB(138, 43, 226));
            CSS_COLORS.put("brown", ColorUtil.createIntFromRGB(165, 42, 42));
            CSS_COLORS.put("burlywood", ColorUtil.createIntFromRGB(222, 184, 135));
            CSS_COLORS.put("cadetblue", ColorUtil.createIntFromRGB(95, 158, 160));
            CSS_COLORS.put("chartreuse", ColorUtil.createIntFromRGB(127, 255, 0));
            CSS_COLORS.put("chocolate", ColorUtil.createIntFromRGB(210, 105, 30));
            CSS_COLORS.put("coral", ColorUtil.createIntFromRGB(255, 127, 80));
            CSS_COLORS.put("cornflowerblue", ColorUtil.createIntFromRGB(100, 149, 237));
            CSS_COLORS.put("cornsilk", ColorUtil.createIntFromRGB(255, 248, 220));
            CSS_COLORS.put("crimson", ColorUtil.createIntFromRGB(220, 20, 60));
            CSS_COLORS.put("cyan", ColorUtil.createIntFromRGB(0, 255, 255));
            CSS_COLORS.put("darkblue", ColorUtil.createIntFromRGB(0, 0, 139));
            CSS_COLORS.put("darkcyan", ColorUtil.createIntFromRGB(0, 139, 139));
            CSS_COLORS.put("darkgoldenrod", ColorUtil.createIntFromRGB(184, 134, 11));
            CSS_COLORS.put("darkgray", ColorUtil.createIntFromRGB(169, 169, 169));
            CSS_COLORS.put("darkgreen", ColorUtil.createIntFromRGB(0, 100, 0));
            CSS_COLORS.put("darkgrey", ColorUtil.createIntFromRGB(169, 169, 169));
            CSS_COLORS.put("darkkhaki", ColorUtil.createIntFromRGB(189, 183, 107));
            CSS_COLORS.put("darkmagenta", ColorUtil.createIntFromRGB(139, 0, 139));
            CSS_COLORS.put("darkolivegreen", ColorUtil.createIntFromRGB(85, 107, 47));
            CSS_COLORS.put("darkorange", ColorUtil.createIntFromRGB(255, 140, 0));
            CSS_COLORS.put("darkorchid", ColorUtil.createIntFromRGB(153, 50, 204));
            CSS_COLORS.put("darkred", ColorUtil.createIntFromRGB(139, 0, 0));
            CSS_COLORS.put("darksalmon", ColorUtil.createIntFromRGB(233, 150, 122));
            CSS_COLORS.put("darkseagreen", ColorUtil.createIntFromRGB(143, 188, 143));
            CSS_COLORS.put("darkslateblue", ColorUtil.createIntFromRGB(72, 61, 139));
            CSS_COLORS.put("darkslategray", ColorUtil.createIntFromRGB(47, 79, 79));
            CSS_COLORS.put("darkslategrey", ColorUtil.createIntFromRGB(47, 79, 79));
            CSS_COLORS.put("darkturquoise", ColorUtil.createIntFromRGB(0, 206, 209));
            CSS_COLORS.put("darkviolet", ColorUtil.createIntFromRGB(148, 0, 211));
            CSS_COLORS.put("deeppink", ColorUtil.createIntFromRGB(255, 20, 147));
            CSS_COLORS.put("deepskyblue", ColorUtil.createIntFromRGB(0, 191, 255));
            CSS_COLORS.put("dimgray", ColorUtil.createIntFromRGB(105, 105, 105));
            CSS_COLORS.put("dimgrey", ColorUtil.createIntFromRGB(105, 105, 105));
            CSS_COLORS.put("dodgerblue", ColorUtil.createIntFromRGB(30, 144, 255));
            CSS_COLORS.put("firebrick", ColorUtil.createIntFromRGB(178, 34, 34));
            CSS_COLORS.put("floralwhite", ColorUtil.createIntFromRGB(255, 250, 240));
            CSS_COLORS.put("forestgreen", ColorUtil.createIntFromRGB(34, 139, 34));
            CSS_COLORS.put("fuchsia", ColorUtil.createIntFromRGB(255, 0, 255));
            CSS_COLORS.put("gainsboro", ColorUtil.createIntFromRGB(220, 220, 220));
            CSS_COLORS.put("ghostwhite", ColorUtil.createIntFromRGB(248, 248, 255));
            CSS_COLORS.put("gold", ColorUtil.createIntFromRGB(255, 215, 0));
            CSS_COLORS.put("goldenrod", ColorUtil.createIntFromRGB(218, 165, 32));
            CSS_COLORS.put("gray", ColorUtil.createIntFromRGB(128, 128, 128));
            CSS_COLORS.put("grey", ColorUtil.createIntFromRGB(128, 128, 128));
            CSS_COLORS.put("green", ColorUtil.createIntFromRGB(0, 128, 0));
            CSS_COLORS.put("greenyellow", ColorUtil.createIntFromRGB(173, 255, 47));
            CSS_COLORS.put("honeydew", ColorUtil.createIntFromRGB(240, 255, 240));
            CSS_COLORS.put("hotpink", ColorUtil.createIntFromRGB(255, 105, 180));
            CSS_COLORS.put("indianred", ColorUtil.createIntFromRGB(205, 92, 92));
            CSS_COLORS.put("indigo", ColorUtil.createIntFromRGB(75, 0, 130));
            CSS_COLORS.put("ivory", ColorUtil.createIntFromRGB(255, 255, 240));
            CSS_COLORS.put("khaki", ColorUtil.createIntFromRGB(240, 230, 140));
            CSS_COLORS.put("lavender", ColorUtil.createIntFromRGB(230, 230, 250));
            CSS_COLORS.put("lavenderblush", ColorUtil.createIntFromRGB(255, 240, 245));
            CSS_COLORS.put("lawngreen", ColorUtil.createIntFromRGB(124, 252, 0));
            CSS_COLORS.put("lemonchiffon", ColorUtil.createIntFromRGB(255, 250, 205));
            CSS_COLORS.put("lightblue", ColorUtil.createIntFromRGB(173, 216, 230));
            CSS_COLORS.put("lightcoral", ColorUtil.createIntFromRGB(240, 128, 128));
            CSS_COLORS.put("lightcyan", ColorUtil.createIntFromRGB(224, 255, 255));
            CSS_COLORS.put("lightgoldenrodyellow", ColorUtil.createIntFromRGB(250, 250, 210));
            CSS_COLORS.put("lightgray", ColorUtil.createIntFromRGB(211, 211, 211));
            CSS_COLORS.put("lightgreen", ColorUtil.createIntFromRGB(144, 238, 144));
            CSS_COLORS.put("lightgrey", ColorUtil.createIntFromRGB(211, 211, 211));
            CSS_COLORS.put("lightpink", ColorUtil.createIntFromRGB(255, 182, 193));
            CSS_COLORS.put("lightsalmon", ColorUtil.createIntFromRGB(255, 160, 122));
            CSS_COLORS.put("lightseagreen", ColorUtil.createIntFromRGB(32, 178, 170));
            CSS_COLORS.put("lightskyblue", ColorUtil.createIntFromRGB(135, 206, 250));
            CSS_COLORS.put("lightslategray", ColorUtil.createIntFromRGB(119, 136, 153));
            CSS_COLORS.put("lightslategrey", ColorUtil.createIntFromRGB(119, 136, 153));
            CSS_COLORS.put("lightsteelblue", ColorUtil.createIntFromRGB(176, 196, 222));
            CSS_COLORS.put("lightyellow", ColorUtil.createIntFromRGB(255, 255, 224));
            CSS_COLORS.put("lime", ColorUtil.createIntFromRGB(0, 255, 0));
            CSS_COLORS.put("limegreen", ColorUtil.createIntFromRGB(50, 205, 50));
            CSS_COLORS.put("linen", ColorUtil.createIntFromRGB(250, 240, 230));
            CSS_COLORS.put("magenta", ColorUtil.createIntFromRGB(255, 0, 255));
            CSS_COLORS.put("maroon", ColorUtil.createIntFromRGB(128, 0, 0));
            CSS_COLORS.put("mediumaquamarine", ColorUtil.createIntFromRGB(102, 205, 170));
            CSS_COLORS.put("mediumblue", ColorUtil.createIntFromRGB(0, 0, 205));
            CSS_COLORS.put("mediumorchid", ColorUtil.createIntFromRGB(186, 85, 211));
            CSS_COLORS.put("mediumpurple", ColorUtil.createIntFromRGB(147, 112, 219));
            CSS_COLORS.put("mediumseagreen", ColorUtil.createIntFromRGB(60, 179, 113));
            CSS_COLORS.put("mediumslateblue", ColorUtil.createIntFromRGB(123, 104, 238));
            CSS_COLORS.put("mediumspringgreen", ColorUtil.createIntFromRGB(0, 250, 154));
            CSS_COLORS.put("mediumturquoise", ColorUtil.createIntFromRGB(72, 209, 204));
            CSS_COLORS.put("mediumvioletred", ColorUtil.createIntFromRGB(199, 21, 133));
            CSS_COLORS.put("midnightblue", ColorUtil.createIntFromRGB(25, 25, 112));
            CSS_COLORS.put("mintcream", ColorUtil.createIntFromRGB(245, 255, 250));
            CSS_COLORS.put("mistyrose", ColorUtil.createIntFromRGB(255, 228, 225));
            CSS_COLORS.put("moccasin", ColorUtil.createIntFromRGB(255, 228, 181));
            CSS_COLORS.put("navajowhite", ColorUtil.createIntFromRGB(255, 222, 173));
            CSS_COLORS.put("navy", ColorUtil.createIntFromRGB(0, 0, 128));
            CSS_COLORS.put("oldlace", ColorUtil.createIntFromRGB(253, 245, 230));
            CSS_COLORS.put("olive", ColorUtil.createIntFromRGB(128, 128, 0));
            CSS_COLORS.put("olivedrab", ColorUtil.createIntFromRGB(107, 142, 35));
            CSS_COLORS.put("orange", ColorUtil.createIntFromRGB(255, 165, 0));
            CSS_COLORS.put("orangered", ColorUtil.createIntFromRGB(255, 69, 0));
            CSS_COLORS.put("orchid", ColorUtil.createIntFromRGB(218, 112, 214));
            CSS_COLORS.put("palegoldenrod", ColorUtil.createIntFromRGB(238, 232, 170));
            CSS_COLORS.put("palegreen", ColorUtil.createIntFromRGB(152, 251, 152));
            CSS_COLORS.put("paleturquoise", ColorUtil.createIntFromRGB(175, 238, 238));
            CSS_COLORS.put("palevioletred", ColorUtil.createIntFromRGB(219, 112, 147));
            CSS_COLORS.put("papayawhip", ColorUtil.createIntFromRGB(255, 239, 213));
            CSS_COLORS.put("peachpuff", ColorUtil.createIntFromRGB(255, 218, 185));
            CSS_COLORS.put("peru", ColorUtil.createIntFromRGB(205, 133, 63));
            CSS_COLORS.put("pink", ColorUtil.createIntFromRGB(255, 192, 203));
            CSS_COLORS.put("plum", ColorUtil.createIntFromRGB(221, 160, 221));
            CSS_COLORS.put("powderblue", ColorUtil.createIntFromRGB(176, 224, 230));
            CSS_COLORS.put("purple", ColorUtil.createIntFromRGB(128, 0, 128));
            CSS_COLORS.put("red", ColorUtil.createIntFromRGB(255, 0, 0));
            CSS_COLORS.put("rosybrown", ColorUtil.createIntFromRGB(188, 143, 143));
            CSS_COLORS.put("royalblue", ColorUtil.createIntFromRGB(65, 105, 225));
            CSS_COLORS.put("saddlebrown", ColorUtil.createIntFromRGB(139, 69, 19));
            CSS_COLORS.put("salmon", ColorUtil.createIntFromRGB(250, 128, 114));
            CSS_COLORS.put("sandybrown", ColorUtil.createIntFromRGB(244, 164, 96));
            CSS_COLORS.put("seagreen", ColorUtil.createIntFromRGB(46, 139, 87));
            CSS_COLORS.put("seashell", ColorUtil.createIntFromRGB(255, 245, 238));
            CSS_COLORS.put("sienna", ColorUtil.createIntFromRGB(160, 82, 45));
            CSS_COLORS.put("silver", ColorUtil.createIntFromRGB(192, 192, 192));
            CSS_COLORS.put("skyblue", ColorUtil.createIntFromRGB(135, 206, 235));
            CSS_COLORS.put("slateblue", ColorUtil.createIntFromRGB(106, 90, 205));
            CSS_COLORS.put("slategray", ColorUtil.createIntFromRGB(112, 128, 144));
            CSS_COLORS.put("slategrey", ColorUtil.createIntFromRGB(112, 128, 144));
            CSS_COLORS.put("snow", ColorUtil.createIntFromRGB(255, 250, 250));
            CSS_COLORS.put("springgreen", ColorUtil.createIntFromRGB(0, 255, 127));
            CSS_COLORS.put("steelblue", ColorUtil.createIntFromRGB(70, 130, 180));
            CSS_COLORS.put("tan", ColorUtil.createIntFromRGB(210, 180, 140));
            CSS_COLORS.put("teal", ColorUtil.createIntFromRGB(0, 128, 128));
            CSS_COLORS.put("thistle", ColorUtil.createIntFromRGB(216, 191, 216));
            CSS_COLORS.put("tomato", ColorUtil.createIntFromRGB(255, 99, 71));
            CSS_COLORS.put("turquoise", ColorUtil.createIntFromRGB(64, 224, 208));
            CSS_COLORS.put("violet", ColorUtil.createIntFromRGB(238, 130, 238));
            CSS_COLORS.put("wheat", ColorUtil.createIntFromRGB(245, 222, 179));
            CSS_COLORS.put("white", ColorUtil.createIntFromRGB(255, 255, 255));
            CSS_COLORS.put("whitesmoke", ColorUtil.createIntFromRGB(245, 245, 245));
            CSS_COLORS.put("yellow", ColorUtil.createIntFromRGB(255, 255, 0));
            CSS_COLORS.put("yellowgreen", ColorUtil.createIntFromRGB(154, 205, 50));
            cssColorsNeedsInit = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return CSS_COLORS;
        }
    }

    private static int createIntFromRGB(int n, int n2, int n3) {
        int n4 = n | n2 << 8 | n3 << 16;
        return n4;
    }

    private static ColorNew getCSSColorInternal(String string) {
        ColorNew colorNew = null;
        if ("transparent".equals(string.toLowerCase())) {
            colorNew = TRANSPARENT;
        } else {
            Integer n = ColorUtil.getCSSColors().get(string.toLowerCase());
            if (n != null) {
                int n2 = n;
                int n3 = n2 & 0xFF;
                int n4 = (n2 & 0xFF00) >> 8;
                int n5 = (n2 & 0xFF0000) >> 16;
                colorNew = ColorUtil.createColorFromRGB(n3, n4, n5);
            }
        }
        return colorNew;
    }

    public static ColorNew[] getDefaultColors() {
        return DEFAULT_COLORS;
    }

    public static void validateColorName(String string) {
        if (string == null) {
            throw new EngineException("Color name string can not be null", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
        if (!string.equals("") && !ColorUtil.getCSSColors().containsKey(string.toLowerCase())) {
            throw new EngineException("Color name string " + string + " is not valid", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
    }

    public static void validateRGB(Number number, Number number2, Number number3) {
        if (number != null && (number.doubleValue() < 0.0 || number.doubleValue() > 255.0) || number2 != null && (number2.doubleValue() < 0.0 || number2.doubleValue() > 255.0) || number3 != null && (number3.doubleValue() < 0.0 || number3.doubleValue() > 255.0)) {
            String string = "";
            string = number != null ? string + number + ", " : string + "null ,";
            string = number2 != null ? string + number2 + ", " : string + "null ,";
            string = number3 != null ? string + number3 : string + "null";
            throw new EngineException("Color parameter values " + string + " outside of expected range: 0<=RGB<=255", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
    }

    public static void validateHSL(Number number, Number number2, Number number3) {
        if (number != null && (number.doubleValue() < 0.0 || number.doubleValue() > 1.0) || number2 != null && (number2.doubleValue() < 0.0 || number2.doubleValue() > 1.0) || number3 != null && (number3.doubleValue() < 0.0 || number3.doubleValue() > 1.0)) {
            String string = "";
            string = number != null ? string + number + ", " : string + "null ,";
            string = number2 != null ? string + number2 + ", " : string + "null ,";
            string = number3 != null ? string + number3 : string + "null";
            throw new EngineException("Color parameter values" + string + " outside of expected range: 0.0<=HSL<=1.0", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
    }

    public static void validateZeroToOneRange(Number number) {
        if (number != null && (number.doubleValue() < 0.0 || number.doubleValue() > 1.0)) {
            throw new EngineException("Color parameter value" + number + " outside of expected range: 0.0<=value<=1.0", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
    }

    public static void validateColorCSSString(String string) {
        if (string == null) {
            throw new EngineException("Color css RGB string can not be null. Valid formats are - \" rgb(int r, int g, int b)\", \"rgba(int r, int g, int b, int a)\"", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
        if (string.length() == 0) {
            return;
        }
        String string2 = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
        String[] stringArray = string2.split(",");
        if (stringArray.length < 3 || stringArray.length > 4) {
            throw new EngineException("Color css RGB string " + string + " is of invalid length. Valid formats are - \" rgb(int r, int g, int b)\", \"rgba(int r, int g, int b, int a)\"", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
        double d = BasicFactory.parseDouble(stringArray[0]);
        double d2 = BasicFactory.parseDouble(stringArray[1]);
        double d3 = BasicFactory.parseDouble(stringArray[2]);
        ColorUtil.validateRGB(d, d2, d3);
        if (stringArray.length == 4) {
            ColorUtil.validateZeroToOneRange(BasicFactory.parseDouble(stringArray[3]));
        }
    }

    public static void validateColorHexString(String string) {
        if (string == null || string.length() > 0 && string.charAt(0) != '#') {
            throw new EngineException("Color hex string can not be null and should start with #. Valid formats are - \"#RRGGBBAA\", \"#RRGGBB\", \"#RGBA\", \"#RGB\".", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
        if (string.length() == 0) {
            return;
        }
        ColorNew colorNew = ColorUtil.createColorFromHexCode(string);
        if (colorNew == null) {
            throw new EngineException("Color hex string - " + string + " is of invalid length or malformed. Valid formats are - \"#RRGGBBAA\", \"#RRGGBB\", \"#RGBA\", \"#RGB\".", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
        ColorUtil.validateRGB(colorNew.getRGBA()[0], colorNew.getRGBA()[1], colorNew.getRGBA()[2]);
        ColorUtil.validateZeroToOneRange(colorNew.getRGBA()[3]);
    }

    public static void validateColorObject(JSONObject jSONObject) {
        if (jSONObject == null) {
            throw new EngineException("Color object passed is can not be null. valid values are - 0 <= r,g,b values =< 255 0.0 <= h,s,l,a =< 1.0, \n -1.0 <= dValue,dSaturation,dLightness,dAlpha =< 1.0 ", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
        Number number = (Number)BasicFactory.getItem(jSONObject, "a");
        Number number2 = (Number)BasicFactory.getItem(jSONObject, "r");
        Number number3 = (Number)BasicFactory.getItem(jSONObject, "g");
        Number number4 = (Number)BasicFactory.getItem(jSONObject, "b");
        Number number5 = (Number)BasicFactory.getItem(jSONObject, "h");
        Number number6 = (Number)BasicFactory.getItem(jSONObject, "s");
        Number number7 = (Number)BasicFactory.getItem(jSONObject, "l");
        Number number8 = (Number)BasicFactory.getItem(jSONObject, "v");
        Number number9 = (Number)BasicFactory.getItem(jSONObject, "dAlpha");
        Number number10 = (Number)BasicFactory.getItem(jSONObject, "dSaturation");
        Number number11 = (Number)BasicFactory.getItem(jSONObject, "dLightness");
        Number number12 = (Number)BasicFactory.getItem(jSONObject, "dValue");
        ColorUtil.validateRGB(number2, number3, number4);
        ColorUtil.validateZeroToOneRange(number);
        ColorUtil.validateZeroToOneRange(number8);
        ColorUtil.validateHSL(number5, number6, number7);
        ColorUtil.validateDeltaValue(number9);
        ColorUtil.validateDeltaValue(number10);
        ColorUtil.validateDeltaValue(number11);
        ColorUtil.validateDeltaValue(number12);
    }

    public static void validateColorString(String string) {
        if (string == null) {
            throw new EngineException("Color object passed can not be null. valid values are - 0 <= r,g,b values =< 255 0.0 <= a =< 1.0", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
        if (string.startsWith("#")) {
            ColorUtil.validateColorHexString(string);
        } else if (string.toLowerCase().startsWith("rgb(") || string.toLowerCase().startsWith("rgba(")) {
            ColorUtil.validateColorCSSString(string);
        } else {
            ColorUtil.validateColorName(string);
        }
    }

    static void validateDeltaValue(Number number) {
        if (number == null) {
            return;
        }
        if (number.doubleValue() < -1.0 || number.doubleValue() > 1.0) {
            throw new EngineException("Color object passed" + number + " is invalid. valid values are -1.0 <= dValue,dSaturation,dLightness,dAlpha =< 1.0 ", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
    }

    public static ColorNew temperature(double d) {
        double d2 = (1.0 - d) * 9000.0 + 500.0;
        double[][] dArrayArray = new double[][]{{3.24071, -0.969258, 0.0556352}, {-1.53726, 1.87599, -0.203996}, {-0.498571, 0.0415557, 1.05707}};
        double d3 = d2 <= 4000.0 ? 2.7475E8 / (d2 * d2 * d2) - 985980.0 / (d2 * d2) + 1174.44 / d2 + 0.145986 : (d2 <= 7000.0 ? -4.607E9 / (d2 * d2 * d2) + 2967800.0 / (d2 * d2) + 99.11 / d2 + 0.244063 : -2.0064E9 / (d2 * d2 * d2) + 1901800.0 / (d2 * d2) + 247.48 / d2 + 0.23704);
        double d4 = -3.0 * d3 * d3 + 2.87 * d3 - 0.275;
        double d5 = d3 / d4;
        double d6 = 1.0;
        double d7 = (1.0 - d3 - d4) / d4;
        double d8 = 0.0;
        double[] dArray = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray[i] = (float)(d5 * dArrayArray[0][i] + d6 * dArrayArray[1][i] + d7 * dArrayArray[2][i]);
            if (!(dArray[i] > d8)) continue;
            d8 = dArray[i];
        }
        dArray[0] = 255.0 * Math.min(Math.max(0.1, dArray[0] / d8), 0.9);
        dArray[1] = 255.0 * Math.min(Math.max(0.1, dArray[1] / d8), 0.9);
        dArray[2] = 255.0 * Math.min(Math.max(0.1, dArray[2] / d8), 0.9);
        return ColorUtil.createColorFromRGB((int)Math.floor(dArray[0]), (int)Math.floor(dArray[1]), (int)Math.floor(dArray[2]));
    }

    static {
        DEFAULT_COLOR_CODES = new String[]{"#0089CE", "#7CBC4A", "#D8C625", "#F79428", "#D6332F", "#A83293", "#2A58A8", "#33A0DA", "#97C66D", "#E2DE59", "#FAA753", "#E46243", "#B45DA4", "#5C72B7", "#69AFE0", "#AFD78F", "#EBEC86", "#FCBC7B", "#EA8768", "#C282B8", "#717CAD"};
        TRANSPARENT = new ColorNew(0.0, 0.0, 0.0, 0.0);
        DEFAULT_FILL_COLOR = new ColorNew(170.0, 170.0, 170.0, 1.0);
        DEFAULT_COLOR = DEFAULT_STROKE_FILL_COLOR = new ColorNew(0.0, 0.0, 0.0, 1.0);
        DEFAULT_SHADOW_COLOR = DEFAULT_STROKE_FILL_COLOR;
        DEFAULT_GLOW_COLOR = new ColorNew(255.0, 255.0, 0.0, 1.0);
        DEFAULT_COLORS = new ColorNew[DEFAULT_COLOR_CODES.length];
        for (int i = 0; i < DEFAULT_COLOR_CODES.length; ++i) {
            ColorUtil.DEFAULT_COLORS[i] = ColorUtil.createColorFromHexCode(DEFAULT_COLOR_CODES[i]);
        }
        cssColorsNeedsInit = true;
    }
}

