/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.internal.Bounds;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.layout.ContentLayout;
import com.ibm.vis.engine.internal.layout.NoLayout;
import com.ibm.vis.engine.internal.layout.SizeInfo;
import com.ibm.vis.engine.internal.layout.length.Length;
import com.ibm.vis.engine.internal.layout.length.Lengths;
import com.ibm.vis.engine.internal.layout.length.Size;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ContentFrame {
    private static final String STROKE_ID_SUFFIX = "Stroke";
    private static final String OUTLINE_ID_SUFFIX = "Outline";
    private String id = "";
    private StyleSpec style = null;
    private Bounds specifiedBounds;
    private final ArrayList<ContentFrame> contents = new ArrayList();
    private ContentLayout layoutMethod = NoLayout.INSTANCE;
    private Rect bounds;
    private String strokeIDSuffix = "Stroke";
    private String fillIDSuffix = "Outline";
    private boolean requiresBackgroundShape = false;
    private Dim overallBounds;
    private final Map<Double, SizeInfo> known = new HashMap<Double, SizeInfo>();

    public void clearCachedSizes() {
        this.known.clear();
    }

    public final void setStyle(StyleSpec styleSpec) {
        this.style = styleSpec;
    }

    public final void setLayout(ContentLayout contentLayout) {
        this.layoutMethod = contentLayout;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public final void setSpecifiedBounds(Bounds bounds) {
        this.specifiedBounds = bounds;
    }

    public final Bounds getSpecifiedBounds() {
        return this.specifiedBounds;
    }

    public void add(ContentFrame contentFrame) {
        assert (contentFrame != null);
        this.contents.add(contentFrame);
    }

    public final SizeInfo getSizeInfo(Double d, Double d2) {
        Object object;
        Object object2;
        if (this.specifiedBounds != null && this.specifiedBounds.getValue("width") != null && this.specifiedBounds.getValue("height") != null) {
            object2 = this.specifiedBounds.getValue("width");
            object = this.specifiedBounds.getValue("height");
            if (object2 != null && object != null) {
                Size size = new Size(Lengths.fromSpec(object2), Lengths.fromSpec(object));
                return new SizeInfo(size, size, size);
            }
        }
        object2 = this.getContentSizeInfo(this.getPaddedWidth(d), this.getPaddedHeight(d2));
        object = this.adjustSize(((SizeInfo)object2).getPreferred(), true);
        Size size = this.adjustSize(((SizeInfo)object2).getMinimum(), false);
        Size size2 = this.adjustSize(((SizeInfo)object2).getMaximum(), true);
        return new SizeInfo((Size)object, size, size2);
    }

    private Double getPaddedHeight(Double d) {
        Double d2 = d;
        if (d != null && this.style != null) {
            Dim dim = new Dim(d, d);
            Insets insets = Insets.makeForStylePadding(this.style.padding, dim, dim);
            Rect rect = new Rect(0.0, 0.0, 100.0, d);
            d2 = insets.insetRect(rect).getHeight();
        }
        return d2;
    }

    private Double getPaddedWidth(Double d) {
        Double d2 = d;
        if (d != null && this.style != null) {
            Dim dim = new Dim(d, d);
            Insets insets = Insets.makeForStylePadding(this.style.padding, dim, dim);
            Rect rect = new Rect(0.0, 0.0, d, 100.0);
            d2 = insets.insetRect(rect).getWidth();
        }
        return d2;
    }

    private Size adjustSize(Size size, boolean bl) {
        if (bl) {
            size = this.expandDim(size);
        }
        size = this.modifyWithBoundsSize(size);
        if (this.style != null && this.style.snap != null && this.style.snap.booleanValue()) {
            size = Size.ceil(size);
        }
        return size;
    }

    public SizeInfo getContentSizeInfo(Double d, Double d2) {
        double d3 = (d == null ? -1.0 : d) * 1000.0;
        SizeInfo sizeInfo = this.known.get(d3 += d2 == null ? -1.0 : d2);
        if (sizeInfo == null && (sizeInfo = this.layoutMethod.getSizeInfo(this, d, d2)).getPreferred().getHeight().resolve(100.0, 100.0) > 0.0 && sizeInfo.getPreferred().getWidth().resolve(100.0, 100.0) > 0.0) {
            this.known.put(d3, sizeInfo);
        }
        return sizeInfo;
    }

    private Size expandDim(Size size) {
        if (size != null && this.style != null && this.style.padding != null) {
            return size.pad(this.style.padding);
        }
        return size;
    }

    protected Size modifyWithBoundsSize(Size size) {
        Size size2 = size;
        if (this.specifiedBounds != null) {
            Length length;
            Length length2;
            Length length3 = size.getWidth();
            Length length4 = size.getHeight();
            Object object = this.specifiedBounds.getValue("left");
            Object object2 = this.specifiedBounds.getValue("right");
            Object object3 = this.specifiedBounds.getValue("width");
            Object object4 = this.specifiedBounds.getValue("top");
            Object object5 = this.specifiedBounds.getValue("bottom");
            Object object6 = this.specifiedBounds.getValue("height");
            if (object != null && object2 != null) {
                length2 = Lengths.fromSpec(object2);
                length = Lengths.fromSpec(object);
                if (!length.isNegative() && !length2.isNegative()) {
                    length3 = Lengths.subtract(length2, length);
                }
            } else if (object3 != null) {
                length3 = Lengths.fromSpec(object3);
            }
            if (object4 != null && object5 != null) {
                length2 = Lengths.fromSpec(object5);
                length = Lengths.fromSpec(object4);
                if (!length2.isNegative() && !length.isNegative()) {
                    length4 = Lengths.subtract(length2, length);
                }
            } else if (object6 != null) {
                length4 = Lengths.fromSpec(object6);
            }
            size2 = new Size(length3, length4);
        }
        return size2;
    }

    public final Dim getExtent() {
        if (this.bounds == null) {
            return null;
        }
        Rect rect = this.getContentBounds();
        if (rect == null) {
            return null;
        }
        return rect.getExtent();
    }

    public void layoutWithBounds(Rect rect, Dim dim, Dim dim2) {
        this.overallBounds = dim2;
        this.bounds = rect;
        this.layoutMethod.layout(this, dim, dim2);
    }

    public final ArrayList<ContentFrame> getChildren() {
        return this.contents;
    }

    public final StyleSpec getStyle() {
        return this.style;
    }

    public Rect getBounds() {
        return this.bounds;
    }

    public Rect getContentBounds() {
        Rect rect = new Rect(0.0, 0.0, this.bounds.getWidth(), this.bounds.getHeight());
        if (this.style != null) {
            Dim dim = this.bounds.getExtent();
            Insets insets = Insets.makeForStylePadding(this.style.padding, dim, dim);
            rect = insets.insetRect(rect);
        }
        return rect;
    }

    public final void createShapesInScene(List<SceneNode> list) {
        boolean bl;
        List<SceneNode> list2 = this.createContent();
        Point point = this.getContentBounds().getTopLeft();
        Rect rect = this.getBounds();
        assert (rect != null);
        Point point2 = rect.getTopLeft();
        for (SceneNode sceneNode : list2) {
            sceneNode.translate(point.getX(), point.getY());
            sceneNode.translate(point2.getX(), point2.getY());
        }
        boolean bl2 = bl = list2.size() > 0;
        if (bl) {
            SceneNode sceneNode;
            if (this.style != null) {
                sceneNode = ItemBuilder.createFillShape(this.bounds, this.style, this.id + this.fillIDSuffix);
                sceneNode.translate(point2.getX(), point2.getY());
                list.add(sceneNode);
                if (this.hasOutlineStroke()) {
                    Object object;
                    Object object2 = this.style;
                    if (this.style.effect != null && this.style.effect.shadow != null && !StyleBuilder.hasTransparentFill(this.style)) {
                        object = (StyleSpec)this.style.copy();
                        ((StyleSpec)object).effect.shadow = null;
                        if (((StyleSpec)object).effect.glow == null) {
                            ((StyleSpec)object).effect = null;
                        }
                        object2 = object;
                    }
                    object = ItemBuilder.createOutlineShape(this.bounds, (StyleSpec)object2, this.id + this.strokeIDSuffix);
                    object.translate(point2.getX(), point2.getY());
                    list.add((SceneNode)object);
                }
            } else if (this.requiresBackgroundShape) {
                sceneNode = ItemBuilder.createBackgroundShape(this.bounds, this.style, this.id + this.fillIDSuffix);
                sceneNode.translate(point2.getX(), point2.getY());
                list.add(sceneNode);
            }
        }
        list.addAll(list2);
    }

    private boolean hasOutlineStroke() {
        if (this.style != null) {
            if (this.style.stroke != null && this.style.stroke.width != null) {
                Double d = UnitConverter.convertLength(this.style.stroke.width, null, null);
                return d != null && d > 0.0;
            }
            if (this.style.outline != null) {
                return true;
            }
        }
        return false;
    }

    protected List<SceneNode> createContent() {
        ArrayList<SceneNode> arrayList = new ArrayList<SceneNode>();
        Iterator<ContentFrame> iterator = this.contents.iterator();
        while (iterator.hasNext()) {
            ContentFrame contentFrame;
            ContentFrame contentFrame2 = contentFrame = iterator.next();
            Rect rect = contentFrame.getBounds();
            if (rect == null || !rect.hasExtent()) continue;
            contentFrame2.createShapesInScene(arrayList);
        }
        return arrayList;
    }

    public void setBackgroundIdSuffixes(String string, String string2) {
        this.strokeIDSuffix = string;
        this.fillIDSuffix = string2;
    }

    public void setRequiresBackgroundShape(boolean bl) {
        this.requiresBackgroundShape = bl;
    }

    public Rect getClipBounds() {
        Rect rect = this.getContentBounds();
        return new Rect(-rect.getX(), -rect.getY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    public Dim getOverallBounds() {
        return this.overallBounds;
    }
}

