/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.internal.ContentFrame;
import com.ibm.vis.engine.internal.LegendPosition;
import com.ibm.vis.engine.internal.layout.FlowLayout;
import com.ibm.vis.engine.internal.layout.OverlayLayout;
import com.ibm.vis.engine.internal.layout.SizeInfo;
import com.ibm.vis.engine.internal.layout.length.Size;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class DefaultVisContentFrame
extends ContentFrame {
    private final ContentFrame titleFrame;
    private final ContentFrame topFrame;
    private final ContentFrame bottomFrame;
    private final ContentFrame leftFrame;
    private final ContentFrame grammarFrame;
    private final ContentFrame rightFrame;
    private final ContentFrame legendFrame;

    public DefaultVisContentFrame() {
        this.setId("Back");
        this.grammarFrame = new ContentFrame();
        this.grammarFrame.setLayout(OverlayLayout.INSTANCE);
        this.grammarFrame.setId("grammar");
        this.add(this.grammarFrame);
        this.legendFrame = new ContentFrame();
        this.legendFrame.setLayout(OverlayLayout.INSTANCE);
        this.legendFrame.setId("overlay");
        this.add(this.legendFrame);
        this.titleFrame = new ContentFrame();
        this.titleFrame.setLayout(FlowLayout.TITLE_LAYOUT);
        this.titleFrame.setId("title");
        this.add(this.titleFrame);
        this.topFrame = new ContentFrame();
        this.topFrame.setLayout(FlowLayout.HORIZONTAL);
        this.topFrame.setId("top");
        this.add(this.topFrame);
        this.bottomFrame = new ContentFrame();
        this.bottomFrame.setLayout(FlowLayout.HORIZONTAL);
        this.bottomFrame.setId("bottom");
        this.add(this.bottomFrame);
        this.leftFrame = new ContentFrame();
        this.leftFrame.setLayout(FlowLayout.VERTICAL);
        this.leftFrame.setId("left");
        this.add(this.leftFrame);
        this.rightFrame = new ContentFrame();
        this.rightFrame.setLayout(FlowLayout.VERTICAL);
        this.rightFrame.setId("right");
        this.add(this.rightFrame);
    }

    public void addGrammar(ContentFrame contentFrame) {
        this.grammarFrame.add(contentFrame);
    }

    public void addFloatingLegend(ContentFrame contentFrame) {
        this.legendFrame.add(contentFrame);
    }

    public void addLegend(ContentFrame contentFrame, LegendPosition legendPosition) {
        if (LegendPosition.LEFT == legendPosition) {
            this.leftFrame.add(contentFrame);
        } else if (LegendPosition.TOP == legendPosition) {
            this.topFrame.add(contentFrame);
        } else if (LegendPosition.BOTTOM == legendPosition) {
            this.bottomFrame.add(contentFrame);
        } else {
            this.rightFrame.add(contentFrame);
        }
    }

    public void addTitle(ContentFrame contentFrame) {
        this.titleFrame.add(contentFrame);
    }

    public void addFootnote(ContentFrame contentFrame) {
        this.bottomFrame.add(contentFrame);
    }

    @Override
    public void layoutWithBounds(Rect rect, Dim dim, Dim dim2) {
        super.layoutWithBounds(rect, dim, dim2);
        Rect rect2 = this.getContentBounds();
        Dim dim3 = rect2.getExtent();
        SizeInfo sizeInfo = this.rightFrame.getSizeInfo(null, null);
        SizeInfo sizeInfo2 = this.leftFrame.getSizeInfo(null, null);
        SizeInfo sizeInfo3 = this.grammarFrame.getSizeInfo(null, null);
        Dim dim4 = sizeInfo.getConstrainedPreferred(dim3, dim2);
        Dim dim5 = sizeInfo.getMinimum().toDim(dim3, dim2);
        Dim dim6 = sizeInfo2.getConstrainedPreferred(dim3, dim2);
        Dim dim7 = sizeInfo2.getMinimum().toDim(dim3, dim2);
        double d = 0.0;
        double d2 = dim6.getWidth();
        double d3 = rect2.getWidth() - dim4.getWidth();
        double d4 = dim3.getWidth();
        double d5 = Math.max(0.0, d3 - d2);
        SizeInfo sizeInfo4 = this.titleFrame.getSizeInfo(d5, null);
        Dim dim8 = sizeInfo4.getConstrainedPreferred(dim3, dim2);
        SizeInfo sizeInfo5 = this.topFrame.getSizeInfo(dim3.getWidth(), null);
        SizeInfo sizeInfo6 = this.bottomFrame.getSizeInfo(dim3.getWidth(), null);
        Dim dim9 = sizeInfo5.getConstrainedPreferred(dim3, dim2);
        Dim dim10 = sizeInfo5.getMinimum().toDim(dim3, dim2);
        Dim dim11 = sizeInfo6.getConstrainedPreferred(dim3, dim2);
        Dim dim12 = sizeInfo6.getMinimum().toDim(dim3, dim2);
        double d6 = 0.0;
        double d7 = dim8.getHeight();
        double d8 = dim8.getHeight() + dim9.getHeight();
        double d9 = rect2.getHeight() - dim11.getHeight();
        double d10 = dim3.getHeight();
        double d11 = d9 - d8;
        if (d11 < 0.0) {
            d11 = 0.0;
        }
        if (d11 < dim6.getHeight()) {
            sizeInfo2 = this.leftFrame.getSizeInfo(null, d11);
            dim6 = sizeInfo2.getPreferred().toDim(dim, dim2);
            dim7 = sizeInfo2.getMinimum().toDim(dim, dim2);
            d2 = dim6.getWidth();
            d5 = Math.max(0.0, d3 - d2);
        }
        if (d11 < dim4.getHeight()) {
            sizeInfo = this.rightFrame.getSizeInfo(null, d11);
            dim4 = sizeInfo.getPreferred().toDim(dim, dim2);
            dim5 = sizeInfo.getMinimum().toDim(dim, dim2);
            d3 = rect2.getWidth() - dim4.getWidth();
            d5 = Math.max(0.0, d3 - d2);
        }
        Dim dim13 = new Dim(d5, d11);
        Dim dim14 = sizeInfo3.getMinimum().toDim(dim13, dim2);
        Dim dim15 = sizeInfo3.getPreferred().toDim(dim13, dim2);
        if (d5 < dim15.getWidth() || dim15.getWidth() == 0.0 && dim14.getWidth() == 0.0) {
            double d12 = dim3.getWidth() / 3.0;
            double d13 = dim3.getWidth() - dim15.getWidth();
            d2 = dim6.getWidth() > dim3.getWidth() || dim7.getWidth() > dim3.getWidth() ? d12 : Math.max(dim7.getWidth(), Math.min(dim6.getWidth(), Math.max(d12, d13)));
            d3 = dim4.getWidth() > dim3.getWidth() || dim5.getWidth() > dim3.getWidth() ? dim3.getWidth() - d12 : d4 - Math.max(dim5.getWidth(), Math.min(dim4.getWidth(), Math.max(d12, d13)));
            d5 = Math.max(0.0, d3 - d2);
            if (d5 < dim14.getWidth()) {
                double d14;
                double d15;
                dim6 = sizeInfo2.getPreferred().toDim(dim, dim2);
                dim4 = sizeInfo.getPreferred().toDim(dim, dim2);
                double d16 = dim3.getWidth() - dim14.getWidth();
                double d17 = (d16 - (d15 = dim7.getWidth() + dim5.getWidth())) / ((d14 = dim6.getWidth() + dim4.getWidth()) - d15);
                if (d17 < 0.0) {
                    throw new EngineException("The chart cannot be laid out (horizontal width of grammar, plus widths of right and left legends, is larger than chart size)", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
                }
                double d18 = sizeInfo2.getMaximum().toDim(dim, dim2).getWidth();
                d2 = this.interpolate(d17, dim7.getWidth(), dim6.getWidth(), d18);
                double d19 = sizeInfo.getMaximum().toDim(dim, dim2).getWidth();
                d3 = d4 - this.interpolate(d17, dim5.getWidth(), dim4.getWidth(), d19);
            }
        }
        if (d11 < dim15.getHeight() || dim15.getHeight() == 0.0 && dim14.getHeight() == 0.0) {
            sizeInfo4 = this.titleFrame.getContentSizeInfo(d5, null);
            dim8 = sizeInfo4.getConstrainedPreferred(dim3, dim2);
            Dim dim16 = sizeInfo4.getMinimum().toDim(dim3, dim2);
            d7 = Math.max(dim16.getHeight(), Math.min(dim8.getHeight(), Math.max(dim3.getHeight() / 2.0, dim3.getHeight() - dim15.getHeight())));
            sizeInfo4 = this.titleFrame.getContentSizeInfo(d5, d7);
            d7 = sizeInfo4.getPreferred().toDim(dim, dim2).getHeight();
            double d20 = dim3.getHeight() / 6.0;
            double d21 = dim3.getHeight() - dim15.getHeight();
            d8 = dim9.getHeight() > dim3.getHeight() || dim10.getWidth() > dim3.getWidth() ? dim8.getHeight() + d20 : d7 + Math.max(dim10.getHeight(), Math.min(dim9.getHeight(), Math.max(d20, d21)));
            d9 = dim11.getHeight() > dim3.getHeight() || dim12.getWidth() > dim3.getWidth() ? dim3.getHeight() - d20 : d10 - Math.max(dim12.getHeight(), Math.min(dim11.getHeight(), Math.max(d20, d21)));
            d11 = d9 - d8;
            if (d11 < dim14.getHeight()) {
                double d22;
                double d23;
                dim9 = sizeInfo5.getPreferred().toDim(dim, dim2);
                dim11 = sizeInfo6.getPreferred().toDim(dim, dim2);
                dim8 = sizeInfo4.getPreferred().toDim(dim, dim2);
                double d24 = dim3.getHeight() - dim14.getHeight();
                double d25 = (d24 - (d23 = dim10.getHeight() + dim12.getHeight() + dim16.getHeight())) / ((d22 = dim9.getHeight() + dim11.getHeight() + dim8.getHeight()) - d23);
                if (d25 < 0.0) {
                    throw new EngineException("The chart cannot be laid out (vertical height of grammar, plus heights of top and bottom legends and title, is larger than chart size)", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
                }
                double d26 = sizeInfo4.getMaximum().toDim(dim, dim2).getHeight();
                d7 = this.interpolate(d25, dim16.getHeight(), dim8.getHeight(), d26);
                double d27 = sizeInfo5.getMaximum().toDim(dim, dim2).getHeight();
                d8 = d7 + this.interpolate(d25, dim10.getHeight(), dim9.getHeight(), d27);
                double d28 = sizeInfo6.getMaximum().toDim(dim, dim2).getHeight();
                d9 = d10 - this.interpolate(d25, dim12.getHeight(), dim11.getHeight(), d28);
            }
        }
        Rect rect3 = this.makeRectBetweenGuides(d2, d6, d3, d7);
        Rect rect4 = this.makeRectBetweenGuides(d, d7, d4, d8);
        Rect rect5 = this.makeRectBetweenGuides(d, d8, d2, d9);
        Rect rect6 = this.makeRectBetweenGuides(d2, d8, d3, d9);
        Rect rect7 = this.makeRectBetweenGuides(d3, d8, d4, d9);
        Rect rect8 = this.makeRectBetweenGuides(d, d9, d4, d10);
        this.layoutSubFrame(this.titleFrame, rect3, dim3, dim2, "title");
        this.layoutSubFrame(this.topFrame, rect4, dim3, dim2, "top legends");
        this.layoutSubFrame(this.leftFrame, rect5, dim3, dim2, "left legends");
        this.layoutSubFrame(this.grammarFrame, rect6, rect6.getExtent(), dim2, "grammar");
        this.layoutSubFrame(this.rightFrame, rect7, dim3, dim2, "right legends");
        this.layoutSubFrame(this.bottomFrame, rect8, dim3, dim2, "bottom legends");
        this.layoutSubFrame(this.legendFrame, rect6, rect6.getExtent(), dim2, "overlay legends");
    }

    private double interpolate(double d, double d2, double d3, double d4) {
        return Math.min(d4, d2 + d * (d3 - d2));
    }

    private Rect makeRectBetweenGuides(double d, double d2, double d3, double d4) {
        return new Rect(d, d2, d3 - d, d4 - d2);
    }

    private void layoutSubFrame(ContentFrame contentFrame, Rect rect, Dim dim, Dim dim2, String string) {
        Dim dim3 = contentFrame.getSizeInfo(null, null).getMinimum().toDim(dim, dim2);
        if (Math.round(rect.getWidth()) < Math.round(dim3.getWidth()) || Math.round(rect.getHeight()) < Math.round(dim3.getHeight())) {
            if (Math.round(rect.getWidth()) < Math.round(dim3.getWidth())) {
                throw new EngineException("The chart cannot be laid out (width of " + string + " is too large for the available space)", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
            }
            throw new EngineException("The chart cannot be laid out (height of " + string + " is too large for the available space)", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
        }
        contentFrame.layoutWithBounds(rect, dim, dim2);
    }

    @Override
    public SizeInfo getContentSizeInfo(Double d, Double d2) {
        double d3;
        Size size = this.legendFrame.getSizeInfo(null, null).getPreferred();
        double d4 = size.getWidth().resolve(500.0, 500.0);
        double d5 = size.getHeight().resolve(400.0, 400.0);
        Size size2 = this.grammarFrame.getSizeInfo(null, null).getPreferred();
        double d6 = size2.getWidth().resolve(500.0, 500.0);
        double d7 = size2.getHeight().resolve(400.0, 400.0);
        Size size3 = this.rightFrame.getSizeInfo(null, null).getPreferred();
        double d8 = size3.getHeight().resolve(400.0, 400.0);
        d8 = Math.min(1.5 * d7, d8);
        Size size4 = this.leftFrame.getSizeInfo(null, null).getPreferred();
        double d9 = size4.getHeight().resolve(400.0, 400.0);
        d9 = Math.min(1.5 * d7, d9);
        double d10 = Math.max(Math.max(d8, d9), Math.max(d5, d7));
        double d11 = Math.max(d4, d6);
        Size size5 = this.titleFrame.getSizeInfo(null, null).getPreferred();
        if (d11 < 60.0) {
            if (d != null) {
                d11 = d;
            } else {
                d3 = size5.getWidth().resolve(500.0, 500.0);
                d11 = Math.max(d11, Math.min(60.0, d3));
            }
        }
        if (d11 == 0.0) {
            d11 = d != null ? d.doubleValue() : size5.getWidth().resolve(400.0, 400.0);
        }
        size3 = this.rightFrame.getSizeInfo(null, d10).getPreferred();
        size4 = this.leftFrame.getSizeInfo(null, d10).getPreferred();
        d3 = size3.getWidth().resolve(500.0, 500.0);
        double d12 = size4.getWidth().resolve(500.0, 500.0);
        double d13 = d3 + d11 + d12;
        Size size6 = this.topFrame.getSizeInfo(d13, null).getPreferred();
        double d14 = size6.getHeight().resolve(400.0, 400.0);
        Size size7 = this.bottomFrame.getSizeInfo(d13, null).getPreferred();
        double d15 = size7.getHeight().resolve(400.0, 400.0);
        size5 = this.titleFrame.getSizeInfo(d11, null).getPreferred();
        double d16 = size5.getHeight().resolve(400.0, 400.0);
        double d17 = d16 + d14 + d10 + d15;
        Size size8 = Size.makeFixed(Math.ceil(d13), Math.ceil(d17));
        return new SizeInfo(size8, Size.ZERO, Size.UNLIMITED);
    }
}

