/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.Gradient;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.scenetree.provisional.FillProperty;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class Fill
implements FillProperty {
    private static Fill DEFAULT_STROKE_FILL = Fill.makeSolid(ColorUtil.getDefaultStrokeColor());
    private static Fill DEFAULT_FILL = Fill.makeSolid(ColorUtil.getDefaultFillColor());
    private static Fill EMPTY_FILL = new Fill(null, null);
    private ColorNew solid;
    private Gradient gradient;

    private Fill(ColorNew colorNew, Gradient gradient) {
        this.solid = colorNew;
        this.gradient = gradient;
    }

    public static Fill createFill(ColorNew colorNew, Gradient gradient) {
        if (gradient == null && colorNew == null) {
            return EMPTY_FILL;
        }
        return new Fill(colorNew, gradient);
    }

    @Override
    public ColorNew getSolid() {
        return this.solid;
    }

    public ColorNew[] getGradientColors() {
        return this.gradient == null ? null : this.gradient.getGradientColors();
    }

    public Gradient getGradient() {
        return this.gradient;
    }

    public static Fill getDefaultStrokeFill() {
        return DEFAULT_STROKE_FILL;
    }

    public static Fill getDefaultFill() {
        return DEFAULT_FILL;
    }

    public static Fill makeEmptyFill() {
        return EMPTY_FILL;
    }

    public static Fill makeSolid(ColorNew colorNew) {
        Fill fill = Fill.createFill(colorNew, null);
        return fill;
    }

    public static Fill makeGradient(Gradient gradient) {
        Fill fill = Fill.createFill(null, gradient);
        return fill;
    }

    public static Fill makeCopy(Fill fill) {
        if (fill == null) {
            return null;
        }
        Fill fill2 = Fill.createFill(fill.solid, fill.gradient);
        return fill2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Fill)) {
            return false;
        }
        Fill fill = (Fill)object;
        if (this.solid != null) {
            return this.solid.equals(fill.solid);
        }
        if (this.gradient != null) {
            return this.gradient.equals(fill.gradient);
        }
        return fill.solid == null && fill.gradient == null;
    }

    public int hashCode() {
        int n = this.solid == null ? 0 : this.solid.hashCode();
        n *= 17;
        return n += this.gradient == null ? 0 : this.gradient.hashCode();
    }
}

