/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.DateFormatter;
import com.ibm.vis.engine.LocalizedDateFormatter;
import com.ibm.vis.engine.LocalizedNumberFormatter;
import com.ibm.vis.engine.NumberFormatter;
import com.ibm.vis.engine.StringFormatter;
import com.ibm.vis.engine.internal.FormatWrapper;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.LocaleUtil;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FormatContext {
    public NumberFormatter integratorNumberFormatter = null;
    public LocalizedNumberFormatter integratorLocalizedNumberFormatter;
    public StringFormatter integratorStringFormatter = null;
    public DateFormatter integratorDateFormatter = null;
    public LocalizedDateFormatter integratorLocalizedDateFormatter;
    private final RAVEFormatter defaultFormatter = RAVEFormatter.make(null, "", "", false, LocaleUtil.getDefaultLocale());
    private final VisContext visContext;

    public FormatContext(VisContext visContext) {
        this.visContext = visContext;
    }

    public boolean hasCustomNumberFormatter() {
        FormatWrapper formatWrapper;
        if (this.integratorNumberFormatter != null) {
            if (this.integratorNumberFormatter instanceof FormatWrapper) {
                formatWrapper = (FormatWrapper)this.integratorNumberFormatter;
                if (formatWrapper.numberFormatter != null && !(formatWrapper.numberFormatter instanceof RAVEFormatter)) {
                    return true;
                }
                if (formatWrapper.localizedNumberFormatter != null && !(formatWrapper.localizedNumberFormatter instanceof RAVEFormatter)) {
                    return true;
                }
            } else if (!(this.integratorNumberFormatter instanceof RAVEFormatter)) {
                return true;
            }
        }
        if (this.integratorLocalizedNumberFormatter != null) {
            if (this.integratorLocalizedNumberFormatter instanceof FormatWrapper) {
                formatWrapper = (FormatWrapper)this.integratorLocalizedNumberFormatter;
                if (formatWrapper.numberFormatter != null && !(formatWrapper.numberFormatter instanceof RAVEFormatter)) {
                    return true;
                }
                if (formatWrapper.localizedNumberFormatter != null && !(formatWrapper.localizedNumberFormatter instanceof RAVEFormatter)) {
                    return true;
                }
            } else if (!(this.integratorLocalizedNumberFormatter instanceof RAVEFormatter)) {
                return true;
            }
        }
        return false;
    }

    public String formatNumber(Number number, RAVEFormatter rAVEFormatter, int n, String string, Range range, Unit unit) {
        String string2;
        String string3 = null;
        String string4 = string2 = this.visContext != null && this.visContext.getLocale() != null ? this.visContext.getLocale() : LocaleUtil.getDefaultLocale();
        if (number != null && Double.isNaN(number.doubleValue())) {
            number = null;
        }
        if (this.integratorLocalizedNumberFormatter != null) {
            string3 = this.integratorLocalizedNumberFormatter.formatLocalizedNumber(number, n, string, range.getMin(), range.getMax(), unit.name, this.visContext.visId, string2);
        }
        if (string3 != null) {
            return string3;
        }
        if (this.integratorNumberFormatter != null) {
            string3 = this.integratorNumberFormatter.formatNumber(number, n, string, range.getMin(), range.getMax(), unit.name, this.visContext.visId);
        }
        if (string3 != null) {
            return string3;
        }
        if (rAVEFormatter != null) {
            return rAVEFormatter.formatLocalizedNumberRange(number, n, string, range, unit.name, this.visContext.visId, string2);
        }
        return this.defaultFormatter.formatLocalizedNumberRange(number, n, string, range, unit.name, this.visContext.visId, string2);
    }

    public String formatToExponential(Number number, double d, double d2, RAVEFormatter rAVEFormatter) {
        String string;
        String string2 = string = this.visContext != null && this.visContext.getLocale() != null ? this.visContext.getLocale() : LocaleUtil.getDefaultLocale();
        if (number != null && Double.isNaN(number.doubleValue())) {
            number = null;
        }
        return rAVEFormatter.formatToExponential(number, d, d2, string);
    }

    public String formatString(String string, RAVEFormatter rAVEFormatter, int n, String string2) {
        String string3 = null;
        if (this.integratorStringFormatter != null) {
            string3 = this.integratorStringFormatter.formatString(string, n, string2, this.visContext.visId);
        }
        if (string3 != null) {
            return string3;
        }
        if (rAVEFormatter != null) {
            return rAVEFormatter.formatString(string, n, string2, this.visContext.visId);
        }
        return this.defaultFormatter.formatString(string, n, string2, this.visContext.visId);
    }

    public String formatDate(Object object, RAVEFormatter rAVEFormatter, int n, String string, Unit unit, String string2) {
        String string3;
        String string4 = null;
        String string5 = string3 = this.visContext != null && this.visContext.getLocale() != null ? this.visContext.getLocale() : LocaleUtil.getDefaultLocale();
        if (this.integratorLocalizedDateFormatter != null) {
            string4 = this.integratorLocalizedDateFormatter.formatLocalizedDate(object, n, string, unit.name, this.visContext.visId, string3, string2);
        }
        if (string4 != null) {
            return string4;
        }
        if (this.integratorDateFormatter != null) {
            string4 = this.integratorDateFormatter.formatDate(object, n, string, unit.name, this.visContext.visId);
        }
        if (string4 != null) {
            return string4;
        }
        if (rAVEFormatter != null) {
            return rAVEFormatter.formatLocalizedDate(object, n, string, unit.name, this.visContext.visId, string3, string2);
        }
        return this.defaultFormatter.formatLocalizedDate(object, n, string, unit.name, this.visContext.visId, string3, string2);
    }

    public void copySettingsFrom(FormatContext formatContext) {
        this.integratorNumberFormatter = formatContext.integratorNumberFormatter;
        this.integratorDateFormatter = formatContext.integratorDateFormatter;
        this.integratorStringFormatter = formatContext.integratorStringFormatter;
    }
}

