/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.DataFormatter;
import com.ibm.vis.engine.DateFormatter;
import com.ibm.vis.engine.LocalizedDateFormatter;
import com.ibm.vis.engine.LocalizedNumberFormatter;
import com.ibm.vis.engine.NumberFormatter;
import com.ibm.vis.engine.StringFormatter;
import com.ibm.vis.engine.internal.VisContext;
import java.util.HashMap;
import java.util.Map;

public class FormatWrapper
implements DataFormatter {
    private final Map<String, String> nameMap = new HashMap<String, String>();
    NumberFormatter numberFormatter;
    LocalizedNumberFormatter localizedNumberFormatter;
    StringFormatter stringFormatter;
    DateFormatter dateFormatter;
    LocalizedDateFormatter localizedDateFormatter;
    private final String id;

    public FormatWrapper(VisContext visContext) {
        this.setFromContext(visContext);
        this.id = visContext.visId;
    }

    public void setFromContext(VisContext visContext) {
        this.numberFormatter = visContext.formatContext.integratorNumberFormatter;
        this.localizedNumberFormatter = visContext.formatContext.integratorLocalizedNumberFormatter;
        this.stringFormatter = visContext.formatContext.integratorStringFormatter;
        this.dateFormatter = visContext.formatContext.integratorDateFormatter;
        this.localizedDateFormatter = visContext.formatContext.integratorLocalizedDateFormatter;
    }

    private String resolveFieldId(String string) {
        String string2 = null;
        if (string != null) {
            string2 = this.nameMap.get(string);
            if (string2 == null) {
                string2 = string;
            }
        } else {
            string2 = this.nameMap.get("nullField") != null ? this.nameMap.get("nullField") : null;
        }
        return string2;
    }

    public void addMapping(String string, String string2) {
        this.nameMap.put(string, string2);
    }

    @Override
    public String formatDate(Object object, int n, String string, String string2, String string3) {
        String string4 = null;
        if (this.dateFormatter != null) {
            String string5 = this.resolveFieldId(string);
            string4 = this.dateFormatter.formatDate(object, -1, string5, string2, this.id);
        }
        return string4;
    }

    @Override
    public String formatLocalizedDate(Object object, int n, String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        if (this.localizedDateFormatter != null) {
            String string7 = this.resolveFieldId(string);
            string6 = this.localizedDateFormatter.formatLocalizedDate(object, -1, string7, string2, this.id, string4, string5);
        }
        return string6;
    }

    @Override
    public String formatString(String string, int n, String string2, String string3) {
        String string4 = null;
        if (this.stringFormatter != null) {
            String string5 = this.resolveFieldId(string2);
            string4 = this.stringFormatter.formatString(string, -1, string5, this.id);
        }
        return string4;
    }

    @Override
    public String formatNumber(Number number, int n, String string, double d, double d2, String string2, String string3) {
        String string4 = null;
        if (this.numberFormatter != null) {
            String string5 = this.resolveFieldId(string);
            if (number != null && Double.isNaN(number.doubleValue())) {
                number = null;
            }
            string4 = this.numberFormatter.formatNumber(number, -1, string5, d, d2, string2, this.id);
        }
        return string4;
    }

    @Override
    public String formatLocalizedNumber(Number number, int n, String string, double d, double d2, String string2, String string3, String string4) {
        if (number != null && Double.isNaN(number.doubleValue())) {
            number = null;
        }
        String string5 = null;
        if (this.localizedNumberFormatter != null) {
            String string6 = this.resolveFieldId(string);
            string5 = this.localizedNumberFormatter.formatLocalizedNumber(number, -1, string6, d, d2, string2, this.id, string4);
        }
        return string5;
    }
}

