/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.GradientPaintInfo;
import com.ibm.vis.engine.internal.GradientStop;
import com.ibm.vis.engine.internal.GradientType;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.FillSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Gradient {
    private int type;
    private boolean global;
    private double angle;
    private Object focusX;
    private Object focusY;
    private GradientStop[] stops;
    private ColorNew defaultColor;

    private Gradient(int n, boolean bl, double d, Object object, Object object2, GradientStop[] gradientStopArray, ColorNew colorNew) {
        this.type = n;
        this.global = bl;
        this.angle = d;
        this.focusX = object;
        this.focusY = object2;
        this.stops = gradientStopArray;
        this.defaultColor = colorNew;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof Gradient) {
            Gradient gradient = (Gradient)object;
            return this.type == gradient.type && this.global == gradient.global && ColorUtil.isEqual(this.angle, gradient.angle) && this.focusX.equals(gradient.focusX) && this.focusY.equals(gradient.focusY) && this.stops.equals(gradient.stops) && this.defaultColor.equals(gradient.defaultColor);
        }
        return false;
    }

    public ColorNew[] getGradientColors() {
        if (this.stops == null || this.stops.length == 0) {
            return null;
        }
        ColorNew[] colorNewArray = new ColorNew[this.stops.length];
        for (int i = 0; i < this.stops.length; ++i) {
            colorNewArray[i] = this.stops[i].getColor();
        }
        return colorNewArray;
    }

    public static Gradient makeFromSpec(FillSpec fillSpec, ColorNew colorNew) {
        Gradient gradient = (Gradient)fillSpec.getCachedObject();
        if (gradient == null) {
            int n = GradientType.getByName(fillSpec.type);
            if (n == -1) {
                throw new SpecException("Invalid gradient type \"" + fillSpec.type + "\"", ErrorCode.SPEC_INVALID_VALUE, null);
            }
            boolean bl = false;
            if (fillSpec.global != null) {
                bl = fillSpec.global;
            }
            double d = 0.0;
            if (fillSpec.angle != null) {
                d = fillSpec.angle.doubleValue();
            }
            Object object = null;
            Object object2 = null;
            if (fillSpec.focus != null) {
                object = fillSpec.focus.x;
                object2 = fillSpec.focus.y;
            }
            GradientStop[] gradientStopArray = GradientStop.fromSpec(fillSpec.colors);
            gradient = new Gradient(n, bl, Math.PI * d / 180.0, object, object2, gradientStopArray, colorNew);
            fillSpec.setCachedObject(gradient);
        }
        return gradient;
    }

    public static boolean isValidGradientType(String string) {
        if (string == null) {
            return false;
        }
        return GradientType.getByName(string) != -1;
    }

    public static Gradient modifyGradientWithSolid(Gradient gradient, ColorNew colorNew) {
        Gradient gradient2 = new Gradient(gradient.type, gradient.global, gradient.angle, gradient.focusX, gradient.focusY, GradientStop.modifyGradientWithSolid(gradient.stops, colorNew), gradient.defaultColor);
        return gradient2;
    }

    public static Gradient modifySolidWithGradient(Gradient gradient, ColorNew colorNew) {
        Gradient gradient2 = new Gradient(gradient.type, gradient.global, gradient.angle, gradient.focusX, gradient.focusY, GradientStop.modifySolidWithGradient(gradient.stops, colorNew), gradient.defaultColor);
        return gradient2;
    }

    public GradientPaintInfo makePaintInfo(Geom geom, Geom geom2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        Object object;
        Geom geom3 = geom;
        if (this.global && geom2 != null) {
            geom3 = geom2;
        }
        if (geom3 == null) {
            throw new EngineException("Null local geometry provided to makePaintInfo", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        if (geom3 instanceof Rect) {
            object = (Rect)geom3;
            double d6 = ((Rect)object).getX();
            double d7 = ((Rect)object).getY();
            d5 = ((Rect)object).getWidth();
            d4 = ((Rect)object).getHeight();
            d3 = d6 + d5 / 2.0;
            d2 = d7 + d4 / 2.0;
            d = Math.sqrt((d3 - d6) * (d3 - d6) + (d2 - d7) * (d2 - d7));
        } else if (geom3 instanceof Circle) {
            object = (Circle)geom3;
            d3 = ((Circle)object).getX();
            d2 = ((Circle)object).getY();
            d = ((Circle)object).getR();
            double d8 = d3 - d;
            double d9 = d2 - d;
            d5 = 2.0 * d;
            d4 = 2.0 * d;
        } else {
            throw new EngineException("Geometry provided to makePaintInfo must be a Rect or Circle", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        object = null;
        if (this.type == 1003) {
            if (d < 1.0) {
                object = this.defaultColor;
            }
        } else if (d5 < 1.0 || d4 < 1.0) {
            object = this.defaultColor;
        }
        double d10 = d3;
        double d11 = d2;
        double d12 = d;
        Double d13 = UnitConverter.convertLength(this.focusX, 2.0 * d12, 2.0 * d12);
        if (d13 != null) {
            d10 = d10 - d12 + d13;
        }
        if ((d13 = UnitConverter.convertLength(this.focusY, 2.0 * d12, 2.0 * d12)) != null) {
            d11 = d11 - d12 + d13;
        }
        double d14 = this.angle;
        double d15 = Math.sin(d14);
        double d16 = Math.cos(d14);
        double d17 = d4 * Math.abs(d15) / 2.0 + d5 * Math.abs(d16) / 2.0;
        double d18 = d3 - d16 * d17;
        double d19 = d2 + d15 * d17;
        double d20 = d3 + d16 * d17;
        double d21 = d2 - d15 * d17;
        return new GradientPaintInfo(this.type, this.stops, d18, d19, d20, d21, d10, d11, d12, (ColorNew)object);
    }
}

