/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.GradientStop;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.scenetree.provisional.ColorProperty;
import com.ibm.vis.scenetree.provisional.FillProperty;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GradientPaintInfo
implements FillProperty {
    private final int type;
    private final float[] offsets;
    private final ColorNew[] colors;
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;
    private final double cx;
    private final double cy;
    private final double cr;
    private final ColorNew solidColor;
    private static final float[] emptyOffsets = new float[0];
    private static final ColorNew[] emptyColors = new ColorNew[0];

    public GradientPaintInfo(int n, GradientStop[] gradientStopArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, ColorNew colorNew) {
        this.type = n;
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
        this.cx = d5;
        this.cy = d6;
        this.cr = d7;
        this.solidColor = colorNew;
        if (gradientStopArray == null || gradientStopArray.length == 0) {
            this.offsets = emptyOffsets;
            this.colors = emptyColors;
        } else {
            double[] dArray = new double[gradientStopArray.length];
            for (int i = 0; i < gradientStopArray.length; ++i) {
                dArray[i] = gradientStopArray[i].getOffset();
            }
            int[] nArray = BasicFactory.makeSortOrder(dArray);
            this.offsets = new float[gradientStopArray.length];
            this.colors = new ColorNew[gradientStopArray.length];
            for (int i = 0; i < gradientStopArray.length; ++i) {
                this.offsets[i] = (float)gradientStopArray[nArray[i]].getOffset();
                this.colors[i] = gradientStopArray[nArray[i]].getColor();
            }
        }
    }

    public static GradientPaintInfo makeSolid(ColorNew colorNew) {
        return new GradientPaintInfo(1000, null, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, colorNew);
    }

    @Override
    public final ColorNew getSolid() {
        return this.solidColor;
    }

    @Override
    public ColorProperty[] getGradientColors() {
        if (this.colors != null && this.colors.length > 0) {
            ColorProperty[] colorPropertyArray = new ColorNew[this.colors.length];
            for (int i = 0; i < this.colors.length; ++i) {
                colorPropertyArray[i] = this.colors[i];
            }
            return colorPropertyArray;
        }
        return null;
    }

    public final int getType() {
        return this.type;
    }

    public final float[] getOffsets() {
        return this.offsets;
    }

    public final ColorNew[] getColors() {
        return this.colors;
    }

    public final double getX1() {
        return this.x1;
    }

    public final double getY1() {
        return this.y1;
    }

    public final double getX2() {
        return this.x2;
    }

    public final double getY2() {
        return this.y2;
    }

    public final double getCx() {
        return this.cx;
    }

    public final double getCy() {
        return this.cy;
    }

    public final double getCr() {
        return this.cr;
    }

    public GradientPaintInfo fadeAlpha(double d) {
        ColorNew colorNew = this.solidColor == null ? null : this.solidColor.fadeAlpha(d);
        GradientStop[] gradientStopArray = new GradientStop[this.colors.length];
        for (int i = 0; i < gradientStopArray.length; ++i) {
            gradientStopArray[i] = new GradientStop(this.colors[i].fadeAlpha(d), this.offsets[i]);
        }
        return new GradientPaintInfo(this.type, gradientStopArray, this.x1, this.y1, this.x2, this.y2, this.cx, this.cy, this.cr, colorNew);
    }

    public GradientPaintInfo moveBy(double d, double d2) {
        GradientStop[] gradientStopArray = new GradientStop[this.colors.length];
        for (int i = 0; i < gradientStopArray.length; ++i) {
            gradientStopArray[i] = new GradientStop(this.colors[i], this.offsets[i]);
        }
        return new GradientPaintInfo(this.type, gradientStopArray, this.x1 + d, this.y1 + d2, this.x2 + d, this.y2 + d2, this.cx + d, this.cy + d2, this.cr, this.solidColor);
    }
}

