/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.ColorOffsetSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GradientStop {
    private ColorNew color;
    private double offset;

    public GradientStop(ColorNew colorNew, double d) {
        this.color = colorNew;
        this.offset = d;
    }

    public final double getOffset() {
        return this.offset;
    }

    public final ColorNew getColor() {
        return this.color;
    }

    public static GradientStop[] fromSpec(Object[] objectArray) {
        if (objectArray == null) {
            throw new SpecException("Gradient fill: missing \"colors\"", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        if (objectArray.length == 0) {
            throw new SpecException("Gradient fill: empty \"colors\"", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        int n = objectArray.length;
        GradientStop[] gradientStopArray = new GradientStop[n];
        for (int i = 0; i < n; ++i) {
            ColorOffsetSpec colorOffsetSpec = (ColorOffsetSpec)objectArray[i];
            ColorNew colorNew = colorOffsetSpec.color == null ? ColorUtil.getDefaultFillColor() : ColorUtil.toCanonicalColor(colorOffsetSpec.color);
            double d = colorOffsetSpec.offset == null ? (n == 1 ? 0.0 : (double)i / ((double)n - 1.0)) : colorOffsetSpec.offset.doubleValue();
            if (d < 0.0 || d > 1.0) {
                throw new SpecException("Gradient fill: \"colors\" offsets must be between 0.0 and 1.0", ErrorCode.SPEC_INVALID_VALUE, null);
            }
            gradientStopArray[i] = new GradientStop(colorNew, d);
        }
        return gradientStopArray;
    }

    public static GradientStop[] modifyGradientWithSolid(GradientStop[] gradientStopArray, ColorNew colorNew) {
        GradientStop[] gradientStopArray2 = new GradientStop[gradientStopArray.length];
        for (int i = 0; i < gradientStopArray.length; ++i) {
            gradientStopArray2[i] = new GradientStop(ColorUtil.makeCombinedColor(colorNew, gradientStopArray[i].color), gradientStopArray[i].offset);
        }
        return gradientStopArray2;
    }

    public static GradientStop[] modifySolidWithGradient(GradientStop[] gradientStopArray, ColorNew colorNew) {
        GradientStop[] gradientStopArray2 = new GradientStop[gradientStopArray.length];
        for (int i = 0; i < gradientStopArray.length; ++i) {
            gradientStopArray2[i] = new GradientStop(ColorUtil.makeCombinedColor(gradientStopArray[i].color, colorNew), gradientStopArray[i].offset);
        }
        return gradientStopArray2;
    }
}

