/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.Bounds;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.ContentFrame;
import com.ibm.vis.engine.internal.ImageStyle;
import com.ibm.vis.engine.internal.RenderEffects;
import com.ibm.vis.engine.internal.SceneParts;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.facet.Faceting;
import com.ibm.vis.engine.internal.facet.FacetingFactory;
import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.label.CollisionHandler;
import com.ibm.vis.engine.internal.grammar.layout.SharedLayoutInfo;
import com.ibm.vis.engine.internal.grammar.scale.Axis;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.scale.ScaleGeometry;
import com.ibm.vis.engine.internal.grammar.scale.Tick;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.layout.SizeInfo;
import com.ibm.vis.engine.internal.layout.length.Size;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.FontHelper;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeStyle;
import com.ibm.vis.engine.internal.util.Branch;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.engine.internal.util.SceneTreeUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.internal.accessibility.AccessibilityValidation;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.ElementGroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import com.ibm.vis.spec.internal.AccessibilityStyleSpec;
import com.ibm.vis.spec.internal.AxisSpec;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FacetSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Grammar
extends ContentFrame {
    public final Coordinates coordinates;
    public final Element[] elements;
    public Faceting faceting;
    public final Vis vis;
    public Point graphTranslate;
    public Dim graphSize;
    public final GrammarSpec gSpec;
    private List<Grammar> facetedGrammars;
    private final DataSpec[] dataSpec;
    private SharedLayoutInfo sharedLayoutInfo;
    private Object facetPadding;
    private final CollisionHandler collisionHandler;
    private Rect outerGraphBounds;
    private ScaleGeometry[] geometry;
    protected Shape coordShape;
    private static final double AXIS_DEFAULT_TITLE_SIZE = 12.0;
    private static final double AXIS_LAYOUT_ESTIMATE_TOLERANCE = 0.2;
    private Rect innerCellArea;

    public Rect getInnerCellBounds() {
        Rect rect = this.innerCellArea.copy();
        Rect rect2 = this.getBounds();
        rect.translate(rect2.getX(), rect2.getY());
        if (this.outerGraphBounds != null) {
            rect.translate(-this.outerGraphBounds.getX(), -this.outerGraphBounds.getY());
        }
        return rect;
    }

    public Grammar(BoundsSpec boundsSpec, StyleSpec styleSpec, Vis vis, GrammarSpec grammarSpec, int n) {
        StyleSpec styleSpec2;
        this.setId("G" + n);
        this.collisionHandler = new CollisionHandler(grammarSpec.labelCollisionMethod);
        this.setStyle(styleSpec);
        this.setBackgroundIdSuffixes("Outline", "Out");
        this.setRequiresBackgroundShape(true);
        this.setSpecifiedBounds(new Bounds(boundsSpec, vis.getVisContext().getLogger()));
        this.vis = vis;
        this.dataSpec = vis.getCurrentSpec() == null ? null : vis.getCurrentSpec().data;
        this.gSpec = grammarSpec;
        this.coordinates = Coordinates.createCoordinates(vis, grammarSpec.coordinates);
        ElementsSpec[] elementsSpecArray = this.gSpec.elements;
        if (elementsSpecArray == null) {
            this.elements = new Element[0];
        } else {
            this.elements = new Element[elementsSpecArray.length];
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i] = new Element(elementsSpecArray[i].id, this.vis, this, elementsSpecArray[i], i);
            }
        }
        if (grammarSpec.facet != null && (styleSpec2 = this.getStyle()) != null) {
            styleSpec2 = (StyleSpec)styleSpec2.copy();
            this.facetPadding = styleSpec2.padding;
            styleSpec2.padding = null;
            this.setStyle(styleSpec2);
        }
        this.faceting = FacetingFactory.getFacetingInstance(grammarSpec.facet, this.facetPadding, vis, this.elements);
        this.modifyDataWithAreaUnderCurve();
        this.coordinates.prepareForElements(this.elements, this.faceting);
    }

    private double getAreaUnderCurve() {
        double d = 0.0;
        int n = 0;
        for (Element element : this.elements) {
            double d2 = element.getAreaUnderCurve();
            if (Double.isNaN(d2)) continue;
            d += d2;
            ++n;
        }
        d = n != 0 ? (d /= (double)n) : Double.NaN;
        return d;
    }

    public void modifyDataWithAreaUnderCurve() {
        double d = -1.0;
        ArrayList<String> arrayList = null;
        for (Element element : this.elements) {
            if (element.data == null || !element.data.isPdf() || arrayList != null && arrayList.contains(element.data.id)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            if (d == -1.0) {
                d = this.getAreaUnderCurve();
            }
            element.data.matchDensityWithAreaUnderCurve(d);
            arrayList.add(element.data.id);
        }
    }

    public void replaceSharedScales(Grammar grammar) {
        int n;
        for (n = 0; n < this.coordinates.scales.length; ++n) {
            if (this.coordinates.scales[n].localScale.booleanValue()) continue;
            this.coordinates.scales[n] = grammar.coordinates.scales[n];
        }
        for (n = 0; n < this.elements.length; ++n) {
            Aesthetic[] aestheticArray = this.elements[n].getAesthetics();
            for (int i = 0; i < aestheticArray.length; ++i) {
                if (aestheticArray[i].scale.localScale.booleanValue()) continue;
                aestheticArray[i].scale = grammar.elements[n].getAesthetics()[i].scale;
            }
        }
    }

    public double[] getDataValuesFor(double d, double d2) {
        if (this.graphSize == null) {
            return new double[]{d, d2};
        }
        return this.coordinates.getDataValuesFor(d, d2, this.graphSize);
    }

    public Rect layoutAxesAndInnerCell(Rect rect) {
        boolean bl;
        if (this.vis.getVisContext().isUpdateDataOnly()) {
            if (this.innerCellArea == null) {
                throw new EngineException("Update specification data requires a prior specification set.", ErrorCode.ENGINE_UPDATE_DATA_REQUIRES_PRIOR_SPECIFICATION, null);
            }
            return this.innerCellArea;
        }
        if (this.vis.getVisContext().isUpdateViewport()) {
            this.coordinates.relayoutForNewAxisOutRange();
            if (this.coordinates.axes.length < 1) {
                this.coordinates.relayoutForNewScaleOutRange(this.geometry);
            }
            return this.innerCellArea;
        }
        Rect rect2 = Grammar.makeIntegerRect(rect);
        Rect rect3 = Grammar.makeIntegerRect(rect2);
        if (rect3.getHeight() < 0.0) {
            throw new EngineException("Grammar layout error--area is too small for the shapes within it", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
        }
        if (rect3.getWidth() < 0.0) {
            throw new EngineException("Grammar layout error--area is too narrow for the shapes within it", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
        }
        Rect rect4 = new Rect(rect3.getX(), rect3.getY(), rect3.getWidth(), rect3.getHeight());
        Rect rect5 = this.estimateAvailableAreaForVerticalAxis(this.coordinates, rect3);
        boolean bl2 = !this.coordinates.containsPolar();
        Rect rect6 = this.coordinates.layoutAxes(this, rect5, rect4, 0, this.gSpec.axesOverflow);
        rect6.setY(rect4.getY());
        rect6.setHeight(rect4.getHeight());
        rect6 = this.coordinates.layoutAxes(this, rect6, rect4, 1, this.gSpec.axesOverflow);
        if (Math.abs(rect6.getHeight() - rect5.getHeight()) / rect6.getHeight() > 0.2) {
            rect6.setX(rect4.getX());
            rect6.setWidth(rect4.getWidth());
            rect6 = this.coordinates.layoutAxes(this, rect6, rect4, 0, this.gSpec.axesOverflow);
        }
        if ((rect3 = rect6).getHeight() <= 0.0 || rect3.getWidth() <= 0.0) {
            bl = this.elements.length > 0;
            double d = 0.45;
            if (bl2 && bl) {
                rect6 = this.coordinates.layoutAxes(this, rect4, rect4, 0, this.gSpec.axesOverflow);
                rect6 = this.coordinates.layoutAxes(this, rect6, rect4, 1, this.gSpec.axesOverflow);
                if (rect3.getHeight() <= 0.0) {
                    rect5 = rect6.copy();
                    rect5.setHeight(rect4.getHeight() * d);
                    rect5.setY(rect4.getHeight() - rect5.getHeight());
                    rect5 = this.coordinates.layoutAxes(this, rect5, rect4, 1, this.gSpec.axesOverflow);
                    rect6.setHeight(rect4.getHeight() - rect5.getHeight());
                }
                if (rect3.getWidth() <= 0.0) {
                    rect5 = rect6.copy();
                    rect5.setWidth(rect4.getWidth() * d);
                    rect5.setY(rect4.getHeight() - rect5.getHeight());
                    rect5.setX(rect4.getWidth() - rect5.getWidth());
                    rect5 = this.coordinates.layoutAxes(this, rect5, rect4, 0, this.gSpec.axesOverflow);
                    rect6.setWidth(rect5.getWidth());
                    rect6.setX(rect5.getX());
                }
                if ((rect3 = rect6).getHeight() <= 0.0 || rect3.getWidth() <= 0.0) {
                    throw new EngineException("Grammar layout error--area is too small for the shapes within it", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
                }
            } else {
                if (rect3.getWidth() < 0.0) {
                    rect3.setWidth(0.0);
                }
                if (rect3.getHeight() < 0.0) {
                    rect3.setHeight(0.0);
                }
            }
        }
        if (bl = this.gSpec.axisPadding.booleanValue()) {
            rect3 = this.addAxesAutoPadding(rect3, this.coordinates, rect2);
        }
        Scale[] scaleArray = this.coordinates.scales;
        for (int i = 0; i < scaleArray.length; ++i) {
            Scale scale = scaleArray[i];
            if (scale.getTicks() != null) continue;
            double d = this.coordinates.getDrawnPosition(i) == 0 ? rect3.getHeight() : rect3.getWidth();
            scale.initializeForDisplayableExtent(ScaleGeometry.makeSized(d, false));
        }
        this.innerCellArea = rect3;
        return this.innerCellArea;
    }

    private Rect estimateAvailableAreaForVerticalAxis(Coordinates coordinates, Rect rect) {
        Rect rect2 = rect.copy();
        for (int i = 0; i < coordinates.axes.length; ++i) {
            Axis axis = coordinates.axes[i];
            if (axis.getDrawPosition() != 1 || !axis.isVisible()) continue;
            double d = 0.0;
            AxisSpec axisSpec = axis.getAxisSpec();
            if (axis.isDrawTicks()) {
                double d2 = axis.getTickLabeler().font.getHeight();
                d += axis.estimateTickSize(coordinates.containsTranspose()) + d2 / 6.0;
                d = axisSpec.markStyle != null && axisSpec.markStyle.size != null ? (d += UnitConverter.convertLength(axisSpec.markStyle.size, d2 / 3.0, rect.getHeight()).doubleValue()) : (d += d2 / 3.0);
            }
            if (axisSpec.title != null) {
                d = axisSpec.titleStyle != null && axisSpec.titleStyle.font != null ? (d += FontHelper.makeFromSpec(axisSpec.titleStyle.font, 12.0, this.vis.getVisContext().usesFractionalMetrics()).getHeight()) : (d += 12.0);
            }
            if (!(d < rect2.getHeight())) continue;
            if (axis.isDrawOppositeSide()) {
                rect2.setY(rect2.getY() + d);
            }
            rect2.setHeight(rect2.getHeight() - d);
        }
        return rect2;
    }

    private static Rect makeIntegerRect(Rect rect) {
        double d = Math.ceil(rect.getX());
        double d2 = Math.ceil(rect.getY());
        double d3 = Math.floor(rect.getMaxX());
        double d4 = Math.floor(rect.getMaxY());
        if (d < d3 && d2 < d4) {
            return new Rect(d, d2, d3 - d, d4 - d2);
        }
        return rect.copy();
    }

    private Rect addAxesAutoPadding(Rect rect, Coordinates coordinates, Rect rect2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (rect2.getX() + rect2.getWidth() == this.vis.getSize().getWidth()) {
            d4 = 1.0;
        }
        if (rect2.getY() + rect2.getHeight() == this.vis.getSize().getHeight()) {
            d3 = 1.0;
        }
        if (rect2.getY() == rect.getY()) {
            d = 1.0;
        }
        Insets insets = new Insets(d, d2, d3, d4);
        if (!this.coordinates.containsPolar()) {
            for (Axis axis : coordinates.axes) {
                Insets insets2 = axis.computeExtraSpacingNeededForBounds(rect);
                insets = new Insets(Math.max(insets.top, insets2.top), Math.max(insets.left, insets2.left), Math.max(insets.bottom, insets2.bottom), Math.max(insets.right, insets2.right));
            }
        }
        return insets.insetRectBy(rect);
    }

    private void createShapesInSceneInternal(List<SceneNode> list, Rect rect) {
        Object object;
        Object object3;
        Object object4;
        String string = this.getId();
        Rect rect2 = this.layoutAxesAndInnerCell(rect);
        Point point = rect2.getTopLeft();
        Dim dim = rect2.getExtent();
        SceneParts sceneParts = new SceneParts(list);
        this.graphTranslate = point;
        this.graphSize = dim;
        SceneNodeImpl sceneNodeImpl = this.makeDrawnBounds(dim, this.coordinates.spec.style, point, string + "Coords", this.coordinates, true);
        Rect rect3 = SceneTreeUtil.getBounds(sceneNodeImpl);
        sceneParts.beforeAxis.add(sceneNodeImpl);
        Axis[] axisArray = this.coordinates.axes;
        this.outerGraphBounds = this.getClipBounds();
        sceneParts.outerClipBounds = new Rect(this.outerGraphBounds.getX() - this.graphTranslate.getX(), this.outerGraphBounds.getY() - this.graphTranslate.getY(), this.outerGraphBounds.getWidth(), this.outerGraphBounds.getHeight());
        this.createElementItems(rect2, string, sceneParts, rect3);
        for (int i = axisArray.length - 1; i >= 0; --i) {
            object4 = axisArray[i];
            object3 = ((Axis)object4).getBackgroundShapes(dim, string);
            if (((CompositeSceneNode)object3).getChildrenCount() <= 0) continue;
            ((Axis)object4).defineLocationVisTransform((SceneNode)object3, point, dim);
            if (this.vis.getVisContext().getGenerateAccessibility()) {
                AxisSpec object22 = ((Axis)object4).getAxisSpec();
                object = SceneIdUtil.getBaseIdForSceneNode((SceneNode)object3);
                AccessibilityStyleSpec accessibilityStyleSpec = SceneIdUtil.isGridBandId((String)object) ? null : object22.gridStyle.accessibility;
                AccessibilityValidation.addAccessibility((SceneNode)object3, accessibilityStyleSpec, true);
            }
            sceneParts.beforeAxis.add((SceneNode)object3);
        }
        if (Grammar.hasStroke(this.coordinates.spec.style)) {
            SceneNodeImpl sceneNodeImpl2 = this.makeDrawnBounds(dim, this.coordinates.spec.style, point, string + "InStroke", this.coordinates, false);
            object4 = sceneNodeImpl.getShape();
            object3 = (ShapeStyle)object4.getStyleInfo();
            ((ShapeStyle)object3).setOutline(ColorUtil.TRANSPARENT);
            object4 = sceneNodeImpl2.getShape();
            object3 = (ShapeStyle)object4.getStyleInfo();
            if (object3 != null) {
                RenderEffects renderEffects;
                ((ShapeStyle)object3).setFill(null);
                if (!StyleBuilder.hasTransparentFill(this.coordinates.spec.style) && (renderEffects = (RenderEffects)((ShapeStyle)object3).getEffectProperty()) != null && renderEffects.getShadow() != null) {
                    if (renderEffects.getGlow() != null) {
                        ((ShapeStyle)object3).setEffect(new RenderEffects(renderEffects.getGlow(), null));
                    } else {
                        ((ShapeStyle)object3).setEffect(null);
                    }
                }
            }
            sceneParts.beforeAxis.add(sceneNodeImpl2);
        }
        for (Axis axis : axisArray) {
            if (!axis.isVisible() || ((CompositeSceneNode)(object = axis.getForegroundShapes(dim, string))).getChildrenCount() <= 0) continue;
            axis.defineLocationVisTransform((SceneNode)object, point, dim);
            sceneParts.axis.add((SceneNode)object);
        }
        sceneParts.addBeforeAxesItems();
        sceneParts.addItems(sceneParts.elementsBeforeAxis);
        sceneParts.addAxesItems();
        sceneParts.addItems(sceneParts.elementsAfterAxis);
        sceneParts.addAfterAxesItems();
    }

    private static boolean hasStroke(StyleSpec styleSpec) {
        if (styleSpec == null || styleSpec.stroke == null || styleSpec.stroke.width == null) {
            return false;
        }
        Double d = UnitConverter.convertLength(styleSpec.stroke.width, null, null);
        return d > 1.0;
    }

    private void prepareForNewRows() {
        this.sharedLayoutInfo = null;
    }

    /*
     * WARNING - void declaration
     */
    public void createElementItems(Rect rect, String string, SceneParts sceneParts, Rect rect2) {
        void objectArray;
        Coordinates coordinates = this.coordinates;
        Point point = rect.getTopLeft();
        Dim dim = rect.getExtent();
        ShapeList[] shapeListArray = new ShapeList[this.elements.length];
        double[] dArray = new double[this.elements.length];
        if (this.vis.getVisContext().isUpdateDataOnly()) {
            this.prepareForNewRows();
        }
        boolean i = false;
        while (objectArray < this.elements.length) {
            ShapeList shapeList;
            Element element = this.elements[objectArray];
            shapeListArray[objectArray] = shapeList = element.makeShapes(string, coordinates, dim, (int)objectArray, sceneParts.outerClipBounds, rect2);
            dArray[objectArray] = element.getZOrder();
            ++objectArray;
        }
        this.vis.getLogger().logStartTime(LogComponent.CommonGrammar, "Label Collision");
        this.collisionHandler.moveLabels(shapeListArray, this.coordShape.getBounds(), null, this.vis.getVisContext());
        this.vis.getLogger().logEndTime(LogComponent.CommonGrammar, "Label Collision");
        ShapeList[] shapeListArray2 = shapeListArray;
        int n = shapeListArray2.length;
        for (int j = 0; j < n; ++j) {
            ShapeList shapeList = shapeListArray2[j];
            shapeList.addLabelLines();
        }
        int[] nArray = BasicFactory.makeSortOrder(dArray);
        for (n = 0; n < nArray.length; ++n) {
            Object object;
            ShapeList shapeList = shapeListArray[nArray[n]];
            Element element = this.elements[nArray[n]];
            boolean bl = !this.faceting.isFacetedElement(element);
            int n2 = element.getClip();
            boolean bl2 = element.labelProducers.size() > 0;
            List<Shape> list = shapeList.getAllShapes();
            if (element.isLineWithPoints && n2 == 1) {
                object = this.splitShapes(list);
                SceneNode sceneNode = this.makeShapeGroup(object[0], point, dim, 2, bl, sceneParts.outerClipBounds, element.spec, element, bl2, shapeList);
                sceneParts.elementsBeforeAxis.add(sceneNode);
                Rect rect3 = new Rect(0.0, 0.0, dim.getWidth(), dim.getHeight());
                this.defineElementShapes(sceneParts, point, dim, bl, n2, object[1], rect3, bl2, element, shapeList);
                continue;
            }
            object = this.makeShapeGroup(list, point, dim, n2, bl, sceneParts.outerClipBounds, element.spec, element, bl2, shapeList);
            sceneParts.elementsBeforeAxis.add((SceneNode)object);
        }
    }

    List<Shape>[] splitShapes(List<Shape> list) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        ArrayList<Shape> arrayList2 = new ArrayList<Shape>();
        for (Shape shape : list) {
            if ("line".equals(shape.getElementPart())) {
                arrayList.add(shape);
                continue;
            }
            arrayList2.add(shape);
        }
        return new List[]{arrayList, arrayList2};
    }

    private void defineElementShapes(SceneParts sceneParts, Point point, Dim dim, boolean bl, int n, List<Shape> list, Rect rect, boolean bl2, Element element, ShapeList shapeList) {
        SceneNode sceneNode;
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        ArrayList<Shape> arrayList2 = new ArrayList<Shape>();
        if (bl2) {
            this.splitShapesWithLabelsClipOverlap(list, rect, arrayList, arrayList2);
        } else {
            Grammar.splitShapesClipOverlap(list, rect, arrayList, arrayList2);
        }
        if (arrayList.size() > 0) {
            sceneNode = this.makeShapeGroup(arrayList, point, dim, n, bl, rect, element.spec, element, bl2, shapeList);
            sceneParts.elementsBeforeAxis.add(sceneNode);
        }
        if (arrayList2.size() > 0) {
            sceneNode = this.makeShapeGroup(arrayList2, point, dim, n, bl, sceneParts.outerClipBounds, element.spec, element, bl2, shapeList);
            sceneParts.elementsAfterAxis.add(sceneNode);
        }
    }

    private void cleanupElementGroupNodes(SceneNode sceneNode, int n, boolean bl) {
        if (sceneNode.getClassId() != SceneNodeClassId.ELEMENT_GROUP) {
            return;
        }
        boolean bl2 = false;
        for (SceneNode sceneNode2 : sceneNode.getChildren()) {
            if (sceneNode2.getClassId() == SceneNodeClassId.ELEMENT_GROUP) {
                this.cleanupElementGroupNodes(sceneNode2, n, bl);
                ++n;
                continue;
            }
            bl2 = true;
        }
        if (!bl2) {
            ((ElementGroupSceneNode)sceneNode).removeBaseline();
        }
        if (((ElementGroupSceneNode)sceneNode).getParent() != null) {
            SceneIdUtil.addGroupId((ElementGroupSceneNode)sceneNode, bl ? Integer.toString(n) : null);
        }
    }

    private static void splitShapesClipOverlap(List<Shape> list, Rect rect, List<Shape> list2, List<Shape> list3) {
        for (Shape shape : list) {
            Rect rect2 = shape.getBounds();
            if (rect.intersectsRect(rect2)) {
                list3.add(shape);
                continue;
            }
            list2.add(shape);
        }
    }

    private void splitShapesWithLabelsClipOverlap(List<Shape> list, Rect rect, List<Shape> list2, List<Shape> list3) {
        HashMap<String, List<Shape>> hashMap = new HashMap<String, List<Shape>>();
        for (Shape shape : list) {
            String string;
            String string2 = shape.getID();
            Rect rect2 = shape.getBounds();
            if (string2.indexOf("L") > 0) {
                string = Grammar.getKeyForRows(shape);
                List list4 = (List)hashMap.get(string);
                if (list4 == null) continue;
                list4.add(shape);
                continue;
            }
            if (rect.intersectsRect(rect2)) {
                list3.add(shape);
                string = Grammar.getKeyForRows(shape);
                hashMap.put(string, list3);
                continue;
            }
            list2.add(shape);
            string = Grammar.getKeyForRows(shape);
            hashMap.put(string, list2);
        }
    }

    private SceneNode makeShapeGroup(List<Shape> list, Point point, Dim dim, int n, boolean bl, Rect rect, ElementsSpec elementsSpec, Element element, boolean bl2, ShapeList shapeList) {
        Object object;
        String string = element.isLineWithPoints ? "lineWithPoints" : element.type;
        ElementGroupSceneNode elementGroupSceneNode = (ElementGroupSceneNode)SceneNodeFactory.createElementGroupNode(string, element.baseline);
        elementGroupSceneNode.setHasLabels(element.labelProducers != null && !element.labelProducers.isEmpty());
        List<SceneNode> list2 = elementGroupSceneNode.getChildren();
        Rect rect2 = new Rect(0.0, 0.0, dim.getWidth(), dim.getHeight());
        HashMap<String, ElementGroupSceneNode> hashMap = null;
        String string2 = null;
        boolean bl3 = false;
        if (element.layout != null) {
            object = (JSONObject)element.layout.getAdapter().getSpec().parameters;
            string2 = object != null ? (String)BasicFactory.getItem(object, "layout") : element.layout.getAdapter().getSpec().layout;
        }
        if (string2 != null) {
            bl3 = string2.equals("squarify");
        }
        if (this.coordinates.containsCluster() || this.coordinates.containsStacking() && !this.coordinates.containsPolar() || bl3) {
            hashMap = new HashMap<String, ElementGroupSceneNode>();
            this.populateGroupNodeMap(hashMap, shapeList.createClusterAndStackGroups(), string, element.baseline, elementGroupSceneNode);
        }
        for (Shape shape : list) {
            if (ImageStyle.addImageShape(shape, list2)) continue;
            SceneNodeImpl sceneNodeImpl = shape.createSceneNode();
            if (this.vis.getVisContext().getGenerateAccessibility()) {
                if (shape.getType() == 1009 && elementsSpec.label != null && elementsSpec.label[0].style != null) {
                    AccessibilityValidation.addAccessibility(sceneNodeImpl, elementsSpec.label[0].style.accessibility, false);
                }
                if (shape.isElement() && elementsSpec.style != null) {
                    AccessibilityValidation.addAccessibility(sceneNodeImpl, elementsSpec.style.accessibility, false);
                }
            }
            ElementGroupSceneNode elementGroupSceneNode2 = hashMap == null ? elementGroupSceneNode : this.findParent(elementGroupSceneNode, hashMap, sceneNodeImpl);
            elementGroupSceneNode2.addChild(sceneNodeImpl);
            if (shape.getSpanClipBounds() != null && n != 4) {
                Rect rect3 = shape.getSpanClipBounds();
                Rect rect4 = shape.getBounds();
                if (n == 1 && rect3.intersectsRect(rect4)) {
                    rect3.extendToRect(rect.getBounds());
                }
                sceneNodeImpl.setClipBounds(rect3);
            }
            if (this.shapeIsWithinSceneBounds(shape, rect)) continue;
            sceneNodeImpl.setOutOfBounds(true);
        }
        object = null;
        object = this.coordinates.containsProjection() ? (n == 2 ? this.coordShape.getBounds() : rect.getBounds()) : (n == 2 ? rect2 : rect.getBounds());
        elementGroupSceneNode.setClipBounds((Rect)object);
        elementGroupSceneNode.translate(point.getX(), point.getY());
        if (this.vis.getVisContext().getGenerateAccessibility() && element.spec.style != null && !bl2) {
            AccessibilityValidation.addAccessibility(elementGroupSceneNode, element.spec.style.accessibility, true);
        }
        if (this.coordinates.containsCluster() || this.coordinates.containsStacking() && !this.coordinates.containsPolar() || bl3) {
            int n2 = 0;
            this.cleanupElementGroupNodes(elementGroupSceneNode, n2, bl3);
        }
        elementGroupSceneNode.setLink(element.getLinkTarget());
        return elementGroupSceneNode;
    }

    private boolean shapeIsWithinSceneBounds(Shape shape, Rect rect) {
        Rect rect2 = shape.getBounds();
        return rect.intersectsRect(rect2);
    }

    private ElementGroupSceneNode findParent(ElementGroupSceneNode elementGroupSceneNode, Map<String, ElementGroupSceneNode> map, SceneNode sceneNode) {
        ElementGroupSceneNode elementGroupSceneNode2 = map.get(sceneNode.getId());
        return elementGroupSceneNode2 == null ? elementGroupSceneNode : elementGroupSceneNode2;
    }

    private void populateGroupNodeMap(Map<String, ElementGroupSceneNode> map, Branch branch, String string, Shape shape, ElementGroupSceneNode elementGroupSceneNode) {
        if (branch == null) {
            return;
        }
        if (branch.map != null) {
            Set<String> set = branch.map.keySet();
            Iterator<String> object = set.iterator();
            while (object.hasNext()) {
                String string2 = object.next();
                Branch branch2 = branch.map.get(string2);
                ElementGroupSceneNode elementGroupSceneNode2 = (ElementGroupSceneNode)SceneNodeFactory.createElementGroupNode(string, shape);
                elementGroupSceneNode2.setHasLabels(elementGroupSceneNode.hasLabels());
                elementGroupSceneNode.addChild(elementGroupSceneNode2);
                this.populateGroupNodeMap(map, branch2, string, shape, elementGroupSceneNode2);
            }
        }
        if (branch.list != null) {
            for (Shape shape2 : branch.list) {
                map.put(shape2.getID(), elementGroupSceneNode);
            }
        }
    }

    private void processFacetedGrammar(List<SceneNode> list, Rect rect, DataSpec[] dataSpecArray, VisContext visContext, Dim dim, Dim dim2) {
        Rect rect2 = this.layoutAxesAndInnerCell(rect);
        this.graphTranslate = rect2.getTopLeft();
        this.graphSize = rect2.getExtent();
        for (Element element : this.elements) {
            if (element.extent != null) continue;
            element.extent = dim;
            element.size = element.calculateDefaultShapeSize(element.spec.style);
        }
        list.addAll(this.faceting.makeUnsharedCellsScene(this, dim2, list, dataSpecArray, visContext));
    }

    private static String getKeyForRows(Shape shape) {
        int[] nArray = shape.getRows();
        if (nArray == null) {
            return "ref";
        }
        String string = "|";
        for (int n : nArray) {
            string = string + "|" + n;
        }
        return string;
    }

    public boolean isFacetChart() {
        return this.faceting != FacetingFactory.FACETING_NONE;
    }

    private void createSceneShapes(List<SceneNode> list, DataSpec[] dataSpecArray, VisContext visContext) {
        if (this.faceting != FacetingFactory.FACETING_NONE) {
            this.faceting.initializeFaceting(this.getId(), list, this.getExtent());
            Dim dim = this.faceting.getPanelSize(list, this.getExtent());
            this.processFacetedGrammar(list, Rect.makeRectFromDim(this.getExtent()), dataSpecArray, visContext, dim, dim);
        } else {
            this.createShapesInSceneInternal(list, Rect.makeRectFromDim(this.getExtent()));
        }
    }

    private SceneNodeImpl makeDrawnBounds(Dim dim, StyleSpec styleSpec, Point point, String string, Coordinates coordinates, boolean bl) {
        Shape shape;
        Object object;
        if (coordinates != null && coordinates.isPolygonal(string)) {
            object = Tick.getTicksLocation(coordinates.axes[1].getTicks(), dim, false);
            double[] dArray = new double[((double[])object).length];
            double d = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = d;
            }
            shape = ((double[])object).length == 1 ? ItemBuilder.makeRectangle(object[0], dArray[0], 0.0, 0.0, styleSpec) : ItemBuilder.makePoly((double[])object, dArray, styleSpec);
        } else {
            shape = ItemBuilder.makeRectangle(0.0, 0.0, dim.getWidth(), dim.getHeight(), styleSpec);
        }
        if (coordinates != null) {
            shape = coordinates.modifyShape(shape, dim);
        }
        this.coordShape = shape;
        shape.setID(string);
        ImageStyle.addIconToBackground(shape);
        if (styleSpec == null) {
            shape.setFill(null);
            shape.setOutline(null);
        }
        object = bl ? (Object)SceneNodeFactory.createCoordinatesNode(shape, coordinates.spec) : (Object)shape.createSceneNode();
        ((SceneNodeImpl)object).translate(point.getX(), point.getY());
        return object;
    }

    @Override
    protected List<SceneNode> createContent() {
        List<SceneNode> list = super.createContent();
        VisContext visContext = this.vis.getVisContext();
        this.coordinates.setVisSizeForTransform(this.vis.getSize());
        this.createSceneShapes(list, this.dataSpec, visContext);
        if (this.facetedGrammars != null) {
            for (Grammar grammar : this.facetedGrammars) {
                grammar.faceting.initializeFaceting(this.getId(), list, this.getExtent());
                Dim dim = grammar.faceting.getPanelSize(list, this.getExtent());
                Dim object = this.getExtent();
                grammar.layoutWithBounds(Rect.makeRectFromDim(dim), object, this.getOverallBounds());
                Dim dim2 = grammar.getExtent();
                grammar.processFacetedGrammar(list, Rect.makeRectFromDim(dim2), this.dataSpec, visContext, dim2, dim);
            }
        }
        for (Element element : this.elements) {
            element.cachedShapes = null;
        }
        this.coordinates.cleanupTransforms();
        return list;
    }

    @Override
    public SizeInfo getContentSizeInfo(Double d, Double d2) {
        int n;
        int n2 = n = this.coordinates.spec.dimensions == null ? 0 : this.coordinates.spec.dimensions.length;
        if (n == 1) {
            return this.getContentSizeInfoForOneDChart();
        }
        double d3 = 0.0;
        double d4 = 0.0;
        for (Element element : this.elements) {
            Dim dim = element.getPreferredSize();
            d3 = Math.max(d3, dim.getWidth());
            d4 = Math.max(d4, dim.getHeight());
        }
        if (d3 == 0.0) {
            d3 = 400.0;
        }
        if (d4 == 0.0) {
            d4 = 400.0;
        }
        if (this.coordinates.axes == null || this.coordinates.axes.length == 0) {
            d3 += 2.0;
            d4 += 2.0;
        }
        Size size = Size.makeFixed(d3, d4);
        return new SizeInfo(size, Size.ZERO, Size.UNLIMITED);
    }

    private SizeInfo getContentSizeInfoForOneDChart() {
        boolean bl;
        Dim dim;
        int n;
        double d = 0.0;
        double d2 = 0.0;
        Dim dim2 = this.getBaseGrammarSize();
        Axis[] axisArray = this.coordinates.axes == null || this.coordinates.axes.length == 0 ? null : this.coordinates.axes;
        Dim dim3 = new Dim(0.0, 0.0);
        Dim dim4 = new Dim(0.0, 0.0);
        if (axisArray != null) {
            Rect rect = new Rect(0.0, 0.0, dim2.getWidth(), dim2.getHeight());
            for (n = 0; n < axisArray.length; ++n) {
                axisArray[n].initializeForBounds(rect);
                axisArray[n].adjustLayout(rect, rect);
                dim = axisArray[n].getPreferredSize();
                dim3.setHeight(Math.max(dim3.getHeight(), dim.getHeight()));
                dim3.setWidth(Math.max(dim3.getWidth(), dim.getWidth()));
                dim4.setHeight(dim4.getHeight() + dim.getHeight());
                dim4.setWidth(dim4.getWidth() + dim.getWidth());
                axisArray[n].reset();
            }
        }
        boolean bl2 = this.coordinates.scales[0].isCategorical();
        n = this.coordinates.transposesAxes();
        dim = this.getElementSize(dim2);
        boolean bl3 = bl = this.elements.length > 0 && this.elements[0].type.equals("point");
        if (n != 0) {
            d = bl2 ? Math.max(10.0, dim.getWidth() * (double)this.coordinates.scales[0].getCategoryCount()) : 400.0;
            d = Math.max(dim3.getWidth(), d);
            d2 = bl ? 2.0 * dim.getHeight() + dim4.getHeight() : dim.getHeight() + dim4.getHeight();
        } else {
            d2 = bl2 ? Math.max(10.0, dim.getHeight() * (double)this.coordinates.scales[0].getCategoryCount()) : 400.0;
            d2 = Math.max(d2, dim3.getHeight());
            d = bl ? 2.0 * dim.getWidth() + dim4.getWidth() : dim.getWidth() + dim4.getWidth();
        }
        return new SizeInfo(Size.makeFixed(d, d2), Size.ZERO, Size.UNLIMITED);
    }

    private Dim getBaseGrammarSize() {
        Axis[] axisArray;
        Size size = Size.makeFixed(400.0, 400.0);
        Dim dim = this.modifyWithBoundsSize(size).toDim(Vis.DEFAULT_SIZE, Vis.DEFAULT_SIZE);
        double d = dim.getWidth();
        double d2 = dim.getHeight();
        boolean bl = this.coordinates.scales[0].isCategorical();
        int n = bl ? this.coordinates.scales[0].getCategoryCount() : 0;
        boolean bl2 = this.coordinates.transposesAxes();
        Dim dim2 = this.getElementSize(new Dim(0.0, 0.0));
        if (bl) {
            if (bl2) {
                d = Math.max(10.0, dim2.getWidth() * (double)n);
            } else {
                d2 = Math.max(10.0, dim2.getHeight() * (double)n);
            }
        }
        Axis[] axisArray2 = axisArray = this.coordinates.axes == null || this.coordinates.axes.length == 0 ? null : this.coordinates.axes;
        if (axisArray != null) {
            for (Axis axis : axisArray) {
                double d3;
                double d4 = axis.estimateTickSize(bl2);
                if (!bl) continue;
                if (bl2) {
                    d3 = Math.max(10.0, d4 * (double)n);
                    d = Math.max(d, d3);
                    continue;
                }
                d3 = Math.max(10.0, d4 * (double)n);
                d2 = Math.max(d2, d3);
            }
        }
        return new Dim(d, d2);
    }

    private Dim getElementSize(Dim dim) {
        Dim dim2 = new Dim(0.0, 0.0);
        for (Element element : this.elements) {
            Double d;
            Double d2;
            StyleSpec styleSpec = element.spec.style;
            double d3 = element.type.equals("point") ? 20.0 : (element.type.equals("interval") && !this.coordinates.containsPolar() ? 50.0 : 400.0);
            if (styleSpec != null) {
                d2 = UnitConverter.convertLength(styleSpec.width, dim.getWidth(), dim.getWidth());
                d = UnitConverter.convertLength(styleSpec.height, dim.getHeight(), dim.getHeight());
                if (d2 == null) {
                    d2 = styleSpec.size == null ? d3 : UnitConverter.convertLength(styleSpec.size, dim.getWidth(), dim.getWidth());
                }
                if (d == null) {
                    d = styleSpec.size == null ? d3 : UnitConverter.convertLength(styleSpec.size, dim.getHeight(), dim.getHeight());
                }
            } else {
                d2 = d3;
                d = d3;
            }
            dim2.setWidth(Math.max(dim2.getWidth(), d2));
            dim2.setHeight(Math.max(dim2.getHeight(), d));
        }
        return dim2;
    }

    public void addFacetedGrammar(Grammar grammar) {
        this.getFacetedGrammars().add(grammar);
    }

    public Grammar getFacetTarget() {
        Grammar grammar = null;
        FacetSpec facetSpec = this.faceting.getFacetSpec();
        if (facetSpec != null && facetSpec.targetElement != null) {
            Element element = (Element)this.vis.getByID(facetSpec.targetElement.$ref);
            grammar = element.grammar;
        }
        return grammar;
    }

    public SharedLayoutInfo getSharedLayoutInfo() {
        if (this.sharedLayoutInfo == null) {
            this.sharedLayoutInfo = new SharedLayoutInfo();
        }
        return this.sharedLayoutInfo;
    }

    public boolean isLabelCollisionMethodNone() {
        return this.collisionHandler.isNone();
    }

    public List<Grammar> getFacetedGrammars() {
        if (this.facetedGrammars == null) {
            this.facetedGrammars = new ArrayList<Grammar>();
        }
        return this.facetedGrammars;
    }

    public void setScaleViewport(double[][] dArray) {
        if (this.coordinates.axes.length > 0) {
            for (int i = 0; i < this.coordinates.axes.length; ++i) {
                Axis axis = this.coordinates.axes[i];
                int n = axis.getScaleIndex();
                boolean bl = false;
                if (i >= 0 && i < this.coordinates.scales.length) {
                    bl = this.coordinates.scales[i].isCategorical();
                }
                boolean bl2 = this.coordinates.transposesAxes();
                if (bl && bl2) {
                    axis.getGeometry().setOutRange(Range.makeTransposeInverse(dArray[n][0], dArray[n][1]));
                    continue;
                }
                axis.getGeometry().setOutRange(Range.makeInverse(dArray[n][0], dArray[n][1]));
            }
        } else {
            this.geometry = new ScaleGeometry[this.coordinates.scales.length];
            for (int i = 0; i < this.coordinates.scales.length; ++i) {
                this.geometry[i] = ScaleGeometry.makeUnsized(false);
                boolean bl = false;
                if (i >= 0 && i < this.coordinates.scales.length) {
                    bl = this.coordinates.scales[i].isCategorical();
                }
                boolean bl3 = this.coordinates.transposesAxes();
                if (bl && bl3) {
                    this.geometry[i].setOutRange(Range.makeTransposeInverse(dArray[i][0], dArray[i][1]));
                    continue;
                }
                this.geometry[i].setOutRange(Range.makeInverse(dArray[i][0], dArray[i][1]));
            }
        }
    }

    public void resetScaleOutRanges() {
        for (int i = 0; i < this.coordinates.axes.length; ++i) {
            this.coordinates.axes[i].getGeometry().resetOutRange();
        }
    }

    public int getChartCount() {
        return 1;
    }

    public double[] screenToCoordinates(int n, int n2, int n3) {
        if (n > 0) {
            return null;
        }
        return this.coordinates.screenToCoordinates(n2, n3, this.getInnerCellBounds());
    }

    public boolean pointInChart(int n, int n2, int n3) {
        if (n > 0) {
            return false;
        }
        return this.coordinates.isInViewport(n2, n3, this.getInnerCellBounds());
    }

    public String getCollisionHandlerMethod() {
        return this.collisionHandler.getMethod();
    }
}

