/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.internal.image.FillMethod;
import com.ibm.vis.engine.internal.image.FitMethod;
import com.ibm.vis.engine.internal.image.IconMethod;
import com.ibm.vis.engine.internal.image.ImageFill;
import com.ibm.vis.engine.internal.image.ImageLoadState;
import com.ibm.vis.engine.internal.image.ImageMethod;
import com.ibm.vis.engine.internal.image.ImageResource;
import com.ibm.vis.engine.internal.image.StretchMethod;
import com.ibm.vis.engine.internal.image.TextureMethod;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.ShapeProperty;
import com.ibm.vis.spec.internal.ImageSpec;
import com.ibm.vis.spec.internal.ResourceSpec;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class ImageStyle
implements ShapeProperty {
    private ImageFill imageFill;
    private ImageMethod method;
    private boolean isRenderableImage = false;
    private Shape imageShape = null;

    public ImageStyle(ImageSpec imageSpec) {
        if (imageSpec != null) {
            ImageResource imageResource = ImageResource.create((ResourceSpec)imageSpec.source);
            Rect rect = new Rect(0.0, 0.0, imageResource.getWidth(), imageResource.getHeight());
            String string = "middle";
            if (imageSpec.align != null) {
                string = imageSpec.align;
            }
            String string2 = "middle";
            if (imageSpec.valign != null) {
                string2 = imageSpec.valign;
            }
            double d = 1.0;
            if (imageSpec.alpha != null && (d = imageSpec.alpha.doubleValue()) > 1.0) {
                d = 1.0;
            }
            if ("texture".equals(imageSpec.method)) {
                this.method = new TextureMethod(string, string2);
                this.imageFill = ImageFill.createTexture(imageResource, rect, d, true, 1, 1);
            } else if ("fill".equals(imageSpec.method)) {
                this.method = new FillMethod(string, string2);
                this.imageFill = ImageFill.createFill(imageResource, rect, d, true);
            } else if ("fit".equals(imageSpec.method)) {
                this.method = new FitMethod(string, string2);
                this.imageFill = ImageFill.createFit(imageResource, rect, d, true);
            } else if ("stretch".equals(imageSpec.method)) {
                this.method = new StretchMethod(string, string2);
                this.imageFill = ImageFill.createStretch(imageResource, rect, d, true);
            } else {
                this.method = new IconMethod(string, string2);
                this.imageFill = ImageFill.createIcon(imageResource, rect, d, true, null);
            }
        }
    }

    public double getWidth() {
        return this.imageFill.getWidth();
    }

    public double getHeight() {
        return this.imageFill.getHeight();
    }

    public static boolean addIconToBackground(Shape shape) {
        if (shape.getImage() != null) {
            return shape.getImage().setImagePosition(shape);
        }
        return false;
    }

    public static boolean addImageShape(Shape shape, List<SceneNode> list) {
        ImageStyle.setSchemaImages(shape);
        if (shape.getImage() != null) {
            shape.getImage().setImagePosition(shape);
            list.add(shape.createSceneNode());
            return true;
        }
        return false;
    }

    public void setImageInText() {
        ImageResource imageResource = this.imageFill.getImageResource();
        imageResource.getNativeResource().setImageInText();
    }

    private static void setSchemaImages(Shape shape) {
        Schema schema;
        if (1010 == shape.getType() && (schema = (Schema)shape).getParts() != null) {
            for (Shape shape2 : schema.getParts()) {
                if (shape2.getImage() != null) {
                    shape2.getImage().setImagePosition(shape2);
                }
                ImageStyle.setSchemaImages(shape2);
            }
        }
    }

    public boolean setImagePosition(Shape shape) {
        if (shape != null) {
            this.imageShape = shape;
        }
        this.isRenderableImage = false;
        if (this.imageFill.getAlpha() > 0.0) {
            ImageResource imageResource = this.imageFill.getImageResource();
            if (imageResource.isLoaded()) {
                this.imageFill = this.imageFill.createResizedFill(imageResource.getWidth(), imageResource.getHeight());
                this.setPositionByShape(this.imageShape);
                this.isRenderableImage = true;
            } else {
                if (imageResource.getNativeResource().handlesCallback()) {
                    imageResource.getNativeResource().addImageStyle(this);
                }
                ImageLoadState.fail();
                this.isRenderableImage = false;
            }
        }
        return this.isRenderableImage;
    }

    SceneNodeImpl repositionImage(SceneTree sceneTree) {
        this.setImagePosition(null);
        SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)sceneTree.findNode(this.imageShape.getID());
        sceneNodeImpl.invalidateRenderInfo();
        return sceneNodeImpl;
    }

    private void setPositionByShape(Shape shape) {
        int n = shape.getType();
        if (1010 == n) {
            Schema schema = (Schema)shape;
            Shape[] shapeArray = schema.getParts();
            if (shapeArray != null) {
                int n2 = shapeArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (shapeArray[i].getImage() == null) continue;
                    shapeArray[i].getImage().setImagePosition(shapeArray[i]);
                }
            }
        } else {
            this.imageFill = this.method.modifyFillForShape(this.imageFill, shape);
        }
    }

    public ImageFill createFill() {
        if (!this.isRenderableImage) {
            ImageResource imageResource = this.imageFill.getImageResource();
            this.isRenderableImage = imageResource.isLoaded();
            this.imageFill = this.imageFill.createResizedFill(imageResource.getWidth(), imageResource.getHeight());
        }
        if (this.isRenderableImage && this.imageFill != null && this.imageFill.getAlpha() > 0.0) {
            return this.imageFill;
        }
        return null;
    }

    public ImageFill getImageFill() {
        return this.imageFill;
    }
}

