/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.spec.internal.GlowSpec;
import com.ibm.vis.spec.internal.ShadowSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class RenderEffect {
    private static final double DEFAULT_HORIZONTAL_OFFSET_FOR_SHADOW = 2.0;
    private static final double DEFAULT_VERTICAL_OFFSET_FOR_SHADOW = 2.0;
    private static final double DEFAULT_STDDEV_FOR_SHADOW = 2.0;
    private static final double DEFAULT_STDDEV_FOR_GLOW = 2.0;
    private ColorNew color;
    private double stdDev;
    private double dx;
    private double dy;

    public RenderEffect(ColorNew colorNew, double d, double d2, double d3) {
        this.color = colorNew;
        this.stdDev = d;
        this.dx = d2;
        this.dy = d3;
    }

    public static RenderEffect makeGlowFromStyle(GlowSpec glowSpec) {
        if (glowSpec == null) {
            return null;
        }
        ColorNew colorNew = glowSpec.color == null ? ColorUtil.getDefaultGlowColor() : ColorUtil.toCanonicalColor(glowSpec.color);
        Double d = UnitConverter.convertLength(glowSpec.stdDev, 2.0, 2.0);
        double d2 = d == null ? 2.0 : d;
        return new RenderEffect(colorNew, d2, 0.0, 0.0);
    }

    public static RenderEffect makeShadowFromStyle(ShadowSpec shadowSpec) {
        if (shadowSpec == null) {
            return null;
        }
        ColorNew colorNew = shadowSpec.color == null ? ColorUtil.getDefaultShadowColor() : ColorUtil.toCanonicalColor(shadowSpec.color);
        Double d = UnitConverter.convertLength(shadowSpec.stdDev, 2.0, 2.0);
        double d2 = d == null ? 2.0 : d;
        Double d3 = UnitConverter.convertLength(shadowSpec.dx, 2.0, 2.0);
        double d4 = d3 == null ? 2.0 : d3;
        Double d5 = UnitConverter.convertLength(shadowSpec.dy, 2.0, 2.0);
        double d6 = d5 == null ? 2.0 : d5;
        return new RenderEffect(colorNew, d2, d4, d6);
    }

    public final ColorNew getColor() {
        return this.color;
    }

    public final double getStdDev() {
        return this.stdDev;
    }

    public final double getDX() {
        return this.dx;
    }

    public final double getDY() {
        return this.dy;
    }
}

