/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.scenetree.provisional.ShapeProperty;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Stroke
implements ShapeProperty {
    private double width;
    private String dashing;
    private Object join;
    private String cap;
    private ColorNew color;
    public static final double DEFAULT_STROKE_WIDTH = 1.0;
    public static final Stroke DEFAULT_STROKE = new Stroke(1.0, null, null, null, null);

    public Stroke(double d, String string, Object object, String string2, ColorNew colorNew) {
        this.width = Math.max(0.0, d);
        this.dashing = string;
        this.join = object;
        this.cap = string2;
        this.color = colorNew;
    }

    public final double getWidth() {
        return this.width;
    }

    public final String getDashing() {
        return this.dashing;
    }

    public final Object getJoin() {
        return this.join;
    }

    public final String getCap() {
        return this.cap;
    }

    public final ColorNew getColor() {
        return this.color;
    }

    public final Stroke createStrokeOfWidth(double d) {
        if (d == this.width) {
            return this;
        }
        return new Stroke(d, this.dashing, this.join, this.cap, this.color);
    }

    public final Stroke createStrokeWithDashing(String string) {
        if (string == null && this.dashing == null || string != null && string.equals(this.dashing)) {
            return this;
        }
        return new Stroke(this.width, string, this.join, this.cap, this.color);
    }

    public final Stroke createStrokeWithColor(ColorNew colorNew) {
        return new Stroke(this.width, this.dashing, this.join, this.cap, colorNew);
    }
}

