/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.DateFormatter;
import com.ibm.vis.engine.LocalizedDateFormatter;
import com.ibm.vis.engine.LocalizedNumberFormatter;
import com.ibm.vis.engine.NumberFormatter;
import com.ibm.vis.engine.StringFormatter;
import com.ibm.vis.engine.configuration.ContrastParameters;
import com.ibm.vis.engine.dataProviderService.internal.DataProviderListenerImpl;
import com.ibm.vis.engine.internal.AsynchCompleteSpecAction;
import com.ibm.vis.engine.internal.AsynchDataAction;
import com.ibm.vis.engine.internal.Bounds;
import com.ibm.vis.engine.internal.ContentFrame;
import com.ibm.vis.engine.internal.DefaultVisContentFrame;
import com.ibm.vis.engine.internal.FormatWrapper;
import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.LegendPosition;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.VisTitleFrame;
import com.ibm.vis.engine.internal.asynchronous.AsynchAction;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.extension.ExtensionManager;
import com.ibm.vis.engine.internal.extension.RAVEExtensionManager;
import com.ibm.vis.engine.internal.grammar.coordinate.CoordinateTransform;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.legend.LegendMaker;
import com.ibm.vis.engine.internal.migration.spec.SpecMigration;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.MappedJSONObject;
import com.ibm.vis.engine.internal.nativeImpl.SpecUtil;
import com.ibm.vis.engine.internal.nativeImpl.ThreadHelper;
import com.ibm.vis.engine.internal.nativeImpl.VisState;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.scenemodifier.LocalizationSceneModifier;
import com.ibm.vis.engine.internal.scenemodifier.MirrorSceneModifier;
import com.ibm.vis.engine.internal.scenemodifier.VisibilitySceneModifier;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.engine.internal.util.Version;
import com.ibm.vis.engine.internal.util.VisJSONUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.internal.Viewport;
import com.ibm.vis.internal.accessibility.AccessibilitySceneModifier;
import com.ibm.vis.internal.accessibility.ContrastConverter;
import com.ibm.vis.internal.json.Diagnostic;
import com.ibm.vis.internal.json.SchemaValidator;
import com.ibm.vis.internal.json.SpecValidator;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.Logger;
import com.ibm.vis.monitor.internal.LoggerImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.CustomOptionsSpec;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.LocalizationSpec;
import com.ibm.vis.spec.internal.ResourceSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.TitleSpec;
import com.ibm.vis.spec.internal.TransformSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Vis
implements VisInterface {
    private static final String VERSION = "version";
    public static final Version CURRENT_VERSION = Version.parseVersion("7.2");
    private Dim size;
    private Data[] data;
    private Grammar[] grammar;
    private VisJSONSpec currentSpec;
    private final HashMap<String, IdentifiableItem> items = new HashMap();
    private final VisContext visContext;
    private LocalizationSpec defaultLocalizationSpec;
    private final LocalizationSceneModifier localizationModifier;
    private final VisibilitySceneModifier visibilityModifier;
    private final MirrorSceneModifier mirrorModifier;
    private JSONObject origSpec;
    private boolean specValidationEnabled = true;
    private Version specDefaultVersion = null;
    private DefaultVisContentFrame mainFrame = new DefaultVisContentFrame();
    private final StyleSpec BACK_STYLE = new StyleSpec();
    private Vis legendVis;
    private ThreadHelper threadHelper;
    public static final Dim DEFAULT_SIZE = new Dim(500.0, 400.0);
    public CustomOptionsSpec customConfig = null;
    private Map<String, Row[]> zoomDataCache;
    private boolean settingScaleInteractively = false;
    private Shape defenderScrollUnit;
    private Map<String, JSONObject> resourceDefinitions;
    private boolean dataProviderFailed = false;
    AsynchDataAction dataAction = null;
    AsynchAction specAction = null;
    private double[][] startingViewport = null;
    private boolean initializePanFlag = false;

    public Vis(String string) {
        this.visContext = new VisContext(this, string);
        this.localizationModifier = new LocalizationSceneModifier();
        this.visibilityModifier = new VisibilitySceneModifier();
        this.mirrorModifier = new MirrorSceneModifier();
        this.zoomDataCache = new HashMap<String, Row[]>();
    }

    public void setSpecAction(AsynchAction asynchAction) {
        this.specAction = asynchAction;
    }

    public static Vis createVisWithContext(VisContext visContext) {
        Vis vis = new Vis(null);
        vis.copyVisContextSettings(visContext);
        return vis;
    }

    public void dispose() {
        if (this.threadHelper != null) {
            this.threadHelper.dispose();
        }
        if (this.legendVis != null) {
            this.legendVis.dispose();
            this.legendVis = null;
        }
        if (this.zoomDataCache != null) {
            this.zoomDataCache.clear();
            this.zoomDataCache = null;
        }
        if (this.resourceDefinitions != null) {
            this.resourceDefinitions.clear();
            this.resourceDefinitions = null;
        }
        this.visContext.dispose();
    }

    public static ExtensionManager getGlobalExtensionManager() {
        return RAVEExtensionManager.INSTANCE;
    }

    @Override
    public void copyVisContextSettings(VisContext visContext) {
        this.visContext.copySettings(visContext);
    }

    @Override
    public IdentifiableItem getByID(String string) {
        return this.items.get(string);
    }

    @Override
    public String getDescription() {
        if (this.getCurrentSpec() == null) {
            return null;
        }
        return this.getCurrentSpec().description;
    }

    @Override
    public VisState recreateSceneTree(Dim dim, VisState visState, int n) {
        this.getVisContext().setConstructionFlags(n);
        SceneTree sceneTree = this.makeSceneTreeImpl(dim);
        if (visState == null) {
            visState = new VisState(this);
        }
        visState.setSceneTree(sceneTree);
        return visState;
    }

    @Override
    public VisState makeSceneTree(Dim dim, VisState visState) {
        int n = this.initializePanFlag ? 4 : 0;
        return this.recreateSceneTree(dim, visState, n);
    }

    public SceneTree makeSceneTreeImpl(Dim dim) {
        Object object;
        if (this.getLogger().hasListeners()) {
            this.getLogger().info(LogComponent.CommonGrammar, "Making Scene Tree");
        }
        if (this.visContext.needsRelayout()) {
            this.size = this.findVisSize(dim);
            object = new Rect(0.0, 0.0, this.size.getWidth(), this.size.getHeight());
            this.mainFrame.layoutWithBounds((Rect)object, this.size, this.size);
        }
        object = new SceneTree();
        ((SceneTree)object).setSize(this.size);
        ThreadHelper threadHelper = this.getThreadHelper();
        if (!threadHelper.isInterrupted()) {
            ((SceneTree)object).getRoot().getChildren().add(this.makeBack(this.size));
            if (!threadHelper.isInterrupted()) {
                this.getVisContext().setFacetIndex(0);
                if (this.getLogger().hasListeners()) {
                    this.getLogger().info(LogComponent.CommonGrammar, "Create Shapes in Scene");
                }
                this.mainFrame.createShapesInScene(((SceneTree)object).getRoot().getChildren());
                if (!threadHelper.isInterrupted()) {
                    this.localizationModifier.setContext(this.getVisContext());
                    this.localizationModifier.modifyScene((SceneTree)object);
                    this.visibilityModifier.modifyScene((SceneTree)object);
                    if (this.getMirror()) {
                        if (Vis.isMapChart(this.currentSpec)) {
                            throw new EngineException("Mirroring is not supported for geo maps.", ErrorCode.ENGINE_MIRRORING_UNSUPPORTED_FOR_GEO_JSON, null);
                        }
                        this.mirrorModifier.setWidth(this.size.getWidth());
                        this.mirrorModifier.modifyScene((SceneTree)object);
                    }
                    if (!threadHelper.isInterrupted() && this.getVisContext().getGenerateAccessibility()) {
                        AccessibilitySceneModifier accessibilitySceneModifier = new AccessibilitySceneModifier(this);
                        accessibilitySceneModifier.modifyScene((SceneTree)object);
                    }
                }
            }
        }
        this.visContext.resetConstructionFlags();
        this.visContext.cleanUp();
        return ((SceneTree)object).finalizeTree();
    }

    private static boolean isMapChart(VisJSONSpec visJSONSpec) {
        if (visJSONSpec != null && visJSONSpec.grammar != null) {
            for (GrammarSpec grammarSpec : visJSONSpec.grammar) {
                if (grammarSpec.coordinates != null && grammarSpec.coordinates.transforms != null) {
                    for (MappedJSONObject mappedJSONObject : grammarSpec.coordinates.transforms) {
                        if (!"projection".equals(((TransformSpec)mappedJSONObject).type)) continue;
                        return true;
                    }
                }
                if (grammarSpec.elements == null) continue;
                for (MappedJSONObject mappedJSONObject : grammarSpec.elements) {
                    if (!"custom".equals(((ElementsSpec)mappedJSONObject).type)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void replaceSharedScalesInGrammar(Object object, int n) {
        this.getGrammar()[n].replaceSharedScales((Grammar)object);
    }

    @Override
    public Dim getSize() {
        if (this.size != null) {
            return this.size;
        }
        return DEFAULT_SIZE;
    }

    @Override
    public void put(String string, IdentifiableItem identifiableItem) {
        if (string == null || identifiableItem == null) {
            throw new IllegalArgumentException();
        }
        if (this.items.containsKey(string)) {
            String string2 = "Duplicate ID " + string + " found.  All fields named \"id\" must be unique throughout a single VizJSON Specification";
            if (this.getLogger().hasListeners()) {
                this.getLogger().grammarError(LogComponent.CommonGrammar, string2);
            }
            throw new IllegalArgumentException(string2);
        }
        this.items.put(string, identifiableItem);
    }

    @Override
    public void remove(String string) {
        this.items.remove(string);
    }

    @Override
    public VisState read(InputStream inputStream) throws IOException {
        JSONObject jSONObject = BasicFactory.parse(inputStream);
        return this.setSpecification(jSONObject);
    }

    private JSONObject preprocessExpandResourceReferences(JSONObject jSONObject) {
        Map<String, JSONObject> map = VisJSONUtil.getResourceDefinitions(jSONObject);
        if (map != null && map.size() > 0) {
            this.setResourceDefinitions(map);
            VisJSONUtil.expandReferences(jSONObject, map);
        }
        return jSONObject;
    }

    private VisJSONSpec jsonToSpec(JSONObject jSONObject) {
        JSONObject jSONObject2 = jSONObject;
        jSONObject2 = this.preprocessExpandResourceReferences(jSONObject2);
        VisJSONSpec visJSONSpec = SpecUtil.fromJSONObject(jSONObject2);
        ContrastConverter contrastConverter = this.visContext.getContrastConverter();
        if (contrastConverter != null) {
            contrastConverter.convert(visJSONSpec);
        }
        return visJSONSpec;
    }

    @Override
    public VisState setSpecification(JSONObject jSONObject) {
        this.origSpec = jSONObject;
        JSONObject jSONObject2 = this.migrateAndValidateSpec(jSONObject);
        VisJSONSpec visJSONSpec = this.jsonToSpec(jSONObject2);
        return this.setTypedSpecification(visJSONSpec);
    }

    public JSONObject getOrigSpecification() {
        return this.origSpec;
    }

    @Override
    public VisState updateSpecificationData(JSONArray jSONArray) {
        this.updateSpecificationDataInternal(jSONArray);
        return new VisState(this);
    }

    @Override
    public JSONObject getSpecification() {
        if (this.currentSpec == null) {
            return null;
        }
        return this.currentSpec.toJSON();
    }

    @Override
    public void setNumberFormatter(NumberFormatter numberFormatter) {
        this.getVisContext().formatContext.integratorNumberFormatter = numberFormatter;
    }

    @Override
    public NumberFormatter getNumberFormatter() {
        return this.getVisContext().formatContext.integratorNumberFormatter;
    }

    @Override
    public void setLocalizedNumberFormatter(LocalizedNumberFormatter localizedNumberFormatter) {
        this.getVisContext().formatContext.integratorLocalizedNumberFormatter = localizedNumberFormatter;
    }

    @Override
    public LocalizedNumberFormatter getLocalizedNumberFormatter() {
        return this.getVisContext().formatContext.integratorLocalizedNumberFormatter;
    }

    @Override
    public void setDateFormatter(DateFormatter dateFormatter) {
        this.getVisContext().formatContext.integratorDateFormatter = dateFormatter;
    }

    @Override
    public DateFormatter getDateFormatter() {
        return this.getVisContext().formatContext.integratorDateFormatter;
    }

    @Override
    public void setLocalizedDateFormatter(LocalizedDateFormatter localizedDateFormatter) {
        this.getVisContext().formatContext.integratorLocalizedDateFormatter = localizedDateFormatter;
    }

    @Override
    public LocalizedDateFormatter getLocalizedDateFormatter() {
        return this.getVisContext().formatContext.integratorLocalizedDateFormatter;
    }

    @Override
    public void setStringFormatter(StringFormatter stringFormatter) {
        this.getVisContext().formatContext.integratorStringFormatter = stringFormatter;
    }

    @Override
    public StringFormatter getStringFormatter() {
        return this.getVisContext().formatContext.integratorStringFormatter;
    }

    @Override
    public void setLogger(Logger logger) {
        if (!(logger instanceof LoggerImpl)) {
            throw new EngineException("The Logger passed to setLogger is not the RAVE logger implementation (do not implement the Logger interface)", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        this.visContext.setLogger((LoggerImpl)logger);
    }

    @Override
    public LoggerImpl getLogger() {
        return this.getVisContext().getLogger();
    }

    @Override
    public int[] getMatchingRows(String[] stringArray, double[] dArray, boolean bl) {
        if (dArray == null || stringArray == null || dArray.length != stringArray.length) {
            return null;
        }
        if (stringArray.length == 0) {
            if (this.getData().length == 0) {
                return null;
            }
            int n = this.getData()[0].rows.length;
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
            return nArray;
        }
        Field[] fieldArray = new Field[stringArray.length];
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = (Field)this.getByID(stringArray[i]);
            if (field == null) {
                return null;
            }
            fieldArray[i] = field;
            if (i <= 0 || fieldArray[i].data == fieldArray[0].data) continue;
            return null;
        }
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            Row[] rowArray = field.data.rows;
            IntPrimitiveArrayList intPrimitiveArrayList2 = Vis.findRowsFromFieldWithValue(rowArray, field.getIndex(), dArray[i]);
            if (intPrimitiveArrayList.size() > 0 && intPrimitiveArrayList2.size() > 0 && !bl) {
                return null;
            }
            for (int j = 0; j < intPrimitiveArrayList2.size(); ++j) {
                intPrimitiveArrayList.add(intPrimitiveArrayList2.get(j));
            }
        }
        int[] nArray = new int[intPrimitiveArrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = intPrimitiveArrayList.get(i);
        }
        return nArray;
    }

    @Override
    public Integer getMatchingData(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        for (String string : stringArray) {
            Field field = (Field)this.getByID(string);
            if (field == null) continue;
            String string2 = field.data.id;
            return this.getDataIndex(string2);
        }
        return null;
    }

    @Override
    public Integer getDataIndex(String string) {
        if (string != null) {
            for (int i = 0; i < this.getData().length; ++i) {
                if (!string.equals(this.getData()[i].id)) continue;
                return i;
            }
        }
        return null;
    }

    @Override
    public Data getDataByID(String string) {
        if (string != null) {
            for (int i = 0; i < this.getData().length; ++i) {
                if (!string.equals(this.getData()[i].id)) continue;
                return this.getData()[i];
            }
        }
        return null;
    }

    private static IntPrimitiveArrayList findRowsFromFieldWithValue(Row[] rowArray, int n, double d) {
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        for (int i = 0; i < rowArray.length; ++i) {
            Row row = rowArray[i];
            Double d2 = row.data[n];
            if (d2 == null || d2 != d) continue;
            intPrimitiveArrayList.add(i);
        }
        return intPrimitiveArrayList;
    }

    @Override
    public void setDefaultLocalization(LocalizationSpec localizationSpec) {
        this.defaultLocalizationSpec = localizationSpec;
        this.getVisContext().setLocalization(this.getLocalizationSpec());
    }

    LocalizationSpec getLocalizationSpec() {
        if (this.getCurrentSpec() == null || this.getCurrentSpec().localization == null) {
            return this.defaultLocalizationSpec;
        }
        LocalizationSpec localizationSpec = this.getCurrentSpec().localization;
        if (this.defaultLocalizationSpec != null) {
            if (localizationSpec.baseTextDirection == null) {
                localizationSpec.baseTextDirection = this.defaultLocalizationSpec.baseTextDirection;
            }
            if (localizationSpec.nationalShaping == null) {
                localizationSpec.nationalShaping = this.defaultLocalizationSpec.nationalShaping;
            }
            if (localizationSpec.contextualShaping == null) {
                localizationSpec.contextualShaping = this.defaultLocalizationSpec.contextualShaping;
            }
            if (localizationSpec.mirror == null) {
                localizationSpec.mirror = this.defaultLocalizationSpec.mirror;
            }
            if (localizationSpec.locale == null) {
                localizationSpec.locale = this.defaultLocalizationSpec.locale;
            }
        }
        return localizationSpec;
    }

    @Override
    public final void setSpecificationValidation(boolean bl) {
        this.specValidationEnabled = bl;
    }

    @Override
    public final boolean getSpecificationValidation() {
        return this.specValidationEnabled;
    }

    @Override
    public final void setSpecificationDefaultVersion(Version version) {
        this.specDefaultVersion = version;
    }

    @Override
    public final Version getSpecificationDefaultVersion() {
        return this.specDefaultVersion;
    }

    @Override
    public final Data[] getData() {
        return this.data;
    }

    @Override
    public final void setData(Data[] dataArray) {
        this.data = dataArray;
    }

    public final Grammar[] getGrammar() {
        return this.grammar;
    }

    public final void setGrammar(Grammar[] grammarArray) {
        this.grammar = grammarArray;
    }

    @Override
    public final VisJSONSpec getCurrentSpec() {
        return this.currentSpec;
    }

    @Override
    public final void setCurrentSpec(VisJSONSpec visJSONSpec) {
        this.currentSpec = visJSONSpec;
    }

    @Override
    public final VisContext getVisContext() {
        return this.visContext;
    }

    @Override
    public final void setMirror(boolean bl) {
        LocalizationSpec localizationSpec = new LocalizationSpec();
        localizationSpec.mirror = bl ? Boolean.TRUE : Boolean.FALSE;
        this.setDefaultLocalization(localizationSpec);
    }

    @Override
    public final boolean getMirror() {
        LocalizationSpec localizationSpec = this.getLocalizationSpec();
        if (localizationSpec == null) {
            return false;
        }
        Boolean bl = localizationSpec.mirror;
        return bl != null && bl != false;
    }

    private SceneNode makeBack(Dim dim) {
        Shape shape = ItemBuilder.makeRectangle(0.0, 0.0, dim.getWidth(), dim.getHeight(), this.BACK_STYLE);
        shape.setFill(null);
        shape.setID("Back");
        return shape.createSceneNode();
    }

    private Dim findVisSize(Dim dim) {
        Double d;
        Double d2;
        Dim dim2 = null;
        if (this.currentSpec.size != null) {
            d2 = UnitConverter.convertLength(this.currentSpec.size.width, null, null);
            if (d2 == null) {
                if (dim != null) {
                    d2 = dim.getWidth();
                } else {
                    dim2 = this.mainFrame.getSizeInfo(null, null).getPreferred().toDim(DEFAULT_SIZE, DEFAULT_SIZE);
                    d2 = dim2.getWidth();
                    if (d2 == null) {
                        d2 = UnitConverter.convertLength(null, dim2.getWidth(), dim2.getWidth());
                    }
                }
            }
            if ((d = UnitConverter.convertLength(this.currentSpec.size.height, null, null)) == null) {
                if (dim != null) {
                    d = dim.getHeight();
                } else {
                    dim2 = this.mainFrame.getSizeInfo(d2, null).getPreferred().toDim(DEFAULT_SIZE, DEFAULT_SIZE);
                    d = dim2.getHeight();
                    if (d == null) {
                        d = UnitConverter.convertLength(null, dim2.getHeight(), dim2.getHeight());
                    }
                }
            }
        } else if (dim != null) {
            d2 = dim.getWidth();
            d = dim.getHeight();
        } else {
            dim2 = this.mainFrame.getSizeInfo(null, null).getPreferred().toDim(DEFAULT_SIZE, DEFAULT_SIZE);
            d2 = dim2.getWidth();
            dim2 = this.mainFrame.getSizeInfo(d2, null).getPreferred().toDim(DEFAULT_SIZE, DEFAULT_SIZE);
            d = dim2.getHeight();
        }
        dim2 = new Dim(d2, d);
        if (!MathUtil.deltaEquals(this.getSize().getWidth(), d2) || !MathUtil.deltaEquals(this.getSize().getHeight(), d)) {
            this.changeTransformBounds(dim2);
        }
        return dim2;
    }

    private void changeTransformBounds(Dim dim) {
        if (this.grammar != null) {
            for (Grammar grammar : this.grammar) {
                CoordinateTransform[] coordinateTransformArray = grammar.coordinates.getTransforms();
                if (coordinateTransformArray == null) continue;
                for (CoordinateTransform coordinateTransform : coordinateTransformArray) {
                    if (!coordinateTransform.isProjection()) continue;
                    coordinateTransform.updateBounds(dim);
                }
            }
        }
    }

    public JSONObject migrateAndValidateSpec(JSONObject jSONObject) {
        JSONObject jSONObject2;
        block5: {
            jSONObject2 = (JSONObject)BasicFactory.deepClone(jSONObject);
            boolean bl = false;
            Version version = this.ensureSpecVersion(jSONObject2);
            bl = this.validateSpec(jSONObject2);
            if (version != null && !CURRENT_VERSION.equals(version)) {
                if (this.getLogger().hasListeners()) {
                    this.getLogger().info(LogComponent.CommonGrammar, "Migrating Specification");
                }
                try {
                    if (SpecMigration.getInstance().migrate((JSONArtifact)jSONObject2) || bl) {
                        this.validateSpec(jSONObject2);
                    }
                }
                catch (IOException iOException) {
                    if (!this.getLogger().hasListeners()) break block5;
                    this.getLogger().info(LogComponent.CommonGrammar, "There was a problem migrating the specification: " + iOException);
                }
            }
        }
        return jSONObject2;
    }

    private Version ensureSpecVersion(JSONObject jSONObject) {
        Version version = Vis.parseSpecVersion(jSONObject);
        if (version == null && this.specDefaultVersion != null) {
            BasicFactory.put(jSONObject, VERSION, this.specDefaultVersion.toString());
            version = this.specDefaultVersion;
        }
        return version;
    }

    private static Version parseSpecVersion(JSONObject jSONObject) {
        Version version = null;
        if (BasicFactory.containsKey(jSONObject, VERSION)) {
            version = Version.parseVersion((String)BasicFactory.getItem(jSONObject, VERSION));
        }
        return version;
    }

    private boolean validateSpec(JSONObject jSONObject) {
        boolean bl = false;
        if (this.specValidationEnabled) {
            this.ensureSpecVersion(jSONObject);
            Diagnostic diagnostic = SpecValidator.validate(jSONObject);
            if (this.getLogger().hasListeners()) {
                for (Diagnostic diagnostic2 : Diagnostic.flatten(diagnostic)) {
                    if (diagnostic2.getMessage() == null) continue;
                    if (diagnostic2.getSeverity() == 1) {
                        this.getLogger().warning(LogComponent.CommonGrammar, diagnostic2.getSource() + ": " + diagnostic2.getMessage());
                        continue;
                    }
                    if (diagnostic2.getSeverity() != 2) continue;
                    this.getLogger().error(LogComponent.CommonGrammar, diagnostic2.getSource() + ": " + diagnostic2.getMessage());
                }
            }
            if (diagnostic.getSeverity() == 1) {
                SchemaValidator.fixWarnings(diagnostic);
                bl = diagnostic.getCode() == 1001;
            } else if (diagnostic.getSeverity() == 2) {
                throw new SpecException(diagnostic.toString(), ErrorCode.SPEC_INVALID_VALUE, diagnostic.getSource());
            }
        }
        return bl;
    }

    @Override
    public Diagnostic validateSpecification(JSONObject jSONObject) {
        return SpecValidator.validateWith(jSONObject, this.specDefaultVersion);
    }

    @Override
    public VisState setTypedSpecification(VisJSONSpec visJSONSpec) {
        this.setTypedSpecificationInternal(visJSONSpec);
        return new VisState(this);
    }

    public void setStartingViewport(double[][] dArray, boolean bl) {
        this.startingViewport = dArray;
        Vis.checkViewportArray("Vis#setStartingViewport", this.startingViewport);
        this.initializePanFlag = bl;
    }

    public static void checkViewportArray(String string, double[][] dArray) {
        if (dArray == null) {
            throw new EngineException("Illegal viewport in " + string + ": null array", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == null) {
                throw new EngineException("Illegal viewport in " + string + ": null array entry " + i, ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
            }
            if (dArray[i].length != 2) {
                throw new EngineException("Illegal viewport in " + string + ": array entry " + i + " does not have two values", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
            }
            if (dArray[i][0] == dArray[i][1]) {
                throw new EngineException("Illegal viewport argument in " + string + ": array entry " + i + " has two equal values", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
            }
            if (!(Math.abs(dArray[i][1] - dArray[i][0]) < 0.05)) continue;
            if (dArray[i][1] > dArray[i][0]) {
                if (dArray[i][0] + 0.05 > 1.0) {
                    dArray[i][0] = dArray[i][1] - 0.05;
                    continue;
                }
                dArray[i][1] = dArray[i][0] + 0.05;
                continue;
            }
            if (dArray[i][1] + 0.05 > 1.0) {
                dArray[i][1] = dArray[i][0] - 0.05;
                continue;
            }
            dArray[i][0] = dArray[i][1] + 0.05;
        }
    }

    public void resetStartingViewport() {
        this.startingViewport = null;
        this.initializePanFlag = false;
    }

    public double[][] getStartingViewport() {
        return this.startingViewport;
    }

    public boolean getPanFlag() {
        return this.initializePanFlag;
    }

    public VisState updateViewports(Viewport[] viewportArray, boolean bl, boolean bl2) {
        this.applyViewport(viewportArray);
        int n = 2;
        if (bl) {
            n |= 4;
        }
        if (bl2) {
            n |= 8;
        }
        return this.recreateSceneTree(null, null, n);
    }

    public void applyViewport(Viewport[] viewportArray) {
        for (int i = 0; i < this.grammar.length; ++i) {
            if (viewportArray != null) {
                this.grammar[i].setScaleViewport(viewportArray[i].getViewport());
                continue;
            }
            this.grammar[i].resetScaleOutRanges();
        }
    }

    public void setTypedSpecificationInternal(VisJSONSpec visJSONSpec) {
        if (this.getLogger().hasListeners()) {
            this.getLogger().info(LogComponent.CommonGrammar, "Setting Specification");
        }
        this.customConfig = null;
        this.currentSpec = visJSONSpec;
        this.items.clear();
        this.visContext.setLocalization(this.getLocalizationSpec());
        if (this.currentSpec.version == null) {
            this.currentSpec.version = "7.2";
        }
        this.setupFrames();
        if (this.getThreadHelper().isInterrupted()) {
            return;
        }
        if (this.size == null) {
            this.size = this.findVisSize(new Dim(500.0, 400.0));
        }
        if (this.getThreadHelper().isInterrupted()) {
            return;
        }
        this.data = null;
        this.dataAction = null;
        this.dataProviderFailed = false;
        DataSpec[] dataSpecArray = this.currentSpec.data;
        if (this.getSpecificationValidation()) {
            Vis.validateValuesInRows(dataSpecArray);
        }
        if (this.hasAsynchronousData() && this.specAction != null) {
            this.dataAction = new AsynchDataAction(this);
            this.specAction.addAction(this.dataAction);
            AsynchCompleteSpecAction asynchCompleteSpecAction = new AsynchCompleteSpecAction(this);
            this.specAction.addAction(asynchCompleteSpecAction);
        } else if (this.makeData()) {
            this.completeSetSpec();
        }
    }

    boolean completeSetSpec() {
        try {
            Viewport[] viewportArray;
            this.makeTitles();
            this.makeGrammars();
            if (this.getThreadHelper().isInterrupted()) {
                return false;
            }
            if (this.currentSpec.legends != null) {
                this.makeLegends();
            } else if (this.legendVis != null) {
                viewportArray = BasicFactory.createJSONObject();
                BasicFactory.put(viewportArray, VERSION, "7.2");
                this.legendVis.setSpecification((JSONObject)viewportArray);
            }
            if (this.startingViewport != null && this.currentSpec.grammar.length > 0) {
                viewportArray = new Viewport[this.currentSpec.grammar.length];
                for (int i = 0; i < this.currentSpec.grammar.length; ++i) {
                    viewportArray[i] = new Viewport(this.currentSpec.grammar[i]);
                    viewportArray[i].setViewport(this.startingViewport);
                }
                this.applyViewport(viewportArray);
            }
        }
        catch (SpecException specException) {
            if (this.dataAction == null) {
                throw specException;
            }
            if (this.getLogger().hasListeners()) {
                this.getLogger().error(LogComponent.CommonGrammar, "There was a problem completing the specification: " + specException.getMessage());
            }
            return false;
        }
        return true;
    }

    private boolean hasAsynchronousData() {
        if (this.currentSpec.data != null) {
            for (int i = 0; i < this.currentSpec.data.length; ++i) {
                if (this.currentSpec.data[i].provider == null) continue;
                return true;
            }
        }
        return false;
    }

    public void updateSpecificationDataInternal(JSONArray jSONArray) {
        this.refreshDataRows(jSONArray);
        for (Grammar grammar : this.grammar) {
            grammar.modifyDataWithAreaUnderCurve();
            grammar.faceting.specificationDataUpdated();
        }
        Vis.validateValuesInRows(this.currentSpec.data);
    }

    private void refreshDataRows(JSONArray jSONArray) {
        if (this.data == null) {
            throw new EngineException("Update specification data requires a prior specification set.", ErrorCode.ENGINE_UPDATE_DATA_REQUIRES_PRIOR_SPECIFICATION, null);
        }
        for (int i = 0; i < this.data.length; ++i) {
            JSONObject jSONObject = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
            DataSpec dataSpec = this.currentSpec.data[i];
            JSONArray jSONArray2 = (JSONArray)BasicFactory.getItem(jSONObject, "rows");
            dataSpec.rows = MappedJSONObject.toDoubleArray(jSONArray2);
            this.data[i].refreshRows(dataSpec);
        }
    }

    private void makeTitles() {
        if (this.currentSpec.titles == null) {
            return;
        }
        int n = 0;
        for (TitleSpec titleSpec : this.currentSpec.titles) {
            VisTitleFrame visTitleFrame = new VisTitleFrame(this, titleSpec, n++);
            if ("footnote".equals(titleSpec.type)) {
                this.mainFrame.addFootnote(visTitleFrame);
                continue;
            }
            this.mainFrame.addTitle(visTitleFrame);
        }
    }

    private void setupFrames() {
        this.mainFrame = new DefaultVisContentFrame();
        this.mainFrame.setStyle(this.currentSpec.style);
    }

    private void makeGrammars() {
        this.grammar = new Grammar[this.currentSpec.grammar != null ? this.currentSpec.grammar.length : 0];
        for (int i = 0; i < this.grammar.length; ++i) {
            BoundsSpec boundsSpec = this.currentSpec.grammar[i].bounds;
            StyleSpec styleSpec = this.currentSpec.grammar[i].style;
            this.grammar[i] = new Grammar(boundsSpec, styleSpec, this, this.currentSpec.grammar[i], i);
            Grammar grammar = this.grammar[i].getFacetTarget();
            if (grammar != null) {
                grammar.addFacetedGrammar(this.grammar[i]);
                continue;
            }
            this.mainFrame.addGrammar(this.grammar[i]);
        }
        for (Grammar grammar : this.grammar) {
            grammar.modifyDataWithAreaUnderCurve();
        }
    }

    private boolean makeData() {
        if (this.dataProviderFailed) {
            return false;
        }
        if (this.data == null) {
            this.data = this.currentSpec.data == null ? new Data[]{} : new Data[this.currentSpec.data.length];
        }
        try {
            for (int i = 0; i < this.data.length; ++i) {
                DataProviderListenerImpl dataProviderListenerImpl = null;
                if (this.currentSpec.data[i].provider != null) {
                    dataProviderListenerImpl = new DataProviderListenerImpl(this.dataAction);
                    this.currentSpec.data[i].setCachedObject(dataProviderListenerImpl);
                }
                this.data[i] = new Data(this.currentSpec.data[i].id, this, this.currentSpec.data[i], i);
                if (dataProviderListenerImpl == null) continue;
                dataProviderListenerImpl.checkFailure();
            }
        }
        catch (Exception exception) {
            if (!this.dataProviderFailed) {
                this.dataProviderFailed = true;
                if (this.getLogger().hasListeners()) {
                    this.getLogger().error(LogComponent.CommonGrammar, "There was a problem creating the data: " + exception.getMessage());
                }
                for (int i = 0; i < this.currentSpec.data.length; ++i) {
                    if (this.currentSpec.data[i].provider == null) continue;
                    this.currentSpec.data[i].fields = null;
                    this.currentSpec.data[i].rows = null;
                }
            }
            return false;
        }
        return true;
    }

    boolean makeDataCallback() {
        boolean bl = true;
        if (this.dataProviderFailed) {
            return false;
        }
        if (this.data == null) {
            if (!this.makeData()) {
                return false;
            }
            if (this.dataProviderFailed) {
                return false;
            }
        }
        try {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.currentSpec.data[i].provider != null) {
                    DataProviderListenerImpl dataProviderListenerImpl = (DataProviderListenerImpl)this.currentSpec.data[i].getCachedObject();
                    dataProviderListenerImpl.checkFailure();
                    if (dataProviderListenerImpl.isReady() && !this.data[i].isComplete()) {
                        this.data[i].continueDataCreation();
                    }
                }
                if (this.data[i].isComplete()) continue;
                bl = false;
            }
        }
        catch (Exception exception) {
            if (!this.dataProviderFailed) {
                this.dataProviderFailed = true;
                if (this.getLogger().hasListeners()) {
                    this.getLogger().error(LogComponent.CommonGrammar, "There was a problem creating the data: " + exception.getMessage());
                }
                for (int i = 0; i < this.currentSpec.data.length; ++i) {
                    if (this.currentSpec.data[i].provider == null) continue;
                    this.currentSpec.data[i].fields = null;
                    this.currentSpec.data[i].rows = null;
                }
            }
            bl = false;
        }
        return bl;
    }

    boolean getDataProviderFailed() {
        return this.dataProviderFailed;
    }

    private static void validateValuesInRows(DataSpec[] dataSpecArray) {
        if (dataSpecArray != null) {
            for (int i = 0; i < dataSpecArray.length; ++i) {
                Vis.validateDataRowsValues(dataSpecArray[i]);
            }
        }
    }

    private static void validateDataRowsValues(DataSpec dataSpec) {
        if (dataSpec != null && dataSpec.fields != null && dataSpec.rows != null) {
            int n = dataSpec.fields.length;
            double[][] dArray = dataSpec.rows;
            if (dArray != null && dArray.length > 0) {
                for (int i = 0; i < dArray.length; ++i) {
                    Vis.checkRowLength(n, dArray[i]);
                    Vis.checkCategoricalValueIsValid(dataSpec, i, dArray[i]);
                }
            }
        }
    }

    private static void checkRowLength(int n, double[] dArray) {
        if (n != dArray.length) {
            throw new SpecException("Invalid number of values specified in row.", ErrorCode.SPEC_INVALID_NUMBER_OF_VALUES_IN_ROW, null);
        }
    }

    private static void checkCategoricalValueIsValid(DataSpec dataSpec, int n, double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            String[] stringArray = dataSpec.fields[i].categories;
            if (stringArray == null || Double.isNaN(d)) continue;
            if (!BasicFactory.isInteger(d)) {
                throw new SpecException("Invalid categorical data value \"" + d + "\" in row " + (n + 1) + ", field " + (i + 1) + " .", ErrorCode.SPEC_INVALID_DECIMAL_VALUE_FOR_CATEGORICAL_FIELD, null);
            }
            if (BasicFactory.isNumber(d) && !Vis.isValidValue(d, stringArray)) {
                throw new SpecException("Invalid categorical data value \"" + d + "\" in row " + (n + 1) + ", field " + (i + 1) + " .", ErrorCode.SPEC_INVALID_VALUE_FOR_CATEGORICAL_FIELD, null);
            }
            dArray[i] = d;
        }
    }

    private static boolean isValidValue(double d, String[] stringArray) {
        int n = (int)Math.round(d);
        return n >= 0 && n < stringArray.length;
    }

    @Override
    public Dim getExtent() {
        return this.mainFrame.getExtent();
    }

    private void makeLegends() {
        if (this.currentSpec.legends == null) {
            return;
        }
        LegendSpec[] legendSpecArray = this.currentSpec.legends;
        if (legendSpecArray.length == 0) {
            legendSpecArray = new LegendSpec[]{new LegendSpec()};
        }
        LegendMaker legendMaker = new LegendMaker();
        for (LegendSpec legendSpec : this.currentSpec.legends) {
            List<ContentFrame> list = legendMaker.makeLegendFrames(this, this.currentSpec.legends, legendSpec);
            for (ContentFrame contentFrame : list) {
                Object object = legendSpec.location;
                Bounds bounds = null;
                if (object != null && object instanceof BoundsSpec) {
                    bounds = new Bounds((BoundsSpec)object, this.getLogger());
                }
                if (bounds != null && bounds.isDefinedPositionalBounds()) {
                    contentFrame.setSpecifiedBounds(bounds);
                    this.mainFrame.addFloatingLegend(contentFrame);
                    continue;
                }
                this.mainFrame.addLegend(contentFrame, this.getLegendPosition(legendSpec));
            }
        }
    }

    public LegendPosition getLegendPosition(LegendSpec legendSpec) {
        if (BasicFactory.isString(legendSpec.location)) {
            return LegendPosition.valueOf((String)legendSpec.location);
        }
        return LegendPosition.valueOf(this.currentSpec.legendPosition);
    }

    public final Vis getLegendVis() {
        NumberFormatter numberFormatter;
        if (this.legendVis == null) {
            this.legendVis = Vis.createVisWithContext(this.visContext);
        }
        if ((numberFormatter = this.legendVis.getVisContext().formatContext.integratorNumberFormatter) instanceof FormatWrapper) {
            ((FormatWrapper)numberFormatter).setFromContext(this.visContext);
        } else {
            FormatWrapper formatWrapper = new FormatWrapper(this.visContext);
            this.legendVis.setNumberFormatter(formatWrapper);
            this.legendVis.setLocalizedNumberFormatter(formatWrapper);
            this.legendVis.setDateFormatter(formatWrapper);
            this.legendVis.setLocalizedDateFormatter(formatWrapper);
            this.legendVis.setStringFormatter(formatWrapper);
        }
        return this.legendVis;
    }

    public final ThreadHelper getThreadHelper() {
        if (this.threadHelper == null) {
            this.threadHelper = new ThreadHelper(null, this.getLogger());
        }
        return this.threadHelper;
    }

    public final void setThreadHelper(ThreadHelper threadHelper) {
        this.threadHelper = threadHelper;
    }

    @Deprecated
    public void setHighContrast(boolean bl) {
        if (bl) {
            ContrastParameters contrastParameters = new ContrastParameters();
            contrastParameters.setFontMagnification(1.2);
            this.setContrast(contrastParameters);
        } else {
            this.setContrast(null);
        }
    }

    @Deprecated
    public JSONObject getCurrentJSON() {
        return this.getSpecification();
    }

    public void updateLegendVis() {
        if (this.legendVis != null) {
            this.legendVis.copyVisContextSettings(this.visContext);
        }
    }

    public final void cacheZoomData(String string, Row[] rowArray) {
        this.zoomDataCache.put(string, rowArray);
    }

    public final void clearZoomData() {
        this.zoomDataCache.clear();
    }

    public final Row[] retrieveZoomData(String string) {
        return this.zoomDataCache.get(string);
    }

    public final void cacheDefenderScrollUnit(Shape shape) {
        this.defenderScrollUnit = shape;
    }

    public final Shape retrieveDefenderScrollUnit() {
        return this.defenderScrollUnit;
    }

    public void setScaleInteractively(boolean bl) {
        this.settingScaleInteractively = bl;
    }

    public boolean getSettingScaleInteractively() {
        return this.settingScaleInteractively;
    }

    public void setResourceDefinitions(Map<String, JSONObject> map) {
        this.resourceDefinitions = map;
    }

    @Override
    public ResourceSpec getResourceDefinition(String string) {
        if (this.resourceDefinitions != null && this.resourceDefinitions.containsKey(string)) {
            ResourceSpec resourceSpec = (ResourceSpec)SpecUtil.createSpecObject(this.resourceDefinitions.get(string), "ResourceSpec");
            return resourceSpec;
        }
        throw new EngineException("Resource reference '" + string + "' is undefined", ErrorCode.DATA_INVALID, null);
    }

    @Override
    public boolean setContrast(ContrastParameters contrastParameters) {
        return this.visContext.setContrast(contrastParameters);
    }

    @Override
    public ContrastParameters getContrast() {
        ContrastConverter contrastConverter = this.visContext.getContrastConverter();
        return contrastConverter == null ? null : contrastConverter.getContrastParameters();
    }
}

