/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.configuration.ContrastParameters;
import com.ibm.vis.engine.internal.AccessibilityOptions;
import com.ibm.vis.engine.internal.FormatContext;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.globalization.NumericShapingInfo;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.LocaleUtil;
import com.ibm.vis.engine.internal.nativeImpl.PlatformDefaults;
import com.ibm.vis.engine.internal.scene.FontMetricType;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.internal.accessibility.ContrastConverter;
import com.ibm.vis.monitor.internal.LoggerImpl;
import com.ibm.vis.spec.internal.LocalizationSpec;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class VisContext {
    public final String visId;
    private VisInterface parentVis;
    private LoggerImpl logContext;
    private String locale;
    private LocalizationSpec localizationSpec;
    private NumericShapingInfo shapingInfo;
    public final FormatContext formatContext;
    private double minimumFontSize = -1.0;
    private boolean tooltipsForTruncatedText;
    private boolean generateAccessibility;
    private ContrastConverter contrastConverter;
    private boolean usesFractionalMetrics = PlatformDefaults.usesFractionalMetrics;
    private Unit zoomUnit;
    private int facetIndex;
    private Map<String, Object> existing = new HashMap<String, Object>();
    private Map<String, Object> keepForNextTime = new HashMap<String, Object>();
    public static final int CF_NONE = 0;
    public static final int CF_UPDATE_DATA = 1;
    public static final int CF_UPDATE_VIEWPORT = 2;
    public static final int CF_GENERATE_ALL_TICKS = 4;
    public static final int CF_VIEWPORT_PAN = 8;
    public boolean handlingSceneTree = false;
    private int constructionFlags = 0;

    public VisContext(VisInterface visInterface, String string) {
        this.parentVis = visInterface;
        this.visId = string;
        this.logContext = new LoggerImpl();
        this.formatContext = new FormatContext(this);
        this.generateAccessibility = false;
        this.minimumFontSize = AccessibilityOptions.getInstance().getMinimumFontSize();
        this.tooltipsForTruncatedText = true;
    }

    public void dispose() {
        this.parentVis = null;
    }

    public VisInterface getParentVis() {
        return this.parentVis;
    }

    public final LoggerImpl getLogger() {
        return this.logContext;
    }

    public final void setLogger(LoggerImpl loggerImpl) {
        if (loggerImpl != null) {
            this.logContext = loggerImpl;
        }
    }

    public void setLocalization(LocalizationSpec localizationSpec) {
        if (this.localizationSpec == localizationSpec) {
            return;
        }
        this.localizationSpec = localizationSpec;
        this.locale = LocaleUtil.getLocaleStringFromSpec(localizationSpec);
        if (this.locale != null && !LocaleUtil.isValid(this.locale)) {
            String string = "Invalid Locale String.";
            throw new SpecException(string, ErrorCode.SPEC_INVALID_PARAMETERS, null);
        }
        this.updateNumericalShapingInfo();
    }

    public final LocalizationSpec getLocalizationSpec() {
        return this.localizationSpec;
    }

    public final String getLocale() {
        return this.locale;
    }

    public final void setGenerateAccessibility(boolean bl) {
        this.generateAccessibility = bl;
    }

    public final boolean getGenerateAccessibility() {
        return this.generateAccessibility;
    }

    private void updateNumericalShapingInfo() {
        this.shapingInfo = NumericShapingInfo.getShapingInfo(this.localizationSpec);
    }

    public NumericShapingInfo getNumericShapingInfo() {
        if (this.shapingInfo == null) {
            this.shapingInfo = NumericShapingInfo.getShapingInfo(this.localizationSpec);
        }
        return this.shapingInfo;
    }

    @Deprecated
    public void setNativeStringMeasuring(String string) {
        if (string.equals(FontMetricType.NATIVE.toString())) {
            this.setFontMetricType(FontMetricType.NATIVE);
        } else if (string.equals(FontMetricType.PRECOMPUTED.toString())) {
            this.setFontMetricType(FontMetricType.PRECOMPUTED);
        }
    }

    public Double getMinimumFontSize() {
        return this.minimumFontSize > 0.0 ? Double.valueOf(this.minimumFontSize) : null;
    }

    public void setMinimumFontSize(Double d) {
        this.minimumFontSize = d == null ? -1.0 : d;
    }

    public void setFacetIndex(int n) {
        this.facetIndex = n;
    }

    public int getFacetIndex() {
        return this.facetIndex;
    }

    public final boolean getTooltipsForTruncatedText() {
        return this.tooltipsForTruncatedText;
    }

    public final void setTooltipsForTruncatedText(boolean bl) {
        this.tooltipsForTruncatedText = bl;
    }

    public final Unit getZoomUnit() {
        return this.zoomUnit;
    }

    public final void setZoomUnit(Unit unit) {
        this.zoomUnit = unit;
    }

    public final FontMetricType getFontMetricType() {
        return PlatformDefaults.fontMetricType;
    }

    public final void setFontMetricType(FontMetricType fontMetricType) {
        PlatformDefaults.fontMetricType = fontMetricType;
    }

    public final boolean usesFractionalMetrics() {
        return this.usesFractionalMetrics;
    }

    public final void setUsesFractionalMetrics(boolean bl) {
        this.usesFractionalMetrics = bl;
    }

    public final ContrastConverter getContrastConverter() {
        return this.contrastConverter;
    }

    public final boolean setContrast(ContrastParameters contrastParameters) {
        if (contrastParameters == null && this.contrastConverter == null) {
            return false;
        }
        if (contrastParameters == null) {
            this.contrastConverter = null;
            return true;
        }
        this.contrastConverter = new ContrastConverter(contrastParameters, this.minimumFontSize);
        return true;
    }

    public void copySettings(VisContext visContext) {
        this.formatContext.copySettingsFrom(visContext.formatContext);
        this.logContext = visContext.logContext;
        this.tooltipsForTruncatedText = visContext.tooltipsForTruncatedText;
        this.contrastConverter = visContext.contrastConverter;
        this.setMinimumFontSize(visContext.getMinimumFontSize());
    }

    public boolean needsRelayout() {
        return (this.constructionFlags & 2) == 0 && (this.constructionFlags & 1) == 0;
    }

    public final void setConstructionFlag(int n, boolean bl) {
        this.constructionFlags = bl ? (this.constructionFlags |= n) : (this.constructionFlags &= ~n);
    }

    public void setConstructionFlags(int n) {
        this.constructionFlags = n;
    }

    public boolean isUpdateViewport() {
        return (this.constructionFlags & 2) != 0;
    }

    public boolean isViewportPan() {
        return (this.constructionFlags & 8) != 0;
    }

    public boolean isGenerateAllTicks() {
        return (this.constructionFlags & 4) != 0;
    }

    public boolean isUpdateDataOnly() {
        return (this.constructionFlags & 1) != 0;
    }

    public void resetConstructionFlags() {
        this.constructionFlags = 0;
    }

    public boolean isHandlingSceneTree() {
        return this.handlingSceneTree;
    }

    public void setHandlingSceneTree(boolean bl) {
        this.handlingSceneTree = bl;
    }

    public void putStoredItem(String string, Object object) {
        this.existing.put(string, object);
        this.keepForNextTime.put(string, object);
    }

    public Object getStoredItem(String string) {
        Object object = this.existing.get(string);
        if (object != null) {
            this.keepForNextTime.put(string, object);
        }
        return object;
    }

    public void cleanUp() {
        this.existing = this.keepForNextTime;
        this.keepForNextTime = new HashMap<String, Object>();
    }
}

