/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.ContentFrame;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.layout.SizeInfo;
import com.ibm.vis.engine.internal.layout.length.Size;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.internal.accessibility.AccessibilityValidation;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.TitleSpec;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class VisTitleFrame
extends ContentFrame {
    private final VisContext context;
    private final StyleSpec textStyle;
    private final StyleSpec backgroundStyle;
    private final LabelProducer textProducer;
    private final String TITLE_ID = "D";
    private final Object[] textArray;
    private Dim size;

    VisTitleFrame(Vis vis, TitleSpec titleSpec, int n) {
        this.context = vis.getVisContext();
        this.setId("" + n);
        this.textArray = titleSpec.content;
        this.textStyle = titleSpec.style != null ? titleSpec.style : new StyleSpec();
        this.backgroundStyle = titleSpec.backgroundStyle != null ? titleSpec.backgroundStyle : new StyleSpec();
        this.textProducer = LabelProducer.makeSimpleInside(vis, this.textStyle, "middle", "middle", this.backgroundStyle);
    }

    @Override
    public List<SceneNode> createContent() {
        List<SceneNode> list = super.createContent();
        if (!this.hasText()) {
            return list;
        }
        Shape shape = ShapeFactory2.CreateRect(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight());
        Text text = this.textProducer.makeLabel(this.textArray, shape);
        if (text != null) {
            if (!this.textProducer.align.equals("middle")) {
                this.offsetRotatedTitle(text, this.getAngle(this.textProducer.angle), this.textProducer.align, this.size);
            }
            text.setUsesBackgroundPlaque(true);
            String string = "D" + this.getId();
            text.setID(string);
            SceneNodeImpl sceneNodeImpl = text.createSceneNode();
            sceneNodeImpl.setType(SceneNodeType.TITLE);
            List<SceneNode> list2 = sceneNodeImpl.getChildren();
            if (list2.size() > 0) {
                sceneNodeImpl.setId(string);
                if (list2.size() == 2) {
                    ((SceneNodeImpl)list2.get(0)).setId(string + "T" + this.getId() + "LB0");
                    ((SceneNodeImpl)list2.get(1)).setId(string + "T" + this.getId());
                } else if (list2.size() == 1) {
                    ((SceneNodeImpl)list2.get(0)).setId(string + "T" + this.getId());
                }
            }
            if (this.context.getGenerateAccessibility() && this.textStyle != null) {
                AccessibilityValidation.addAccessibility(sceneNodeImpl, this.textStyle.accessibility, false);
            }
            list.add(sceneNodeImpl);
        }
        return list;
    }

    @Override
    public SizeInfo getContentSizeInfo(Double d, Double d2) {
        SizeInfo sizeInfo = super.getContentSizeInfo(d, d2);
        double d3 = this.textProducer.font.getHeight();
        Size size = sizeInfo.getMinimum();
        Dim dim = null;
        if (this.hasText()) {
            Rect rect;
            Object object;
            if (this.textProducer.getPadding() == null) {
                this.textProducer.setPadding(new Insets(d3 / 4.0, d3 / 4.0, d3 / 4.0, d3 / 4.0));
            }
            TextContent textContent = this.textProducer.makeTextContent(this.textArray, -1);
            if (d == null) {
                dim = this.textProducer.calculateLabelSize(textContent);
            } else {
                if (d2 == null) {
                    d2 = Double.MAX_VALUE;
                }
                object = new Rect(0.0, 0.0, d, d2);
                rect = this.textProducer.getPadding().insetRect((Rect)object);
                Dim dim2 = rect.getExtent();
                dim = this.textProducer.calculateConstrainedLabelSize(textContent, dim2);
            }
            object = this.getRotation();
            if (object != null) {
                rect = Shape.transformBounds(Rect.makeRectFromDim(dim), (Affine)object);
                dim = new Dim(rect.getWidth(), rect.getHeight());
            }
            this.size = dim;
            dim = this.expandByPadding(dim);
            size = Size.makeFixed(dim.getWidth() + 1.0, dim.getHeight() + 1.0);
        }
        return new SizeInfo(size, Size.ZERO, Size.UNLIMITED);
    }

    private Dim expandByPadding(Dim dim) {
        Rect rect = Rect.makeRectFromDim(dim);
        Rect rect2 = this.textProducer.getPadding().expandRect(rect);
        return rect2.getExtent();
    }

    private Affine getRotation() {
        double d = this.getAngle(this.textProducer.angle);
        if (d == 0.0) {
            return null;
        }
        return Affine.makeRotation(d, 0.0, 0.0);
    }

    protected double getAngle(Object object) {
        if (object == null) {
            return 0.0;
        }
        if (BasicFactory.isNumber(object)) {
            double d = ((Number)object).doubleValue();
            return d * Math.PI / 180.0;
        }
        return this.getTangentAngle(this.textProducer.align, this.textProducer.valign);
    }

    public double getTangentAngle(String string, String string2) {
        if ("start".equals(string)) {
            return -1.5707963267948966;
        }
        if ("end".equals(string)) {
            return 1.5707963267948966;
        }
        return 0.0;
    }

    private boolean hasText() {
        return this.textArray != null;
    }

    protected void offsetRotatedTitle(Text text, double d, String string, Dim dim) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = MathUtil.r(Math.cos(d));
        double d5 = MathUtil.r(Math.sin(d));
        double d6 = text.getHeight();
        double d7 = text.calculateTextWidth();
        if (string.equals("start")) {
            if (d5 > 0.0 && d5 < 1.0) {
                if (d4 > 0.0 && d4 < 1.0) {
                    d3 -= dim.getHeight() / 2.0 - d4 * d6 / 2.0;
                    d2 += d5 * d6 / 2.0;
                }
                if (d4 > -1.0 && d4 < 0.0) {
                    d3 -= dim.getHeight() / 2.0 - MathUtil.r(Math.sin(d - 1.5707963267948966)) * d6 / 2.0;
                    d2 += dim.getWidth() - MathUtil.r(Math.cos(d - 1.5707963267948966)) * d6 / 2.0;
                }
            }
            if (d5 > -1.0 && d5 < 0.0) {
                if (d4 > 0.0 && d4 < 1.0) {
                    d3 += dim.getHeight() / 2.0 - MathUtil.r(Math.sin(d - 4.71238898038469)) * d6 / 2.0;
                    d2 += MathUtil.r(Math.cos(d - 4.71238898038469)) * d6 / 2.0;
                }
                if (d4 > -1.0 && d4 < 0.0) {
                    d3 += dim.getHeight() / 2.0 - MathUtil.r(Math.sin(4.71238898038469 - d)) * d6 / 2.0;
                    d2 += dim.getWidth() - MathUtil.r(Math.cos(4.71238898038469 - d)) * d6 / 2.0;
                }
            }
        }
        if (string.equals("end")) {
            if (d5 > 0.0 && d5 < 1.0) {
                if (d4 > 0.0 && d4 < 1.0) {
                    d3 += dim.getHeight() / 2.0 - d4 * d6 / 2.0;
                    d2 -= d5 * d6 / 2.0;
                }
                if (d4 > -1.0 && d4 < 0.0) {
                    d3 += dim.getHeight() / 2.0 - MathUtil.r(Math.sin(d - 1.5707963267948966)) * d6 / 2.0;
                    d2 -= dim.getWidth() - MathUtil.r(Math.cos(d - 1.5707963267948966)) * d6 / 2.0;
                }
            }
            if (d5 > -1.0 && d5 < 0.0) {
                if (d4 > 0.0 && d4 < 1.0) {
                    d3 -= dim.getHeight() / 2.0 - MathUtil.r(Math.sin(d - 4.71238898038469)) * d6 / 2.0;
                    d2 -= MathUtil.r(Math.cos(d - 4.71238898038469)) * d6 / 2.0;
                }
                if (d4 > -1.0 && d4 < 0.0) {
                    d3 -= dim.getHeight() / 2.0 - MathUtil.r(Math.sin(4.71238898038469 - d)) * d6 / 2.0;
                    d2 -= dim.getWidth() - MathUtil.r(Math.cos(4.71238898038469 - d)) * d6 / 2.0;
                }
            }
        }
        if (d5 == 1.0) {
            d2 -= d6 / 2.0;
        } else if (d4 == -1.0) {
            d2 = string.equals("end") ? (d2 -= d7) : (d2 += d7);
        } else if (d5 == -1.0) {
            if (string.equals("end")) {
                d2 -= d6 / 2.0;
                d3 -= d7 / 2.0;
            } else {
                d2 += d6 / 2.0;
                d3 += d7 / 2.0;
            }
        }
        if (d2 != 0.0 || d3 != 0.0) {
            text.updateTransform(Affine.makeTransform(d2, d3));
        }
    }
}

