/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.asynchronous;

import com.ibm.vis.engine.internal.RaveRunnable;
import com.ibm.vis.engine.internal.asynchronous.AsynchDelegate;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class AsynchAction
implements AsynchDelegate,
RaveRunnable {
    AsynchDelegate delegate;
    protected boolean cleared = false;
    List<AsynchAction> children;

    void registerListener(AsynchDelegate asynchDelegate) {
        this.delegate = asynchDelegate;
    }

    public void failed(String string) {
        this.notifyFailed(string);
    }

    public void done() {
        this.notifyComplete(this);
    }

    public void addAction(AsynchAction asynchAction) {
        asynchAction.registerListener(this);
        if (this.children == null) {
            this.children = new ArrayList<AsynchAction>();
        }
        this.children.add(asynchAction);
    }

    @Override
    public void notifyComplete(AsynchAction asynchAction) {
        boolean bl = true;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                if (this.children.get(i) == asynchAction) {
                    this.children.remove(i--);
                    continue;
                }
                bl = false;
            }
        }
        if (bl) {
            if (this.delegate != null) {
                this.delegate.notifyComplete(this);
            }
        } else {
            this.runInternal();
        }
    }

    @Override
    public void notifyFailed(String string) {
        this.clear();
        if (this.delegate != null) {
            this.delegate.notifyFailed(string);
        }
    }

    protected void runInternal() {
        if (!this.cleared && this.children != null && this.children.size() > 0) {
            AsynchAction asynchAction = this.children.get(0);
            asynchAction.run();
        }
    }

    void clear() {
        this.cleared = true;
        if (this.children != null) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                AsynchAction asynchAction = this.children.get(0);
                asynchAction.clear();
                this.children.remove(0);
            }
        }
    }

    @Override
    public abstract void run();
}

