/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data;

import com.ibm.json.java.JSONArray;
import com.ibm.vis.engine.dataProviderService.internal.DataProviderServiceDelegate;
import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.data.DataProviderConverter;
import com.ibm.vis.engine.internal.data.DerivedData;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.geo.GeoData;
import com.ibm.vis.engine.internal.data.geo.GeoMatcher;
import com.ibm.vis.engine.internal.data.geo.GeoPropertiesMatcher;
import com.ibm.vis.engine.internal.data.geo.NoDataMatcher;
import com.ibm.vis.engine.internal.data.transform.Density;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.data.transform.Distribution;
import com.ibm.vis.engine.internal.data.transform.Grouping;
import com.ibm.vis.engine.internal.data.transform.Integrate;
import com.ibm.vis.engine.internal.data.transform.Order;
import com.ibm.vis.engine.internal.data.transform.Percent;
import com.ibm.vis.engine.internal.data.transform.Smooth;
import com.ibm.vis.engine.internal.data.transform.Summary;
import com.ibm.vis.engine.internal.data.transform.Transform;
import com.ibm.vis.engine.internal.data.transform.TransformType;
import com.ibm.vis.engine.internal.grammar.scale.ScaleFitInfo;
import com.ibm.vis.engine.internal.grammar.scale.ScaleGeometry;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpanBuilder;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.LogLevel;
import com.ibm.vis.spec.internal.AugmentSpec;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.DerivedGroupSpec;
import com.ibm.vis.spec.internal.DerivedInputFieldSpec;
import com.ibm.vis.spec.internal.DerivedOutputFieldSpec;
import com.ibm.vis.spec.internal.FieldRefSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.ArrayList;

public class Data
extends IdentifiableItem {
    private DataProviderConverter dataProviderAdapter;
    public Field[] fields;
    public Field[] keyField;
    private final int index;
    public final VisContext visContext;
    public GeoData augmentation;
    private int rowCountBeforeAugmentation;
    public Row[] rows;
    private DerivedData derived;
    private Data source;
    private int[] dataIndexes;
    private String transformType;
    private boolean transformPrimaryRows;
    private final VisInterface vis;
    private final DataSpec spec;
    private boolean complete = false;
    private boolean populating = false;

    public Data(String string, VisInterface visInterface, DataSpec dataSpec, int n) {
        super(string, visInterface);
        this.vis = visInterface;
        this.spec = dataSpec;
        this.index = n;
        this.transformType = null;
        this.transformPrimaryRows = false;
        this.visContext = visInterface.getVisContext();
        this.dataProviderAdapter = dataSpec.provider != null ? DataProviderServiceDelegate.getInstance().getDataProvider(this, visInterface, dataSpec) : null;
        if (this.dataProviderAdapter == null || this.dataProviderAdapter.isReady()) {
            this.continueDataCreation();
        }
    }

    public void continueDataCreation() {
        if (!this.populating) {
            this.populating = true;
            if (this.dataProviderAdapter != null) {
                this.dataProviderAdapter.setFields();
                this.dataProviderAdapter.setRows();
            }
            if (this.spec.source == null) {
                this.source = null;
                this.dataIndexes = new int[]{this.index};
                this.rows = this.spec.rows == null ? new Row[]{} : this.makeSimpleRows(this.spec.rows);
                this.fields = this.makeFields(this.spec, this.vis);
            } else {
                this.source = (Data)this.vis.getByID(this.spec.source.$ref);
                if (this.source == null) {
                    throw new SpecException("The source '" + this.spec.source.$ref + "' was not found (a derived data table must follow its source in the specification)", ErrorCode.SPEC_UNABLE_TO_LOCATE_DATA, null);
                }
                this.makeDerivedData(this.vis, this.spec);
                int n = 0;
                Field[] fieldArray = this;
                while (fieldArray != null) {
                    ++n;
                    fieldArray = fieldArray.source;
                }
                this.dataIndexes = new int[n];
                fieldArray = this;
                for (int i = 0; i < n; ++i) {
                    this.dataIndexes[i] = fieldArray.index;
                    fieldArray = fieldArray.source;
                }
            }
            this.augmentation = this.augmentData(this.spec, true);
            if (this.visContext.getLogger().hasListeners()) {
                this.visContext.getLogger().log(LogLevel.Info, LogComponent.CommonGrammar, "Built fields", "fieldCount", this.fields.length);
                this.visContext.getLogger().log(LogLevel.Info, LogComponent.CommonGrammar, "Built rows", "rowCount", this.rows.length);
            }
            ArrayList<Field> arrayList = new ArrayList<Field>();
            for (Field field : this.fields) {
                if (field.isKey) {
                    arrayList.add(field);
                }
                if (field.range.isComplete() || this.isPdf()) continue;
                field.range = super.makeDefaultRange(field, this.rows);
                if (!this.visContext.getLogger().hasListeners()) continue;
                this.visContext.getLogger().log(LogLevel.Trace, LogComponent.CommonGrammar, "Created default range", "field", field.id);
            }
            if (arrayList.size() == 0) {
                this.keyField = null;
            } else {
                this.keyField = new Field[arrayList.size()];
                for (int i = 0; i < this.keyField.length; ++i) {
                    this.keyField[i] = (Field)arrayList.get(i);
                }
            }
            this.complete = true;
        }
    }

    public void refreshRows(DataSpec dataSpec) {
        if (this.dataProviderAdapter != null) {
            this.dataProviderAdapter.setRows();
        }
        if (this.isDerived()) {
            this.derived.getGrouping().setInput(this.source.rows);
            this.rows = this.derived.calculate(this.source.rows);
        } else {
            this.rows = dataSpec.rows != null ? this.makeSimpleRows(dataSpec.rows) : new Row[0];
        }
        this.augmentation = this.augmentData(dataSpec, false);
    }

    public final boolean isDerived() {
        return this.source != null;
    }

    final Data getSource() {
        return this.source;
    }

    final String getTransformType() {
        return this.transformType;
    }

    final boolean hasPrimaryRows() {
        return this.transformPrimaryRows;
    }

    private void makeDerivedData(VisInterface visInterface, DataSpec dataSpec) {
        int n;
        String string;
        this.transformType = string = dataSpec.type;
        ArrayList<Field> arrayList = new ArrayList<Field>();
        ArrayList<DerivedField> arrayList2 = this.makeInputDefinitions(dataSpec, visInterface);
        int n2 = -1;
        for (DerivedField object22 : arrayList2) {
            if (!"weight".equals(object22.role)) continue;
            n2 = object22.inputIndex;
        }
        ArrayList<DerivedField> arrayList3 = this.makeGroupDefinitions(dataSpec, visInterface, this.source.rows, n2, arrayList);
        ArrayList<DerivedField> arrayList4 = this.makeOutputDefinitions(dataSpec, visInterface, arrayList);
        this.fields = new Field[arrayList.size()];
        int n3 = 0;
        for (Field field : arrayList) {
            this.fields[n3++] = field;
        }
        Grouping grouping = new Grouping(arrayList3, this.source.rows);
        Transform transform = this.makeTransform(string, arrayList2, arrayList4, dataSpec, this.source);
        assert (transform != null);
        this.transformPrimaryRows = transform.hasPrimaryRows();
        this.derived = new DerivedData(grouping, transform);
        this.rows = this.derived.calculate(this.source.rows);
        for (DerivedField derivedField : arrayList4) {
            transform.finishOutputField(derivedField, this.source.fields, this.fields);
        }
        int n4 = this.fields.length;
        dataSpec.fields = new FieldSpec[n4];
        for (n = 0; n < n4; ++n) {
            dataSpec.fields[n] = this.fields[n].getFieldSpec();
        }
        n = this.rows.length;
        dataSpec.rows = new double[n][];
        for (int i = 0; i < n; ++i) {
            dataSpec.rows[i] = this.rows[i].data;
        }
    }

    private GeoData augmentData(DataSpec dataSpec, boolean bl) {
        VisJSONSpec visJSONSpec = this.vis.getCurrentSpec();
        int n = this.rowCountBeforeAugmentation = this.rows == null ? 0 : this.rows.length;
        if (visJSONSpec == null || visJSONSpec.augment == null || visJSONSpec.augment.length == 0) {
            return null;
        }
        AugmentSpec augmentSpec = this.findAugmentSpec(visJSONSpec.augment, dataSpec == visJSONSpec.data[0]);
        if (augmentSpec == null) {
            return null;
        }
        JSONArray jSONArray = GeoData.readFeatures(augmentSpec.source, this.visContext, visJSONSpec);
        GeoMatcher geoMatcher = augmentSpec.sourceKeys != null ? new GeoPropertiesMatcher(dataSpec, augmentSpec.sourceKeys, augmentSpec.dataKeys, "includeAllSource".equals(augmentSpec.method), jSONArray, this.visContext) : new NoDataMatcher(jSONArray);
        GeoData geoData = GeoData.read(augmentSpec.thinningDistanceFraction, augmentSpec.transform, augmentSpec.includeInRange, geoMatcher, this.visContext);
        this.addExtraRows(geoData);
        if (bl) {
            this.addExtraFields(geoData, augmentSpec.sourceFields, this.vis);
        }
        this.addExtraFieldsToRows(geoData, augmentSpec.sourceFields);
        return geoData;
    }

    private AugmentSpec findAugmentSpec(AugmentSpec[] augmentSpecArray, boolean bl) {
        for (AugmentSpec augmentSpec : augmentSpecArray) {
            if (augmentSpec.target != null && augmentSpec.target.$ref.equals(this.id)) {
                return augmentSpec;
            }
            if (augmentSpec.target != null || augmentSpec.dataKeys == null) continue;
            for (FieldRefSpec fieldRefSpec : augmentSpec.dataKeys) {
                Field field = (Field)this.vis.getByID(fieldRefSpec.$ref);
                if (field == null || field.data != this) continue;
                return augmentSpec;
            }
        }
        if (bl) {
            for (AugmentSpec augmentSpec : augmentSpecArray) {
                if (augmentSpec.target != null) continue;
                return augmentSpec;
            }
        }
        return null;
    }

    private void addExtraRows(GeoData geoData) {
        if (geoData.size() > this.rows.length) {
            int n;
            int n2;
            Row[] rowArray = this.rows;
            this.rows = new Row[geoData.size()];
            for (n2 = 0; n2 < rowArray.length; ++n2) {
                this.rows[n2] = rowArray[n2];
            }
            n2 = this.fields.length;
            double[] dArray = new double[n2];
            for (n = 0; n < n2; ++n) {
                dArray[n] = Double.NaN;
            }
            for (n = rowArray.length; n < this.rows.length; ++n) {
                this.rows[n] = Row.createRow(dArray, n);
            }
        }
    }

    private void addExtraFields(GeoData geoData, FieldSpec[] fieldSpecArray, VisInterface visInterface) {
        int n;
        if (fieldSpecArray == null || fieldSpecArray.length == 0) {
            return;
        }
        Field[] fieldArray = this.fields;
        this.fields = new Field[fieldArray.length + fieldSpecArray.length];
        for (n = 0; n < fieldArray.length; ++n) {
            this.fields[n] = fieldArray[n];
        }
        for (n = 0; n < fieldSpecArray.length; ++n) {
            FieldSpec fieldSpec = fieldSpecArray[n];
            if (fieldSpec.categories == null) {
                fieldSpec.categories = geoData.propertyCategories(fieldSpecArray[n].id);
            }
            this.fields[n + fieldArray.length] = Field.createSimpleField(visInterface, fieldSpec, this, n + fieldArray.length, null);
        }
    }

    private void addExtraFieldsToRows(GeoData geoData, FieldSpec[] fieldSpecArray) {
        if (fieldSpecArray == null || fieldSpecArray.length == 0) {
            return;
        }
        int n = this.fields.length - fieldSpecArray.length;
        for (int i = 0; i < this.rows.length; ++i) {
            int n2;
            Row row = this.rows[i];
            Row row2 = Row.createEmptyRow(this.fields.length, row.index);
            for (n2 = 0; n2 < n; ++n2) {
                row2.data[n2] = row.data[n2];
            }
            for (n2 = 0; n2 < fieldSpecArray.length; ++n2) {
                Number number = geoData.getPropertyAsNumber(i, fieldSpecArray[n2].id);
                row2.data[n + n2] = number == null ? Double.NaN : number.doubleValue();
            }
            this.rows[i] = row2;
        }
    }

    public int[] getRowsWithoutAugmentedRows(int[] nArray) {
        if (nArray == null) {
            return nArray;
        }
        if (this.rows.length == this.rowCountBeforeAugmentation) {
            return nArray;
        }
        boolean bl = false;
        for (int i = 0; !bl && i < nArray.length; ++i) {
            bl = nArray[i] >= this.rowCountBeforeAugmentation;
        }
        if (!bl) {
            return nArray;
        }
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= this.rowCountBeforeAugmentation) continue;
            intPrimitiveArrayList.add(nArray[i]);
        }
        return intPrimitiveArrayList.toArray();
    }

    private Transform makeTransform(String string, ArrayList<DerivedField> arrayList, ArrayList<DerivedField> arrayList2, DataSpec dataSpec, Data data) {
        Transform transform = null;
        if (TransformType.isType("smooth", string)) {
            transform = new Smooth(arrayList, arrayList2, this.visContext.getLogger(), string);
        } else if (TransformType.isType("density", string)) {
            transform = new Density(arrayList, arrayList2, this.visContext.getLogger());
        } else if (TransformType.isType("summary", string)) {
            transform = new Summary(arrayList, arrayList2, this.visContext.getLogger(), data);
        } else if (TransformType.isType("percent", string)) {
            transform = new Percent(arrayList, arrayList2, this.visContext.getLogger());
        } else if (TransformType.isType("distribution", string)) {
            transform = new Distribution(arrayList, arrayList2, this.visContext.getLogger(), string);
        } else if (TransformType.isType("integrate", string)) {
            transform = new Integrate(arrayList, arrayList2, this.visContext.getLogger());
        } else if (TransformType.isType("order", string)) {
            transform = new Order(arrayList, arrayList2, this.visContext.getLogger());
        }
        if (transform == null) {
            throw new IllegalStateException("unknown transform " + string);
        }
        return transform;
    }

    private ArrayList<DerivedField> makeGroupDefinitions(DataSpec dataSpec, VisInterface visInterface, Row[] rowArray, int n, ArrayList<Field> arrayList) {
        ArrayList<DerivedField> arrayList2 = new ArrayList<DerivedField>();
        DerivedGroupSpec[] derivedGroupSpecArray = dataSpec.group;
        if (derivedGroupSpecArray == null) {
            return arrayList2;
        }
        for (DerivedGroupSpec derivedGroupSpec : derivedGroupSpecArray) {
            DerivedField derivedField;
            Object object;
            Field field = (Field)visInterface.getByID(derivedGroupSpec.input.$ref);
            FieldSpec fieldSpec = derivedGroupSpec.output;
            if (fieldSpec != null) {
                object = Field.createSimpleField(visInterface, fieldSpec, this, arrayList.size(), field.unit);
                ((Field)object).copyDerivedInfo(field);
                ((Field)object).setSourceField(field.id);
                ((Field)object).setSourceOperation("group");
                if (((Field)object).order == null && fieldSpec.order != null && ((Field)object).categories != null) {
                    ((Field)object).order = Field.computeCategoriesOrder(((Field)object).categories, fieldSpec.order);
                }
                if (((Field)object).range == null) {
                    ((Field)object).copyRange(field);
                }
                arrayList.add((Field)object);
                derivedField = DerivedField.createThroughputField("group", field.getIndex(), ((Field)object).getIndex(), field.range, field.categories, null, fieldSpec);
                if (!field.isCategorical()) {
                    if (derivedGroupSpec.granularity != null) {
                        derivedField.derivedField.granularity = derivedGroupSpec.granularity;
                    }
                    this.setBinningParameters(field, rowArray, n, derivedField);
                    Number number = derivedField.derivedField.granularity;
                    if (derivedGroupSpec.granularity != null) {
                        number = derivedGroupSpec.granularity;
                    }
                    ((Field)object).granularity = number.doubleValue();
                }
            } else {
                object = Data.findFieldByID(dataSpec, derivedGroupSpec.input.$ref);
                derivedField = DerivedField.createInputField("group", field.getIndex(), field.range, field.categories, null, (FieldSpec)object);
                if (!field.isCategorical()) {
                    this.setBinningParameters(field, rowArray, n, derivedField);
                }
            }
            arrayList2.add(derivedField);
        }
        return arrayList2;
    }

    private static FieldSpec findFieldByID(DataSpec dataSpec, String string) {
        if (dataSpec.fields == null || string == null) {
            return null;
        }
        for (FieldSpec fieldSpec : dataSpec.fields) {
            if (!string.equals(fieldSpec.id)) continue;
            return fieldSpec;
        }
        return null;
    }

    private void setBinningParameters(Field field, Row[] rowArray, int n, DerivedField derivedField) {
        if (field.granularity != null) {
            derivedField.derivedField.granularity = field.granularity;
            return;
        }
        double d = 0.0;
        if (n < 0) {
            d = rowArray.length;
        } else {
            for (Row row : rowArray) {
                double d2 = row.data[n];
                if (Double.isNaN(d2) || !(d2 > 0.0)) continue;
                d += d2;
            }
        }
        int n2 = (int)Math.round(3.0 + Math.log(d) * Math.log(d) / Math.log(20.0));
        if (n2 < 4) {
            n2 = 4;
        }
        ScaleFitInfo scaleFitInfo = new ScaleFitInfo(true, false, false, null);
        ScaleSpan scaleSpan = ScaleSpanBuilder.createForRange(field.range, field.unit, scaleFitInfo, n2, null, field.getSpecifiedFormatter(), this.visContext, null, null);
        boolean bl = false;
        int n3 = 0;
        scaleSpan.setupForExtent(ScaleGeometry.makeUnsized(false));
        while (!bl) {
            scaleSpan.setupForTickCount(n2, n2);
            int n4 = Math.min(4, rowArray.length);
            if (this.getBinCounts(scaleSpan, rowArray, field) < n4) {
                ++n2;
            } else {
                bl = true;
            }
            if (++n3 <= 15) continue;
            bl = true;
        }
        double d3 = scaleSpan.getTickMin();
        double d4 = scaleSpan.getTickSize();
        if (derivedField.parameters.binStart == null) {
            derivedField.parameters.binStart = d3;
        }
        if (derivedField.derivedField.granularity == null) {
            derivedField.outputGranularity = d4;
            derivedField.derivedField.granularity = d4;
        }
    }

    private int getBinCounts(ScaleSpan scaleSpan, Row[] rowArray, Field field) {
        double d = scaleSpan.getTickMin();
        double d2 = scaleSpan.getTickSize();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < rowArray.length; ++i) {
            String string;
            Row row = rowArray[i];
            double[] dArray = row.data;
            double d3 = dArray[field.getIndex()];
            if (Double.isNaN(d3)) continue;
            double d4 = Math.floor((d3 - d) / d2);
            double d5 = (d4 + 0.5) * d2 + d;
            String string2 = string = d5 == (double)((int)d5) ? (int)d5 + "|" : d5 + "|";
            if (this.contains(arrayList, string)) continue;
            arrayList.add(string);
        }
        return arrayList.size();
    }

    private boolean contains(ArrayList<String> arrayList, String string) {
        for (String string2 : arrayList) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<DerivedField> makeInputDefinitions(DataSpec dataSpec, VisInterface visInterface) {
        ArrayList<DerivedField> arrayList = new ArrayList<DerivedField>();
        DerivedInputFieldSpec[] derivedInputFieldSpecArray = dataSpec.input;
        if (derivedInputFieldSpecArray == null) {
            return arrayList;
        }
        for (DerivedInputFieldSpec derivedInputFieldSpec : derivedInputFieldSpecArray) {
            String string = derivedInputFieldSpec.role;
            Field field = (Field)visInterface.getByID(derivedInputFieldSpec.field.$ref);
            DerivedField derivedField = DerivedField.createInputField(string, field.getIndex(), field.range, field.categories, null, null);
            arrayList.add(derivedField);
        }
        return arrayList;
    }

    private ArrayList<DerivedField> makeOutputDefinitions(DataSpec dataSpec, VisInterface visInterface, ArrayList<Field> arrayList) {
        ArrayList<DerivedField> arrayList2 = new ArrayList<DerivedField>();
        DerivedOutputFieldSpec[] derivedOutputFieldSpecArray = dataSpec.output;
        if (derivedOutputFieldSpecArray == null) {
            return arrayList2;
        }
        for (DerivedOutputFieldSpec derivedOutputFieldSpec : derivedOutputFieldSpecArray) {
            String string = derivedOutputFieldSpec.role;
            FieldSpec fieldSpec = derivedOutputFieldSpec.field;
            if (fieldSpec == null) {
                fieldSpec = new FieldSpec();
            }
            Field field = Field.createSimpleField(visInterface, fieldSpec, this, arrayList.size(), null);
            DerivedField derivedField = null;
            if (derivedOutputFieldSpec.input != null) {
                Field field2 = (Field)visInterface.getByID(derivedOutputFieldSpec.input.$ref);
                if (field2 != null) {
                    if (fieldSpec.unit == null) {
                        field.unit = field2.unit;
                    }
                    field.copyDerivedInfo(field2);
                    derivedField = DerivedField.createThroughputField(string, field2.getIndex(), field.getIndex(), field2.range, field2.categories, derivedOutputFieldSpec.parameters, derivedOutputFieldSpec.field);
                }
            } else {
                derivedField = DerivedField.createOutputField(string, field.getIndex(), derivedOutputFieldSpec.parameters, derivedOutputFieldSpec.field);
            }
            arrayList.add(field);
            arrayList2.add(derivedField);
        }
        return arrayList2;
    }

    private Field[] makeFields(DataSpec dataSpec, VisInterface visInterface) {
        if (dataSpec == null || dataSpec.fields == null) {
            return new Field[0];
        }
        FieldSpec[] fieldSpecArray = dataSpec.fields;
        Field[] fieldArray = new Field[fieldSpecArray.length];
        for (int i = 0; i < fieldArray.length; ++i) {
            fieldArray[i] = Field.createSimpleField(visInterface, fieldSpecArray[i], this, i, null);
        }
        return fieldArray;
    }

    private Range makeDefaultRange(Field field, Row[] rowArray) {
        if (field.range.isComplete()) {
            return field.range;
        }
        return field.range.complete(this.computeDataRange(field, rowArray));
    }

    private Range computeDataRange(Field field, Row[] rowArray) {
        Range range = Range.EMPTY;
        if (field.unit == Unit.COUNT) {
            range = new Range(0.0, 0.0);
        }
        int n = field.getIndex();
        for (Row row : rowArray) {
            double d;
            if (row.data.length <= n || Double.isNaN(d = row.data[n])) continue;
            range = range.unionValue(d);
        }
        return range;
    }

    private Row[] makeSimpleRows(double[][] dArray) {
        double[][] dArray2 = dArray;
        Row[] rowArray = new Row[dArray2.length];
        for (int i = 0; i < rowArray.length; ++i) {
            rowArray[i] = Row.createRow(dArray2[i], i);
        }
        return rowArray;
    }

    public final int getIndex() {
        return this.index;
    }

    public final int[] getDataIndexes() {
        return this.dataIndexes;
    }

    public String getKey(Row row) {
        return this.makeKey(row, this.keyField);
    }

    private String makeKey(Row row, Field[] fieldArray) {
        if (fieldArray == null) {
            return null;
        }
        String string = fieldArray[0].getUnformattedStringValue(row, false);
        for (int i = 1; i < fieldArray.length; ++i) {
            string = string + "|" + fieldArray[i].getUnformattedStringValue(row, false);
        }
        return string;
    }

    public String getKeyWithDefaultFields(Row row, Field[] fieldArray) {
        Field[] fieldArray2 = this.keyField == null ? fieldArray : this.keyField;
        return this.makeKey(row, fieldArray2);
    }

    public void matchDensityWithAreaUnderCurve(double d) {
        if (this.isPdf()) {
            this.derived.getTransform().setMultiplier(d);
            this.rows = this.derived.calculate(this.source.rows);
            for (Field field : this.fields) {
                if (!Double.isNaN(d) && field.getIndex() != this.derived.getTransform().getOutputIndex("y")) continue;
                field.range = Range.EMPTY;
                field.range = this.makeDefaultRange(field, this.rows);
            }
        }
    }

    public boolean isPdf() {
        return this.derived != null && this.derived.getTransform().isPdf();
    }

    public boolean isComplete() {
        return this.complete;
    }
}

